/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncCopier;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IChecksumProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ShareFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SharesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class SegmentedStoreUtils {
    private static final IFreeSpaceProvider DUMMY_FREE_SPACE_PROVIDER = new IFreeSpaceProvider(){

        @Override
        public long freeSpaceKb(HostAwareFile path) throws IOException {
            return Long.MAX_VALUE;
        }
    };
    private static final String RSYNC_EXEC = "rsync";
    private static final Pattern SHARE_ID_PATTERN = Pattern.compile("[0-9]+");
    private static final Comparator<Share> SHARE_COMPARATOR = new Comparator<Share>(){

        @Override
        public int compare(Share o1, Share o2) {
            return o1.getShareId().compareTo(o2.getShareId());
        }
    };
    private static final FileFilter FILTER_ON_SHARES = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (!FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(pathname)) {
                return false;
            }
            String name = pathname.getName();
            return SHARE_ID_PATTERN.matcher(name).matches();
        }
    };

    public static File[] getShares(File storeRootDir) {
        Object[] files = FileOperations.getMonitoredInstanceForCurrentThread().listFiles(storeRootDir, FILTER_ON_SHARES);
        if (files == null) {
            throw new ConfigurationFailureException("Store folder does not exist or cannot be accessed: " + storeRootDir);
        }
        Arrays.sort(files);
        return files;
    }

    public static String findIncomingShare(File incomingFolder, File storeRoot, ISimpleLogger logger) {
        IFileOperations fileOp = FileOperations.getMonitoredInstanceForCurrentThread();
        if (!fileOp.isDirectory(incomingFolder)) {
            throw new ConfigurationFailureException("Incoming folder does not exist or is not a folder: " + incomingFolder);
        }
        if (!fileOp.isDirectory(storeRoot)) {
            throw new ConfigurationFailureException("Store root does not exist or is not a folder: " + storeRoot);
        }
        File testFile = new File(incomingFolder, ".DDS_TEST");
        try {
            fileOp.createNewFile(testFile);
        }
        catch (IOExceptionUnchecked ex) {
            throw new ConfigurationFailureException("Couldn't create a test file in the following incoming folder: " + incomingFolder, ex);
        }
        File matchingShare = SegmentedStoreUtils.findShare(testFile, storeRoot, logger);
        return matchingShare.getName();
    }

    private static File findShare(File testFile, File storeRoot, ISimpleLogger logger) {
        File[] fileArray = SegmentedStoreUtils.getShares(storeRoot);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File share = fileArray[n2];
            File destination = new File(share, testFile.getName());
            if (testFile.renameTo(destination)) {
                destination.delete();
                Share shareObject = new ShareFactory().createShare(share, DUMMY_FREE_SPACE_PROVIDER, logger);
                if (shareObject.isWithdrawShare()) {
                    logger.log(LogLevel.WARN, "Incoming folder [" + testFile.getParent() + "] can not be assigned to share " + shareObject.getShareId() + " because its property " + "withdraw-share" + " is set to true.");
                }
                return share;
            }
            ++n2;
        }
        testFile.delete();
        throw new ConfigurationFailureException("No share could be found for the following incoming folder: " + testFile.getParentFile().getAbsolutePath());
    }

    public static List<Share> getSharesWithDataSets(File storeRoot, String dataStoreCode, boolean filterOutToBeIgnoredForShuffling, Set<String> incomingShares, IFreeSpaceProvider freeSpaceProvider, IEncapsulatedOpenBISService service, ISimpleLogger log) {
        long start = System.currentTimeMillis();
        List<Share> shares = SegmentedStoreUtils.getSharesWithDataSets(storeRoot, dataStoreCode, filterOutToBeIgnoredForShuffling, freeSpaceProvider, service, log, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
        for (Share share : shares) {
            share.setIncoming(incomingShares.contains(share.getShareId()));
        }
        log.log(LogLevel.INFO, String.format("Obtained the list of all datasets in all shares in %.2f s.", (double)(System.currentTimeMillis() - start) / 1000.0));
        return shares;
    }

    static List<Share> getSharesWithDataSets(File storeRoot, String dataStoreCode, boolean filterOutToBeIgnoredForShuffling, IFreeSpaceProvider freeSpaceProvider, IEncapsulatedOpenBISService service, ISimpleLogger log, ITimeProvider timeProvider) {
        Map<String, Share> shares = SegmentedStoreUtils.getShares(storeRoot, dataStoreCode, filterOutToBeIgnoredForShuffling, freeSpaceProvider, service, log, timeProvider);
        ArrayList<Share> list = new ArrayList<Share>(shares.values());
        Collections.sort(list, SHARE_COMPARATOR);
        return list;
    }

    private static Map<String, Share> getShares(File storeRoot, String dataStoreCode, boolean filterOutToBeIgnoredForShuffling, IFreeSpaceProvider freeSpaceProvider, IEncapsulatedOpenBISService service, ISimpleLogger log, ITimeProvider timeProvider) {
        HashMap<String, Share> shares = new HashMap<String, Share>();
        SharesHolder sharesHolder = new SharesHolder(dataStoreCode, shares, service, log, timeProvider);
        File[] fileArray = SegmentedStoreUtils.getShares(storeRoot);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Share share = new ShareFactory().createShare(sharesHolder, file, freeSpaceProvider, log);
            if (!filterOutToBeIgnoredForShuffling || !share.isIgnoredForShuffling()) {
                shares.put(share.getShareId(), share);
            }
            ++n2;
        }
        return shares;
    }

    public static void moveDataSetToAnotherShare(File dataSetDirInStore, File share, IEncapsulatedOpenBISService service, IShareIdManager shareIdManager, IChecksumProvider checksumProvider, ISimpleLogger logger) {
        if (!FileOperations.getMonitoredInstanceForCurrentThread().exists(dataSetDirInStore)) {
            logger.log(LogLevel.ERROR, "Data set '" + dataSetDirInStore + "' no longer exist in the data store.");
            return;
        }
        String dataSetCode = dataSetDirInStore.getName();
        AbstractExternalData dataSet = service.tryGetDataSet(dataSetCode);
        if (dataSet == null) {
            throw new UserFailureException("Unknown data set: " + dataSetCode);
        }
        shareIdManager.lock(dataSetCode);
        try {
            File oldShare = dataSetDirInStore.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            String relativePath = FileUtilities.getRelativeFilePath(oldShare, dataSetDirInStore);
            if (share.getName().equals(oldShare.getName())) {
                return;
            }
            File dataSetDirInNewShare = new File(share, relativePath);
            dataSetDirInNewShare.mkdirs();
            SegmentedStoreUtils.copyToShare(dataSetDirInStore, dataSetDirInNewShare, logger);
            long size = SegmentedStoreUtils.assertEqualSizeAndChildren(dataSetCode, dataSetDirInStore, dataSetDirInStore, dataSetDirInNewShare, dataSetDirInNewShare, checksumProvider);
            String shareId = share.getName();
            service.updateShareIdAndSize(dataSetCode, shareId, size);
            shareIdManager.setShareId(dataSetCode, shareId);
        }
        finally {
            shareIdManager.releaseLock(dataSetCode);
        }
        SegmentedStoreUtils.deleteDataSet(dataSetCode, dataSetDirInStore, shareIdManager, logger);
    }

    protected static void deleteDataSet(String dataSetCode, File dataSetDirInStore, IShareIdManager shareIdManager, ISimpleLogger logger) {
        logger.log(LogLevel.INFO, "Await for data set " + dataSetCode + " to be unlocked.");
        shareIdManager.await(dataSetCode);
        SegmentedStoreUtils.deleteDataSetInstantly(dataSetCode, dataSetDirInStore, logger);
    }

    public static void deleteDataSet(IDatasetLocation dataSet, IDataSetDirectoryProvider dataSetDirectoryProvider, IShareIdManager shareIdManager, ISimpleLogger logger) {
        String dataSetCode = dataSet.getDataSetCode();
        logger.log(LogLevel.INFO, "Await for data set " + dataSetCode + " to be unlocked.");
        shareIdManager.await(dataSetCode);
        File dataSetDirInStore = dataSetDirectoryProvider.getDataSetDirectory(dataSet);
        SegmentedStoreUtils.deleteDataSetInstantly(dataSetCode, dataSetDirInStore, logger);
    }

    public static void deleteDataSetInstantly(String dataSetCode, File dataSetDirInStore, ISimpleLogger logger) {
        logger.log(LogLevel.INFO, "Start deleting data set " + dataSetCode + " at " + dataSetDirInStore);
        boolean successful = FileUtilities.deleteRecursively(dataSetDirInStore);
        if (successful) {
            logger.log(LogLevel.INFO, "Data set " + dataSetCode + " at " + dataSetDirInStore + " has been successfully deleted.");
        } else {
            logger.log(LogLevel.WARN, "Deletion of data set " + dataSetCode + " at " + dataSetDirInStore + " failed.");
        }
    }

    public static void cleanUp(SimpleDataSetInformationDTO dataSet, File storeRoot, String newShareId, IShareIdManager shareIdManager, ISimpleLogger logger) {
        String dataSetCode = dataSet.getDataSetCode();
        String shareId = shareIdManager.getShareId(dataSetCode);
        String oldShareId = dataSet.getDataSetShareId();
        if (newShareId.equals(oldShareId)) {
            logger.log(LogLevel.WARN, "No clean up will be performed because for data set " + dataSetCode + " both shares are the same: " + oldShareId);
            return;
        }
        boolean currentIsOld = shareId.equals(oldShareId);
        boolean currentIsNew = shareId.equals(newShareId);
        if (!currentIsOld && !currentIsNew) {
            logger.log(LogLevel.WARN, "No clean up will be performed because data set " + dataSetCode + " is neither in share " + oldShareId + " nor in share " + newShareId + " but in share " + shareId + ".");
            return;
        }
        File shareFolder = new File(storeRoot, currentIsOld ? newShareId : oldShareId);
        String location = dataSet.getDataSetLocation();
        SegmentedStoreUtils.deleteDataSet(dataSetCode, new File(shareFolder, location), shareIdManager, logger);
    }

    private static void copyToShare(File file, File share, ISimpleLogger logger) {
        long start = System.currentTimeMillis();
        logger.log(LogLevel.INFO, String.format("Start moving directory '%s' to new share '%s'", file.getPath(), share.getPath()));
        RsyncCopier copier = new RsyncCopier(OSUtilities.findExecutable((String)RSYNC_EXEC));
        copier.copyContent(file, share);
        logger.log(LogLevel.INFO, String.format("Finished moving directory '%s' to new share '%s' in %.2f s", file.getPath(), share.getPath(), (double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private static long assertEqualSizeAndChildren(String dataSetCode, File sourceRoot, File source, File destinationRoot, File destination, IChecksumProvider checksumProvider) {
        SegmentedStoreUtils.assertSameName(source, destination);
        if (FileOperations.getMonitoredInstanceForCurrentThread().isFile(source)) {
            SegmentedStoreUtils.assertFile(destination);
            return SegmentedStoreUtils.assertSameSizeAndCheckSum(dataSetCode, sourceRoot, source, destinationRoot, destination, checksumProvider);
        }
        SegmentedStoreUtils.assertDirectory(destination);
        File[] sourceFiles = SegmentedStoreUtils.getFiles(source);
        File[] destinationFiles = SegmentedStoreUtils.getFiles(destination);
        SegmentedStoreUtils.assertSameNumberOfChildren(source, sourceFiles, destination, destinationFiles);
        long sum = 0L;
        int i = 0;
        while (i < sourceFiles.length) {
            sum += SegmentedStoreUtils.assertEqualSizeAndChildren(dataSetCode, sourceRoot, sourceFiles[i], destinationRoot, destinationFiles[i], checksumProvider);
            ++i;
        }
        return sum;
    }

    private static void assertSameNumberOfChildren(File source, File[] sourceFiles, File destination, File[] destinationFiles) {
        if (sourceFiles.length != destinationFiles.length) {
            throw new EnvironmentFailureException("Destination directory '" + destination.getAbsolutePath() + "' has " + destinationFiles.length + " files but source directory '" + source.getAbsolutePath() + "' has " + sourceFiles.length + " files.");
        }
    }

    private static long assertSameSizeAndCheckSum(String dataSetCode, File sourceRoot, File source, File destinationRoot, File destination, IChecksumProvider checksumProvider) {
        long destinationSize;
        IFileOperations fileOp = FileOperations.getMonitoredInstanceForCurrentThread();
        long sourceSize = fileOp.length(source);
        if (sourceSize != (destinationSize = fileOp.length(destination))) {
            throw new EnvironmentFailureException("Destination file '" + destination.getAbsolutePath() + "' has size " + destinationSize + " but source file '" + source.getAbsolutePath() + "' has size " + sourceSize + ".");
        }
        if (checksumProvider != null) {
            try {
                long sourceChecksum = checksumProvider.getChecksum(dataSetCode, FileUtilities.getRelativeFilePath(sourceRoot, source));
                long destinationChecksum = SegmentedStoreUtils.calculateCRC(destination);
                if (sourceChecksum != destinationChecksum) {
                    throw new EnvironmentFailureException("Destination file '" + destination.getAbsolutePath() + "' has checksum " + destinationChecksum + " but source file '" + source.getAbsolutePath() + "' has checksum " + sourceChecksum + ".");
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        return sourceSize;
    }

    private static int calculateCRC(File file) {
        try {
            return (int)FileUtils.checksumCRC32((File)file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private static void assertSameName(File source, File destination) {
        if (!source.getName().equals(destination.getName())) {
            throw new EnvironmentFailureException("Destination file '" + destination.getAbsolutePath() + "' has a different name than source file '" + source.getAbsolutePath() + ".");
        }
    }

    private static void assertFile(File file) {
        IFileOperations fileOp = FileOperations.getMonitoredInstanceForCurrentThread();
        if (!fileOp.exists(file)) {
            throw new EnvironmentFailureException("File does not exist: " + file.getAbsolutePath());
        }
        if (!fileOp.isFile(file)) {
            throw new EnvironmentFailureException("File is a directory: " + file.getAbsolutePath());
        }
    }

    private static void assertDirectory(File file) {
        IFileOperations fileOp = FileOperations.getMonitoredInstanceForCurrentThread();
        if (!fileOp.exists(file)) {
            throw new EnvironmentFailureException("Directory does not exist: " + file.getAbsolutePath());
        }
        if (!fileOp.isDirectory(file)) {
            throw new EnvironmentFailureException("Directory is a file: " + file.getAbsolutePath());
        }
    }

    private static File[] getFiles(File file) {
        Object[] files = FileOperations.getMonitoredInstanceForCurrentThread().listFiles(file);
        Arrays.sort(files);
        return files;
    }
}

