/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.api.gui;

import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.api.gui.AbstractWebStartClientServingServlet;
import ch.systemsx.cisd.openbis.generic.client.web.server.WebClientConfigurationProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetTypeFilter;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/data-set-uploader-launch.jnlp", "/openbis/data-set-uploader-launch.jnlp", "/openbis/openbis/data-set-uploader-launch.jnlp"})
public class DataSetUploadClientServingServlet
extends AbstractWebStartClientServingServlet {
    private static final Template JNLP_TEMPLATE = new Template("<?xml version='1.0' encoding='utf-8'?>\n<jnlp spec='1.0+' codebase='${base-URL}'>\n  <information>\n    <title>${title}</title>\n    <vendor>CISD</vendor>\n    <description>${description}</description>\n  </information>\n  <security>\n    <all-permissions/>\n  </security>\n  <resources>\n    <j2se version='1.5+'/>\n    <jar href='cisd-base.jar'/>\n    <jar href='spring.jar'/>\n    <jar href='stream-supporting-httpinvoker.jar'/>\n    <jar href='commons-codec.jar'/>\n    <jar href='commons-httpclient.jar'/>\n    <jar href='commons-io.jar'/>\n    <jar href='commons-lang.jar'/>\n    <jar href='commons-logging.jar'/>\n    <jar href='jython.jar'/>\n    <jar href='dss_upload_gui.jar'/>\n    <jar href='log4j.jar'/>\n    <jar href='poi.jar'/>\n    <jar href='poi-ooxml.jar'/>\n    <jar href='poi-ooxml-schemas.jar'/>\n    <jar href='dom4j-1.6.1.jar'/>\n    <jar href='geronimo-stax-api_1.0_spec-1.0.jar'/>\n    <jar href='xmlbeans-2.3.0.jar'/>\n    <property name='creatable-data-set-types-whitelist' value='${creatable-data-set-types-whitelist}' />    <property name='creatable-data-set-types-blacklist' value='${creatable-data-set-types-blacklist}' />  </resources>\n  <application-desc main-class='${main-class}'>\n    <argument>${service-URL}</argument>\n    <argument>${session-id}</argument>\n  </application-desc>\n</jnlp>");
    private static final String UPLOAD_GUI_SERVING_SERVLET_PATH = "dss_upload_gui";
    @Resource(name="common-server")
    private ICommonServer server;
    @Resource(name="web-client-configuration-provider")
    private WebClientConfigurationProvider webClientConfigurationProvider;
    private String codebaseUrl = null;

    @Override
    protected String getTitle() {
        return "Data Set Uploader";
    }

    @Override
    protected String getDescription() {
        return "A client for uploading data sets";
    }

    @Override
    protected String getMainClassName() {
        return "ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClient";
    }

    @Override
    protected Template getJnlpTemplate() {
        return JNLP_TEMPLATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getCodebaseUrl(HttpServletRequest request) {
        DataSetUploadClientServingServlet dataSetUploadClientServingServlet = this;
        synchronized (dataSetUploadClientServingServlet) {
            if (this.codebaseUrl == null) {
                this.codebaseUrl = String.valueOf(this.server.getDefaultPutDataStoreBaseURL(this.getSessionToken(request))) + "/datastore_server/" + UPLOAD_GUI_SERVING_SERVLET_PATH;
            }
        }
        return this.codebaseUrl;
    }

    @Override
    protected String bindTemplateParameters(HttpServletRequest request, Template template) {
        String sessionToken = super.bindTemplateParameters(request, template);
        template.bind("creatable-data-set-types-whitelist", this.getCreatableDataSetTypesWhitelistString());
        template.bind("creatable-data-set-types-blacklist", this.getCreatableDataSetTypesBlacklistString());
        return sessionToken;
    }

    private String getCreatableDataSetTypesWhitelistString() {
        return this.getCreatableDataSetTypesString(this.webClientConfigurationProvider.getWebClientConfiguration().tryCreatableDataSetTypePatternsWhitelist());
    }

    private String getCreatableDataSetTypesBlacklistString() {
        return this.getCreatableDataSetTypesString(this.webClientConfigurationProvider.getWebClientConfiguration().tryCreatableDataSetTypePatternsBlacklist());
    }

    private String getCreatableDataSetTypesString(List<String> creatableTypes) {
        return DataSetTypeFilter.convertPatternListToString(creatableTypes);
    }
}

