/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GlobalSearchTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.SearchableEntitySelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.EnterKeyListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ButtonWithLoadingMask;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.google.gwt.user.client.History;

public final class SearchWidget
extends LayoutContainer {
    private static final String PREFIX = "openbis_search-widget_";
    static final String TEXT_FIELD_ID = "openbis_search-widget_text-field";
    static final String SUBMIT_BUTTON_ID = "openbis_search-widget_submit-button";
    static final String ENTITY_CHOOSER_ID = "openbis_search-widget_entity-chooser";
    private final SearchableEntitySelectionWidget entityChooser;
    private final TextField<String> textField;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final ButtonWithLoadingMask searchButton;
    private final EnterKeyListener enterKeyListener;

    public SearchWidget(IViewContext<ICommonClientServiceAsync> viewContext) {
        TableRowLayout tableRowLayout = SearchWidget.createLayout();
        this.setLayout((Layout)tableRowLayout);
        this.viewContext = viewContext;
        this.searchButton = this.createSearchButton();
        this.enterKeyListener = new EnterKeyListener(){

            @Override
            protected final void onEnterKey() {
                SearchWidget.this.doSearch();
            }
        };
        this.textField = this.createTextField();
        this.entityChooser = this.createEntityChooser();
        this.add((Component)this.entityChooser);
        this.add((Component)this.textField);
        this.add((Component)this.searchButton);
        this.layout();
    }

    private final SearchableEntitySelectionWidget createEntityChooser() {
        SearchableEntitySelectionWidget comboBox = new SearchableEntitySelectionWidget(this.viewContext);
        comboBox.setStyleAttribute("marginRight", "3px");
        comboBox.setId(ENTITY_CHOOSER_ID);
        comboBox.setWidth(100);
        return comboBox;
    }

    private static final TableRowLayout createLayout() {
        TableRowLayout tableRowLayout = new TableRowLayout();
        tableRowLayout.setBorder(0);
        tableRowLayout.setCellPadding(0);
        tableRowLayout.setCellSpacing(0);
        return tableRowLayout;
    }

    private final TextField<String> createTextField() {
        TextField field = new TextField();
        field.setId(TEXT_FIELD_ID);
        field.setWidth(200);
        field.addKeyListener((KeyListener)this.enterKeyListener);
        field.setStyleAttribute("marginRight", "3px");
        return field;
    }

    private final void doSearch() {
        String queryText = (String)this.textField.getValue();
        if (StringUtils.isBlank(queryText)) {
            return;
        }
        if (SearchWidget.hasOnlyWildcards(queryText)) {
            MessageBox.alert((String)this.viewContext.getMessage("messagebox_warning", new Object[0]), (String)this.viewContext.getMessage("too_generic", queryText), null);
            return;
        }
        this.textField.setValue((Object)"");
        SearchableEntity selectedEntity = this.entityChooser.getSelectedSearchableEntity();
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            String entityDescription = selectedEntity != null ? selectedEntity.getName() : null;
            String url = SearchWidget.createGlobalSearchLink(entityDescription, queryText);
            History.newItem((String)url);
        } else {
            GlobalSearchTabItemFactory.openTabIfEntitiesFound(this.viewContext, selectedEntity, queryText);
        }
    }

    private static boolean hasOnlyWildcards(String queryText) {
        boolean onlyWildcard = true;
        char[] cArray = queryText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '*' && c != '?') {
                onlyWildcard = false;
                break;
            }
            ++n2;
        }
        return onlyWildcard;
    }

    public static String createGlobalSearchLink(String searchableEntity, String queryText) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "GLOBAL_SEARCH");
        if (searchableEntity != null) {
            url.addParameter("type", searchableEntity);
        }
        url.addParameter("query", queryText);
        return url.toStringWithoutDelimiterPrefix();
    }

    private final ButtonWithLoadingMask createSearchButton() {
        ButtonWithLoadingMask button = new ButtonWithLoadingMask(this.viewContext.getMessage("search_button", new Object[0]), SUBMIT_BUTTON_ID){

            @Override
            public final void doButtonClick() {
                SearchWidget.this.doSearch();
            }
        };
        return button;
    }
}

