/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.administration;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;

public class ActiveUsersCountAction
implements IDelegatedAction {
    private final IViewContext<?> viewContext;

    public ActiveUsersCountAction(IViewContext<?> viewContext) {
        this.viewContext = viewContext;
    }

    @Override
    public void execute() {
        this.viewContext.getCommonService().countActiveUsers(new MessageBoxCallback((IViewContext)this.viewContext));
    }

    private static class ConfirmationDialogCallback
    extends AbstractAsyncCallback<Void> {
        private ConfirmationDialogCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void r) {
            MessageBox.info((String)this.viewContext.getMessage("messagebox_info", new Object[0]), (String)this.viewContext.getMessage("active_users_email_sent_confirmation", new Object[0]), null);
        }
    }

    private static class MessageBoxCallback
    extends AbstractAsyncCallback<Integer> {
        private MessageBoxCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Integer result) {
            MessageBox mb = new MessageBox();
            mb.setTitle(this.viewContext.getMessage("messagebox_warning", new Object[0]));
            mb.setMessage(this.viewContext.getMessage("active_users_dialog", result, "<a href=\"mailto:cisd.helpdesk@bsse.ethz.ch\" target=\"_blank\">CISD Helpdesk</a>"));
            mb.setIcon(MessageBox.WARNING);
            mb.setButtons("okcancel");
            mb.addCallback((Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent be) {
                    String value = be.getButtonClicked().getItemId();
                    if ("ok".equals(value)) {
                        MessageBoxCallback.this.viewContext.getCommonService().sendCountActiveUsersEmail(new ConfirmationDialogCallback(MessageBoxCallback.this.viewContext));
                    }
                }
            });
            mb.show();
        }
    }
}

