/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.PersonModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import java.util.List;

public final class PersonSelectionWidget
extends DropDownList<PersonModel, Person> {
    public static final String SUFFIX = "person";
    private final IViewContext<?> viewContext;

    public PersonSelectionWidget(IViewContext<?> viewContext, String idSuffix) {
        super(viewContext, SUFFIX + idSuffix, SUFFIX, "code", SUFFIX, "persons");
        this.viewContext = viewContext;
        this.setAutoSelectFirst(false);
    }

    public final Person tryGetSelectedPerson() {
        return (Person)super.tryGetSelected();
    }

    public final String tryGetSelectedPersonCode() {
        Person person = (Person)super.tryGetSelected();
        return person == null ? null : person.getUserId();
    }

    @Override
    protected List<PersonModel> convertItems(List<Person> result) {
        return PersonModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<Person>> callback) {
        this.viewContext.getCommonService().listActivePersons(callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PERSON);
    }
}

