/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ChosenEntitySetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.EntityChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;

public class ExperimentChooserField
extends ChosenEntitySetter<TableModelRowWithObject<Experiment>> {
    private static final String EXPERIMENT_IDENTIFIER_WITHOUT_GROUP_PATTERN = "/[a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+";
    private static final String EXPERIMENT_IDENTIFIER_WITH_GROUP_PATTERN = "[a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+";
    public static final String EXPERIMENT_IDENTIFIER_PATTERN = "([a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+)|(/[a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+/[a-zA-Z0-9_\\-\\.]+)";

    public static ExperimentChooserFieldAdaptor create(String labelField, boolean mandatory, ExperimentIdentifier initialValueOrNull, final IViewContext<ICommonClientServiceAsync> viewContext) {
        ExperimentChooserField chooserField = new ExperimentChooserField(mandatory, initialValueOrNull, viewContext){

            protected void onTriggerClick(ComponentEvent ce) {
                super.onTriggerClick(ce);
                ExperimentChooserField.browse(viewContext, this);
            }
        };
        chooserField.setFieldLabel(labelField);
        return new ExperimentChooserFieldAdaptor(){

            @Override
            public Field<?> getField() {
                return ExperimentChooserField.this;
            }

            @Override
            public ExperimentChooserField getChooserField() {
                return ExperimentChooserField.this;
            }

            @Override
            public ExperimentIdentifier tryToGetValue() {
                return ExperimentChooserField.this.tryGetIdentifier();
            }

            @Override
            public void updateOriginalValue() {
                ExperimentIdentifier valueOrNull = this.tryToGetValue();
                String textValue = valueOrNull == null ? "" : valueOrNull.getIdentifier();
                ExperimentChooserField.this.setOriginalValue(textValue);
            }

            @Override
            public void updateValue(ExperimentIdentifier identifierOrNull) {
                ExperimentChooserField.this.updateValue(identifierOrNull);
            }
        };
    }

    private static void browse(IViewContext<ICommonClientServiceAsync> viewContext, ChosenEntitySetter<TableModelRowWithObject<Experiment>> chosenEntityField) {
        DisposableEntityChooser<TableModelRowWithObject<Experiment>> browser = ExperimentBrowserGrid.createChooser(viewContext);
        String title = viewContext.getMessage("TITLE_CHOOSE_EXPERIMENT", new Object[0]);
        new EntityChooserDialog<TableModelRowWithObject<Experiment>>(browser, chosenEntityField, title, viewContext, new Button[0]).show();
    }

    @Override
    public String renderEntity(TableModelRowWithObject<Experiment> entity) {
        return this.print(ExperimentIdentifier.createIdentifier(entity.getObjectOrNull()));
    }

    private ExperimentIdentifier tryGetIdentifier() {
        String ident = (String)this.getValue();
        if (StringUtils.isBlank(ident)) {
            return null;
        }
        return new ExperimentIdentifier(ident);
    }

    private String print(ExperimentIdentifier chosenEntity) {
        return chosenEntity.getIdentifier();
    }

    private ExperimentChooserField(boolean mandatory, ExperimentIdentifier initialValueOrNull, IViewContext<ICommonClientServiceAsync> viewContext) {
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setValidateOnBlur(true);
        this.setAutoValidate(true);
        this.setRegex(EXPERIMENT_IDENTIFIER_PATTERN);
        this.getMessages().setRegexText(viewContext.getMessage("incorrect_experiment_syntax", new Object[0]));
        this.updateValue(initialValueOrNull);
    }

    public void updateValue(ExperimentIdentifier initialValueOrNull) {
        if (initialValueOrNull != null) {
            super.setValue((Object)this.print(initialValueOrNull));
        }
    }

    /* synthetic */ ExperimentChooserField(boolean bl, ExperimentIdentifier experimentIdentifier, IViewContext iViewContext, ExperimentChooserField experimentChooserField) {
        this(bl, experimentIdentifier, iViewContext);
    }

    public static interface ExperimentChooserFieldAdaptor {
        public Field<?> getField();

        public ExperimentChooserField getChooserField();

        public ExperimentIdentifier tryToGetValue();

        public void updateOriginalValue();

        public void updateValue(ExperimentIdentifier var1);
    }
}

