/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.user.client.ui.Widget;

public class AttachmentFileUploadField
extends FileUploadField {
    private final AttachmentsFileSet fileSet;

    public AttachmentFileUploadField(IMessageProvider messageProvider) {
        this.setFireChangeEventOnSetValue(true);
        this.fileSet = new AttachmentsFileSet(messageProvider, this);
    }

    public FieldSet getFieldSet() {
        return this.fileSet;
    }

    public void addFieldsTo(FormPanel form, String sessionKey, IMessageProvider messageProvider) {
        FileUploadField fileUploadField = this.fileSet.getFileUploadField();
        fileUploadField.setFieldLabel(messageProvider.getMessage("file", new Object[0]));
        fileUploadField.setName(sessionKey);
        form.add((Widget)fileUploadField);
        form.add((Widget)this.fileSet.getDescriptionField());
        form.add((Widget)this.fileSet.getTitleField());
    }

    public NewAttachment tryExtractAttachment() {
        if (StringUtils.isBlank(this.getFilePathValue())) {
            return null;
        }
        NewAttachment attachment = new NewAttachment();
        attachment.setFilePath(this.getFilePathValue());
        attachment.setTitle(this.getTitleValue());
        attachment.setDescription(this.getDescriptionValue());
        return attachment;
    }

    public void reset() {
        super.reset();
        this.fileSet.reset();
    }

    private String getFilePathValue() {
        return this.getFileInput().getValue();
    }

    private String getDescriptionValue() {
        return (String)this.fileSet.getDescriptionField().getValue();
    }

    private String getTitleValue() {
        return (String)this.fileSet.getTitleField().getValue();
    }

    private static final class AttachmentsFileSet
    extends FieldSet {
        private final FileUploadField fileUploadField;
        private VarcharField titleField;
        private DescriptionField descriptionField;

        public AttachmentsFileSet(IMessageProvider messageProvider, FileUploadField fileUploadField) {
            this.fileUploadField = fileUploadField;
            this.createForm(messageProvider);
        }

        public void reset() {
            this.titleField.reset();
            this.descriptionField.reset();
        }

        private void createForm(IMessageProvider messageProvider) {
            this.setHeading(messageProvider.getMessage("attachment", new Object[0]));
            this.setLayout((Layout)this.createFormLayout());
            this.setWidth(689);
            this.add((Component)this.getFileUploadField());
            this.descriptionField = new DescriptionField(messageProvider, false);
            this.add((Component)this.descriptionField);
            this.titleField = this.createTitleField(messageProvider.getMessage("title", new Object[0]));
            this.add((Component)this.titleField);
        }

        private final FormLayout createFormLayout() {
            FormLayout formLayout = new FormLayout();
            formLayout.setLabelWidth(109);
            formLayout.setDefaultWidth(500);
            return formLayout;
        }

        private final VarcharField createTitleField(String label) {
            VarcharField varcharField = new VarcharField(label, false);
            varcharField.setMaxLength(100);
            return varcharField;
        }

        public DescriptionField getDescriptionField() {
            return this.descriptionField;
        }

        public final VarcharField getTitleField() {
            return this.titleField;
        }

        public FileUploadField getFileUploadField() {
            return this.fileUploadField;
        }
    }
}

