/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import java.util.ArrayList;
import java.util.List;

class GridColumnChooser {
    private final Grid<ColumnDataModel> grid;

    public GridColumnChooser(AbstractColumnSettingsDataModelProvider columnDataModelProvider, IMessageProvider messageProvider) {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig addressColumn = new ColumnConfig("header", messageProvider.getMessage("GRID_COLUMN_NAME_HEADER", new Object[0]), 300);
        ColumnConfig idColumn = new ColumnConfig("address", messageProvider.getMessage("how_to_address", new Object[0]), 300);
        configs.add(addressColumn);
        configs.add(idColumn);
        for (ColumnConfig column : configs) {
            column.setSortable(false);
            column.setMenuDisabled(true);
        }
        this.grid = new Grid(GridColumnChooser.createStore(columnDataModelProvider.getColumnDataModels()), new ColumnModel(configs));
        this.grid.setHideHeaders(false);
        this.grid.getSelectionModel().setSelectionMode(Style.SelectionMode.MULTI);
    }

    private static ListStore<ColumnDataModel> createStore(List<ColumnDataModel> list) {
        ListStore store = new ListStore();
        store.add(list);
        return store;
    }

    public Component getComponent() {
        ContentPanel cp = new ContentPanel();
        cp.setHeaderVisible(false);
        this.grid.setAutoWidth(true);
        this.grid.setAutoHeight(true);
        cp.add(this.grid);
        cp.setScrollMode(Style.Scroll.AUTOY);
        return cp;
    }

    public List<String> getSelectedItems() {
        ArrayList<String> result = new ArrayList<String>();
        List items = this.grid.getSelectionModel().getSelectedItems();
        for (ColumnDataModel item : items) {
            result.add(item.getAddress());
        }
        return result;
    }
}

