/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterModel
extends SimplifiedBaseModelData {
    public static FilterModel COLUMN_FILTER_MODEL = FilterModel.createColumnFilter();
    public static final String COLUMN_FILTER = "Column Filter";
    private static final long serialVersionUID = 1L;

    public FilterModel(GridCustomFilter filter) {
        this.set("name", filter.getName());
        this.set("description", filter.getDescription());
        this.set("object", filter);
        this.set("tooltip", TooltipRenderer.renderAsTooltip(filter.getName(), filter.getDescription()));
    }

    public static final List<FilterModel> convert(List<GridCustomFilter> filters, boolean withColumnFilter) {
        ArrayList<FilterModel> result = new ArrayList<FilterModel>();
        for (GridCustomFilter filter : filters) {
            result.add(new FilterModel(filter));
        }
        if (withColumnFilter) {
            result.add(0, COLUMN_FILTER_MODEL);
        }
        return result;
    }

    private static FilterModel createColumnFilter() {
        GridCustomFilter allSampleType = new GridCustomFilter();
        allSampleType.setName(COLUMN_FILTER);
        return new FilterModel(allSampleType);
    }
}

