/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableComposite;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectDataSetsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectEntitySection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectExperimentsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectMaterialsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectSamplesSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MetaprojectEntities
extends LayoutContainer
implements IDisposableComponent {
    public static final String ID_SUFFIX = "_metaproject-entities";
    public static final EventType ENTITIES_CHANGED = new EventType();
    private IViewContext<?> viewContext;
    private SectionsPanel sectionsPanel;
    private Map<EntityKind, DisposableTabContent> sectionsMap = new LinkedHashMap<EntityKind, DisposableTabContent>();
    private Long currentMetaprojectId;
    private EntityKind currentEntityKind;
    private DisposableComposite composite = new DisposableComposite((Component)this);

    public MetaprojectEntities(IViewContext<?> viewContext, String idPrefix) {
        this.viewContext = viewContext;
        this.setLayout((Layout)new FitLayout());
        this.setId(String.valueOf(idPrefix) + ID_SUFFIX);
    }

    private void initSections(final Long metaprojectId, final IDelegatedAction callback) {
        this.clearSections();
        final Html loading = new Html(this.viewContext.getMessage("load_in_progress", new Object[0]));
        this.add((Component)loading);
        this.layout();
        this.viewContext.getCommonService().getMetaprojectAssignmentsCount(metaprojectId, (AsyncCallback<MetaprojectAssignmentsCount>)new AbstractAsyncCallback<MetaprojectAssignmentsCount>(this.viewContext){

            @Override
            protected void process(MetaprojectAssignmentsCount count) {
                MetaprojectEntities.this.sectionsPanel = new SectionsPanel(this.viewContext.getCommonViewContext(), MetaprojectEntities.this.getElement().getId());
                if (count.getExperimentCount() > 0) {
                    MetaprojectEntities.this.addSection(EntityKind.EXPERIMENT, new MetaprojectExperimentsSection(this.viewContext, new TechId(metaprojectId)));
                }
                if (count.getSampleCount() > 0) {
                    MetaprojectEntities.this.addSection(EntityKind.SAMPLE, new MetaprojectSamplesSection(this.viewContext, new TechId(metaprojectId)));
                }
                if (count.getDataSetCount() > 0) {
                    MetaprojectEntities.this.addSection(EntityKind.DATA_SET, new MetaprojectDataSetsSection(this.viewContext, new TechId(metaprojectId)));
                }
                if (count.getMaterialCount() > 0) {
                    MetaprojectEntities.this.addSection(EntityKind.MATERIAL, new MetaprojectMaterialsSection(this.viewContext, new TechId(metaprojectId)));
                }
                if (MetaprojectEntities.this.sectionsMap.isEmpty()) {
                    MetaprojectEntities.this.remove((Component)loading);
                    MetaprojectEntities.this.clearSections();
                } else {
                    if (MetaprojectEntities.this.hasSection(MetaprojectEntities.this.currentEntityKind)) {
                        MetaprojectEntities.this.selectSection(MetaprojectEntities.this.currentEntityKind);
                    } else {
                        MetaprojectEntities.this.currentEntityKind = (EntityKind)MetaprojectEntities.this.sectionsMap.entrySet().iterator().next().getKey();
                        MetaprojectEntities.this.sectionsPanel.selectFirstSection();
                    }
                    MetaprojectEntities.this.remove((Component)loading);
                    MetaprojectEntities.this.add((Component)MetaprojectEntities.this.sectionsPanel);
                    MetaprojectEntities.this.layout();
                }
                if (callback != null) {
                    callback.execute();
                }
            }
        });
    }

    private void clearSections() {
        if (this.sectionsPanel != null) {
            this.sectionsPanel.removeFromParent();
            this.sectionsPanel = null;
        }
        this.sectionsMap.clear();
        this.composite.clearSubcomponents();
    }

    private boolean hasSection(EntityKind entityKind) {
        return this.sectionsMap.containsKey(entityKind);
    }

    private void addSection(EntityKind entityKind, final MetaprojectEntitySection section) {
        section.addListener(MetaprojectEntitySection.SECTION_CHANGED_EVENT, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                MetaprojectEntities.this.fireEvent(ENTITIES_CHANGED);
            }
        });
        this.sectionsPanel.addSection(section);
        this.sectionsMap.put(entityKind, section);
        this.composite.addSubcomponent(new IDisposableComponentProvider(){

            @Override
            public IDisposableComponent getDisposableComponent() {
                return section.tryGetDisposableComponentOrNull();
            }
        });
    }

    private void selectSection(EntityKind entityKind) {
        DisposableTabContent section = this.sectionsMap.get(entityKind);
        if (section != null && this.sectionsPanel != null) {
            this.sectionsPanel.selectSection(section);
        }
    }

    public void showEntities(Long metaprojectId, IDelegatedAction callback) {
        if (this.currentMetaprojectId != metaprojectId) {
            this.currentMetaprojectId = metaprojectId;
            this.currentEntityKind = null;
            this.initSections(metaprojectId, callback);
        }
    }

    public void showEntities(Long metaprojectId, EntityKind entityKind, IDelegatedAction callback) {
        if (this.currentMetaprojectId != metaprojectId) {
            this.currentMetaprojectId = metaprojectId;
            this.currentEntityKind = entityKind;
            this.initSections(metaprojectId, callback);
        } else {
            this.currentEntityKind = entityKind;
            this.selectSection(entityKind);
            if (callback != null) {
                callback.execute();
            }
        }
    }

    public void hideEntities() {
        this.currentMetaprojectId = null;
        this.currentEntityKind = null;
        this.clearSections();
    }

    public void refresh() {
        if (this.currentMetaprojectId != null) {
            this.initSections(this.currentMetaprojectId, IDelegatedAction.DO_NOTHING);
        }
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refresh();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.composite.getRelevantModifications();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }
}

