/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericConstants;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyTermValidator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VocabularyTermGrid
extends TypedTableGrid<VocabularyTermWithStats> {
    private static final int LABEL_WIDTH = 100;
    private static final int FIELD_WIDTH = 350;
    private static final int FIELD_WIDTH_IN_REPLACEMENT_DIALOG = 200;
    private static final int LABEL_WIDTH_IN_REPLACEMENT_DIALOG = 200;
    private static final String BROWSER_ID = "openbis_vocabulary-term-browser";
    private final IDelegatedAction postRegistrationCallback;
    private final Vocabulary vocabulary;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, Vocabulary vocabulary) {
        return new VocabularyTermGrid(viewContext, vocabulary).asDisposableWithoutToolbar();
    }

    private VocabularyTermGrid(IViewContext<ICommonClientServiceAsync> viewContext, Vocabulary vocabulary) {
        super(viewContext, VocabularyTermGrid.createBrowserId(vocabulary), true, DisplayTypeIDGenerator.VOCABULARY_TERMS_GRID);
        this.vocabulary = vocabulary;
        this.postRegistrationCallback = this.createRefreshGridAction();
        this.extendBottomToolbar();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<VocabularyTermWithStats>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<VocabularyTermWithStats>> definitions = super.createColumnsDefinition();
        definitions.setGridCellRendererFor("URL", LinkRenderer.createExternalLinkRenderer());
        definitions.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return definitions;
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("add_vocabulary_terms_button", new Object[0]));
        addButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                VocabularyTermGrid.this.createAddNewTermsDialog().show();
            }
        });
        this.addButton(addButton);
        Button batchUpdateButton = new Button(this.viewContext.getMessage("update_vocabulary_terms_button", new Object[0]));
        batchUpdateButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                VocabularyTermGrid.this.createUpdateTermsDialog().show();
            }
        });
        this.addButton(batchUpdateButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit_vocabulary_term_button", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<VocabularyTermWithStats>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<VocabularyTermWithStats>> selectedItem, boolean keyPressed) {
                VocabularyTermWithStats term = selectedItem.getBaseObject().getObjectOrNull();
                VocabularyTermGrid.this.createEditDialog(term.getTerm()).show();
            }
        });
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("delete_vocabulary_terms_button", new Object[0]), new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                VocabularyTermGrid.this.deleteTerms();
            }
        });
        this.addButton(deleteButton);
        if (this.getWebClientConfiguration().getAllowAddingUnofficialTerms()) {
            Button makeOfficialButton = new Button(this.viewContext.getMessage("make_official_vocabulary_term_button", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    VocabularyTermGrid.this.makeOfficial();
                }
            });
            this.addButton(makeOfficialButton);
        }
        if (this.vocabulary.isManagedInternally()) {
            String tooltip = this.viewContext.getMessage("tooltip_vocabulary_managed_internally", new Object[0]);
            this.disableButton(addButton, tooltip);
            this.disableButton(batchUpdateButton, tooltip);
            this.disableButton(editButton, tooltip);
            this.disableButton(deleteButton, tooltip);
        } else {
            this.allowMultipleSelection();
        }
        this.addEntityOperationsSeparator();
    }

    private Window createEditDialog(final VocabularyTerm term) {
        String code = term.getCode();
        String description = term.getDescription();
        String label = term.getLabel();
        String title = this.viewContext.getMessage("edit_title", "Vocabulary Term", code);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback, label, description){
            private final DescriptionField descriptionField;
            private final TextField<String> labelField;
            private final VocabularyTermSelectionWidget termSelectionWidget;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.form.setLabelWidth(100);
                this.form.setFieldWidth(350);
                this.setWidth(500);
                boolean mandatory = false;
                this.labelField = 6.createTextField(VocabularyTermGrid.this.viewContext.getMessage("label", new Object[0]), mandatory);
                FieldUtil.setValueWithUnescaping(this.labelField, string);
                this.labelField.setMaxLength(128);
                this.addField((Widget)this.labelField);
                this.descriptionField = 6.createDescriptionField(VocabularyTermGrid.this.viewContext, mandatory);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, string2);
                this.addField((Widget)this.descriptionField);
                if (VocabularyTermGrid.this.vocabulary.isChosenFromList()) {
                    this.termSelectionWidget = this.createTermSelectionWidget();
                    this.addField((Widget)this.termSelectionWidget);
                } else {
                    this.termSelectionWidget = null;
                }
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                term.setDescription((String)this.descriptionField.getValue());
                term.setLabel((String)this.labelField.getValue());
                if (this.termSelectionWidget != null) {
                    term.setOrdinal(this.extractPreviousTermOrdinal() + 1L);
                }
                ((ICommonClientServiceAsync)VocabularyTermGrid.this.viewContext.getService()).updateVocabularyTerm(term, registrationCallback);
            }

            private VocabularyTermSelectionWidget createTermSelectionWidget() {
                List allTerms = VocabularyTermGrid.this.getTerms();
                String previousTermCodeOrNull = null;
                int i = 0;
                while (i < allTerms.size()) {
                    String currentTermCode = ((VocabularyTerm)allTerms.get(i)).getCode();
                    if (term.getCode().equals(currentTermCode)) {
                        allTerms.remove(i);
                        break;
                    }
                    previousTermCodeOrNull = currentTermCode;
                    ++i;
                }
                boolean mandatory = false;
                VocabularyTermSelectionWidget result = new VocabularyTermSelectionWidget(String.valueOf(this.getId()) + "_edit_pos", "Position after", mandatory, allTerms, previousTermCodeOrNull);
                result.setEmptyText("empty value == beginning");
                return result;
            }

            private Long extractPreviousTermOrdinal() {
                VocabularyTermModel selectedItem = (VocabularyTermModel)this.termSelectionWidget.getValue();
                return selectedItem != null ? selectedItem.getTerm().getOrdinal() : 0L;
            }
        };
    }

    private void disableButton(Button button, String tooltip) {
        button.setEnabled(false);
        GWTUtils.setToolTip((Component)button, tooltip);
    }

    public static String createBrowserId(Vocabulary vocabulary) {
        return VocabularyTermGrid.createBrowserId(TechId.create(vocabulary));
    }

    public static String createBrowserId(TechId vocabularyId) {
        return "openbis_vocabulary-term-browser-" + vocabularyId;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<VocabularyTermWithStats>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<VocabularyTermWithStats>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listVocabularyTerms(this.vocabulary, resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<VocabularyTermWithStats>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportVocabularyTerms(exportCriteria, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.startsWith("TERM") ? columnID : columnID.toLowerCase();
    }

    private Window createUpdateTermsDialog() {
        String title = this.viewContext.getMessage("update_vocabulary_terms_title", this.vocabulary.getCode());
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            public static final String ID = "openbis_vocabulary-content-edit_form";
            protected final String termsSessionKey;
            {
                this.termsSessionKey = ID + VocabularyTermGrid.this.vocabulary.getId();
                this.form.setLabelWidth(50);
                this.form.setFieldWidth(400);
                this.setWidth(500);
                this.form.setAction(GenericConstants.createServicePath("upload"));
                this.form.setEncoding(FormPanel.Encoding.MULTIPART);
                this.form.setMethod(FormPanel.Method.POST);
                this.form.add(AbstractRegistrationForm.createHiddenField("sessionKeysNumber", "1"));
                this.form.add(AbstractRegistrationForm.createHiddenSessionField(this.termsSessionKey, 0));
                this.insert(this.createMessageField(), 0);
                this.addField((Widget)this.createImportFileField());
                this.form.addListener(Events.Submit, (Listener)new FormPanelListener(new InfoBox(VocabularyTermGrid.this.viewContext)){

                    @Override
                    protected void onSuccessfullUpload() {
                        ((ICommonClientServiceAsync)VocabularyTermGrid.this.viewContext.getService()).updateVocabularyTerms(termsSessionKey, TechId.create(VocabularyTermGrid.this.vocabulary), (AsyncCallback<Void>)new AbstractAsyncCallback<Void>(VocabularyTermGrid.this.viewContext){

                            @Override
                            protected void process(Void result) {
                                VocabularyTermGrid.this.postRegistrationCallback.execute();
                                this.hide();
                            }
                        });
                    }

                    @Override
                    protected void setUploadEnabled() {
                    }
                });
                this.saveButton.removeAllListeners();
                this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public final void componentSelected(ButtonEvent ce) {
                        if (form.isValid()) {
                            form.submit();
                        }
                    }
                });
                DialogWithOnlineHelpUtils.addHelpButton(VocabularyTermGrid.this.viewContext, this, this.createHelpPageIdentifier());
            }

            private FileUploadField createImportFileField() {
                BasicFileFieldManager fileManager = new BasicFileFieldManager(this.termsSessionKey, 1, "File");
                fileManager.setMandatory();
                return (FileUploadField)fileManager.getFields().get(0);
            }

            private Widget createMessageField() {
                LabelField messageField = new LabelField();
                messageField.setStyleAttribute("margin-left", "5px");
                String fileFormat = VocabularyTermGrid.this.viewContext.getMessage("vocabulary_terms_file_format", new Object[0]);
                String exportMsg = VocabularyTermGrid.this.viewContext.getMessage("update_vocabulary_terms_message_2", new Object[0]);
                String msgText = VocabularyTermGrid.this.viewContext.getMessage("update_vocabulary_terms_message", fileFormat, exportMsg);
                messageField.setText(msgText);
                return messageField;
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.TERM, HelpPageIdentifier.HelpPageAction.BATCH_UPDATE);
            }
        };
    }

    private Window createAddNewTermsDialog() {
        String title = this.viewContext.getMessage("add_vocabulary_terms_title", new Object[0]);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final VocabularyTermSelectionWidget termSelectionWidget;
            private final TextArea newTermCodesArea;
            {
                this.form.setLabelWidth(100);
                this.form.setFieldWidth(350);
                this.setWidth(500);
                this.newTermCodesArea = this.createNewTermCodesArea();
                this.addField((Widget)this.newTermCodesArea);
                if (VocabularyTermGrid.this.vocabulary.isChosenFromList()) {
                    this.termSelectionWidget = this.createTermSelectionWidget();
                    this.addField((Widget)this.termSelectionWidget);
                } else {
                    this.termSelectionWidget = null;
                }
                DialogWithOnlineHelpUtils.addHelpButton(VocabularyTermGrid.this.viewContext, this, this.createHelpPageIdentifier());
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                List<VocabularyTerm> newVocabularyTermCodes = this.extractNewVocabularyTermCodes();
                Long previousTermOrdinal = this.extractPreviousTermOrdinal();
                ((ICommonClientServiceAsync)VocabularyTermGrid.this.viewContext.getService()).addVocabularyTerms(TechId.create(VocabularyTermGrid.this.vocabulary), newVocabularyTermCodes, previousTermOrdinal, registrationCallback);
            }

            private TextArea createNewTermCodesArea() {
                TextArea result = new TextArea();
                result.setFieldLabel(VocabularyTermGrid.this.viewContext.getMessage("terms", new Object[0]));
                result.setEmptyText(VocabularyTermGrid.this.viewContext.getMessage("vocabulary_terms_empty", new Object[0]));
                result.setValidator((Validator)new VocabularyTermValidator(VocabularyTermGrid.this.viewContext));
                return result;
            }

            private VocabularyTermSelectionWidget createTermSelectionWidget() {
                List allTerms = VocabularyTermGrid.this.getTerms();
                String lastTermCodeOrNull = allTerms.size() > 0 ? ((VocabularyTerm)allTerms.get(allTerms.size() - 1)).getCode() : null;
                boolean mandatory = false;
                VocabularyTermSelectionWidget result = new VocabularyTermSelectionWidget(String.valueOf(this.getId()) + "_add_pos", "Position after", mandatory, allTerms, lastTermCodeOrNull);
                result.setEmptyText("empty value == beginning");
                return result;
            }

            private List<VocabularyTerm> extractNewVocabularyTermCodes() {
                return VocabularyTermValidator.getTerms((String)this.newTermCodesArea.getValue());
            }

            private Long extractPreviousTermOrdinal() {
                if (this.termSelectionWidget == null) {
                    List allTerms = VocabularyTermGrid.this.getTerms();
                    return allTerms.size() > 0 ? ((VocabularyTerm)allTerms.get(allTerms.size() - 1)).getOrdinal() : 0L;
                }
                VocabularyTermModel selectedItem = (VocabularyTermModel)this.termSelectionWidget.getValue();
                return selectedItem != null ? selectedItem.getTerm().getOrdinal() : 0L;
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.TERM, HelpPageIdentifier.HelpPageAction.REGISTER);
            }
        };
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE", "LABEL");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DATA_SET), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.DATA_SET), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.MATERIAL), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.MATERIAL), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM)};
    }

    private void deleteTerms() {
        List terms = this.getSelectedItems();
        if (terms.isEmpty()) {
            return;
        }
        if (terms.size() == this.getTerms().size()) {
            MessageBox.alert((String)this.viewContext.getMessage("delete_vocabulary_terms_invalid_title", new Object[0]), (String)this.viewContext.getMessage("delete_vocabulary_terms_invalid_message", new Object[0]), null);
            return;
        }
        HashSet<String> selectedTerms = new HashSet<String>();
        ArrayList<VocabularyTerm> termsToBeDeleted = new ArrayList<VocabularyTerm>();
        ArrayList<VocabularyTermReplacement> termsToBeReplaced = new ArrayList<VocabularyTermReplacement>();
        for (BaseEntityModel model : terms) {
            VocabularyTerm term = ((VocabularyTermWithStats)model.getBaseObject().getObjectOrNull()).getTerm();
            selectedTerms.add(term.getCode());
            if (((VocabularyTermWithStats)model.getBaseObject().getObjectOrNull()).getTotalUsageCounter() > 0) {
                VocabularyTermReplacement termToBeReplaced = new VocabularyTermReplacement();
                termToBeReplaced.setTerm(term);
                termsToBeReplaced.add(termToBeReplaced);
                continue;
            }
            termsToBeDeleted.add(term);
        }
        this.deleteAndReplace(selectedTerms, termsToBeDeleted, termsToBeReplaced);
    }

    private void deleteAndReplace(Set<String> selectedTerms, final List<VocabularyTerm> termsToBeDeleted, final List<VocabularyTermReplacement> termsToBeReplaced) {
        if (termsToBeReplaced.isEmpty()) {
            String title = this.viewContext.getMessage("delete_vocabulary_terms_confirmation_title", new Object[0]);
            int size = termsToBeDeleted.size();
            String message = size == 1 ? this.viewContext.getMessage("delete_vocabulary_terms_confirmation_message_no_replacements_singular", new Object[0]) : this.viewContext.getMessage("delete_vocabulary_terms_confirmation_message_no_replacements", size);
            ConfirmationDialog confirmationDialog = new ConfirmationDialog(title, message){

                @Override
                protected void onYes() {
                    VocabularyTermGrid.this.deleteAndReplace(termsToBeDeleted, termsToBeReplaced);
                }
            };
            confirmationDialog.show();
        } else {
            ArrayList<VocabularyTerm> termsForReplacement = new ArrayList<VocabularyTerm>();
            for (VocabularyTerm term : this.getTerms()) {
                if (selectedTerms.contains(term.getCode())) continue;
                termsForReplacement.add(term);
            }
            this.askForReplacements(termsToBeDeleted, termsToBeReplaced, termsForReplacement);
        }
    }

    private void makeOfficial() {
        List terms = this.getSelectedItems();
        if (terms.isEmpty()) {
            return;
        }
        HashSet<String> selectedTerms = new HashSet<String>();
        final ArrayList<VocabularyTerm> termsToBeOfficial = new ArrayList<VocabularyTerm>();
        for (BaseEntityModel model : terms) {
            VocabularyTerm term = ((VocabularyTermWithStats)model.getBaseObject().getObjectOrNull()).getTerm();
            selectedTerms.add(term.getCode());
            termsToBeOfficial.add(term);
        }
        String title = this.viewContext.getMessage("make_official_vocabulary_terms_confirmation_title", new Object[0]);
        int size = termsToBeOfficial.size();
        String message = size == 1 ? this.viewContext.getMessage("make_official_vocabulary_terms_confirmation_message_singular", new Object[0]) : this.viewContext.getMessage("make_official_vocabulary_terms_confirmation_message", size);
        ConfirmationDialog confirmationDialog = new ConfirmationDialog(title, message){

            @Override
            protected void onYes() {
                RefreshCallback callback = new RefreshCallback(VocabularyTermGrid.this.viewContext);
                ((ICommonClientServiceAsync)VocabularyTermGrid.this.viewContext.getService()).makeVocabularyTermsOfficial(TechId.create(VocabularyTermGrid.this.vocabulary), termsToBeOfficial, callback);
            }
        };
        confirmationDialog.show();
    }

    private List<VocabularyTerm> getTerms() {
        ArrayList<VocabularyTerm> terms = new ArrayList<VocabularyTerm>();
        for (VocabularyTermWithStats v : this.getContainedGridElements()) {
            terms.add(v.getTerm());
        }
        return terms;
    }

    private void askForReplacements(final List<VocabularyTerm> termsToBeDeleted, final List<VocabularyTermReplacement> termsToBeReplaced, List<VocabularyTerm> termsForReplacement) {
        VerticalPanel panel = new VerticalPanel();
        int totalNumber = termsToBeDeleted.size() + termsToBeReplaced.size();
        panel.add((Widget)new Text(this.viewContext.getMessage("delete_vocabulary_terms_confirmation_message_for_replacements", totalNumber)));
        final FormPanel formPanel = new FormPanel();
        formPanel.setLabelWidth(200);
        formPanel.setFieldWidth(200);
        formPanel.setBorders(false);
        formPanel.setHeaderVisible(false);
        formPanel.setBodyBorder(false);
        panel.add((Widget)formPanel);
        String title = this.viewContext.getMessage("delete_vocabulary_terms_confirmation_title", new Object[0]);
        String okButtonLable = this.viewContext.getMessage("add_vocabulary_terms_ok_button", new Object[0]);
        final SimpleDialog dialog = new SimpleDialog((Widget)panel, title, okButtonLable, this.viewContext, new Button[0]);
        dialog.setScrollMode(Style.Scroll.AUTOY);
        dialog.setWidth(450);
        dialog.setEnableOfAcceptButton(false);
        for (final VocabularyTermReplacement termToBeReplaced : termsToBeReplaced) {
            String term = termToBeReplaced.getTerm().getCode();
            VocabularyTermSelectionWidget s = new VocabularyTermSelectionWidget(String.valueOf(this.getId()) + term, term, true, termsForReplacement, null);
            s.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<VocabularyTermModel>(){

                public void selectionChanged(SelectionChangedEvent<VocabularyTermModel> se) {
                    VocabularyTermModel selectedItem = (VocabularyTermModel)se.getSelectedItem();
                    termToBeReplaced.setReplacementCode(selectedItem == null ? null : selectedItem.getTerm().getCode());
                    dialog.setEnableOfAcceptButton(formPanel.isValid());
                }
            });
            formPanel.add((Widget)s);
        }
        dialog.setAcceptAction(new IDelegatedAction(){

            @Override
            public void execute() {
                VocabularyTermGrid.this.deleteAndReplace(termsToBeDeleted, termsToBeReplaced);
            }
        });
        DialogWithOnlineHelpUtils.addHelpButton(this.viewContext, (Window)dialog, new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.TERM, HelpPageIdentifier.HelpPageAction.DELETE));
        dialog.show();
    }

    private void deleteAndReplace(List<VocabularyTerm> termsToBeDeleted, List<VocabularyTermReplacement> termsToBeReplaced) {
        RefreshCallback callback = new RefreshCallback(this.viewContext);
        ((ICommonClientServiceAsync)this.viewContext.getService()).deleteVocabularyTerms(TechId.create(this.vocabulary), termsToBeDeleted, termsToBeReplaced, callback);
    }

    private final class RefreshCallback
    extends AbstractAsyncCallback<Void> {
        private RefreshCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void result) {
            VocabularyTermGrid.this.refresh();
        }
    }
}

