/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public class PopupDialogBasedInfoHandler
extends Dialog
implements IInfoHandler {
    private static final int WIDTH = 550;
    private static final int HEIGHT = 400;
    private IMessageProvider messageProvider;
    private InfoType type;
    private String text;
    private Label label;
    private TextArea textArea;

    public PopupDialogBasedInfoHandler(IMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        this.textArea = new TextArea();
        this.textArea.setReadOnly(true);
        this.label = new Label();
        this.label.setVisible(false);
        this.setBodyStyle("padding: 10px");
        this.setSize(550, 400);
        this.setScrollMode(Style.Scroll.NONE);
        this.setButtons("close");
        this.setHideOnButtonClick(true);
        this.setModal(true);
        this.setLayout((Layout)new FitLayout());
        this.add((Component)this.textArea);
        this.add((Component)this.label);
    }

    @Override
    public void displayInfo(String aText) {
        this.display(InfoType.INFO, this.text);
    }

    @Override
    public void displayError(String aText) {
        this.display(InfoType.ERROR, this.text);
    }

    @Override
    public void displayProgress(String aText) {
        this.display(InfoType.PROGRESS, this.text);
    }

    public void display(InfoType aType, String aText) {
        this.type = aType;
        this.text = aText;
        this.show();
    }

    protected void onAttach() {
        super.onAttach();
        this.setHeading(this.messageProvider.getMessage(this.type.getMessageKey(), new Object[0]));
        String textWithNewLines = this.text.replace("<br>", "\n");
        this.label.setText(textWithNewLines);
        String textWithoutTags = DOM.getInnerText((Element)this.label.getElement());
        this.textArea.setValue((Object)textWithoutTags);
        this.layout();
    }
}

