/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractServlet;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractFileDownloadServlet
extends AbstractServlet {
    protected AbstractFileDownloadServlet() {
        this.setRequireSession(true);
    }

    protected abstract FileContent getFileContent(HttpServletRequest var1) throws Exception;

    @Override
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        FileContent fileContent = this.getFileContent(request);
        if (fileContent != null) {
            response.setContentLength(fileContent.getContent().length);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileContent.getFileName() + "\"");
            response.setHeader("Cache-Control", "no-cache");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(fileContent.getContent());
            outputStream.flush();
            outputStream.close();
        }
    }

    public static final class FileContent {
        private final byte[] content;
        private final String fileName;

        public FileContent(byte[] content, String fileName) {
            this.content = content;
            this.fileName = fileName;
        }

        public final byte[] getContent() {
            return this.content;
        }

        public final String getFileName() {
            return this.fileName;
        }
    }
}

