/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class VocabulariesProvider
extends AbstractCommonTableModelProvider<Vocabulary> {
    private final boolean withTerms;
    private final boolean excludeInternal;

    public VocabulariesProvider(ICommonServer commonServer, String sessionToken, boolean withTerms, boolean excludeInternal) {
        super(commonServer, sessionToken);
        this.withTerms = withTerms;
        this.excludeInternal = excludeInternal;
    }

    @Override
    protected TypedTableModel<Vocabulary> createTableModel() {
        List<Vocabulary> vocabularies = this.commonServer.listVocabularies(this.sessionToken, this.withTerms, this.excludeInternal);
        TypedTableModelBuilder<Vocabulary> builder = new TypedTableModelBuilder<Vocabulary>();
        builder.addColumn("CODE").withDefaultWidth(200);
        builder.addColumn("DESCRIPTION").withDefaultWidth(300);
        builder.addColumn("IS_MANAGED_INTERNALLY").withDefaultWidth(150);
        builder.addColumn("REGISTRATOR").withDefaultWidth(150);
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300);
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("URL_TEMPLATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("VOCABULARY_SHOW_AVAILABLE_TERMS_IN_CHOOSERS").withDefaultWidth(150).hideByDefault();
        for (Vocabulary vocabulary : vocabularies) {
            builder.addRow(vocabulary);
            builder.column("CODE").addString(vocabulary.getCode());
            builder.column("DESCRIPTION").addString(vocabulary.getDescription());
            builder.column("IS_MANAGED_INTERNALLY").addString(SimpleYesNoRenderer.render(vocabulary.isManagedInternally()));
            builder.column("REGISTRATOR").addPerson(vocabulary.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(vocabulary.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(vocabulary.getModificationDate());
            builder.column("URL_TEMPLATE").addString(vocabulary.getURLTemplate());
            builder.column("VOCABULARY_SHOW_AVAILABLE_TERMS_IN_CHOOSERS").addString(SimpleYesNoRenderer.render(vocabulary.isChosenFromList()));
        }
        return builder.getModel();
    }
}

