/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.translator;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import org.apache.commons.lang.StringEscapeUtils;

public class UserFailureExceptionTranslator {
    private static final String WEB_CLIENT_EXCEPTIONS_PACKAGE = UserFailureExceptionTranslator.getPackageName(UserFailureException.class);

    private static String getPackageName(Class<?> clazz) {
        String fullName = clazz.getName();
        return fullName.substring(0, fullName.length() - clazz.getSimpleName().length() - 1);
    }

    private UserFailureExceptionTranslator() {
    }

    public static UserFailureException translate(ch.systemsx.cisd.common.exceptions.UserFailureException exception) {
        return UserFailureExceptionTranslator.translate(exception, null);
    }

    public static UserFailureException translate(ch.systemsx.cisd.common.exceptions.UserFailureException exception, String simpleMessageOrNull) {
        String className = String.valueOf(WEB_CLIENT_EXCEPTIONS_PACKAGE) + "." + exception.getClass().getSimpleName();
        String fullMessage = StringEscapeUtils.escapeHtml((String)exception.getMessage());
        try {
            if (simpleMessageOrNull != null) {
                return ClassUtils.create(UserFailureException.class, className, simpleMessageOrNull, fullMessage);
            }
            return ClassUtils.create(UserFailureException.class, className, fullMessage);
        }
        catch (CheckedExceptionTunnel checkedExceptionTunnel) {
            if (simpleMessageOrNull != null) {
                return new UserFailureException(simpleMessageOrNull, fullMessage);
            }
            return new UserFailureException(fullMessage);
        }
    }
}

