/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.AnnotationUtils;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.Argument;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationComponentFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.IReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.util.MethodInvocationUtils;
import ch.systemsx.cisd.openbis.generic.shared.ISessionProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

public final class AuthorizationAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private static final Logger authorizationLog = LogFactory.getLogger(LogCategory.AUTH, AuthorizationAdvisor.class);

    public AuthorizationAdvisor(IAuthorizationComponentFactory authorizationComponentFactory) {
        this(authorizationComponentFactory.createAccessController(), authorizationComponentFactory.createReturnValueFilter());
    }

    private AuthorizationAdvisor(IAccessController accessController, IReturnValueFilter returnValueFilter) {
        super(AuthorizationAdvisor.createPointcut(), AuthorizationAdvisor.createAdvice(accessController, returnValueFilter));
    }

    private static final Advice createAdvice(IAccessController accessController, IReturnValueFilter returnValueFilter) {
        return new AuthorizationMethodInterceptor(accessController, returnValueFilter);
    }

    private static final Pointcut createPointcut() {
        return new AnnotationMatchingPointcut(null, RolesAllowed.class);
    }

    private static final class AuthorizationMethodInterceptor
    implements MethodInterceptor {
        private final IAccessController accessController;
        private final IReturnValueFilter returnValueFilter;
        private final Map<Method, List<AnnotationUtils.Parameter<AuthorizationGuard>>> methodAuthorizationGuards = new HashMap<Method, List<AnnotationUtils.Parameter<AuthorizationGuard>>>();

        AuthorizationMethodInterceptor(IAccessController accessController, IReturnValueFilter returnValueFilter) {
            this.accessController = accessController;
            this.returnValueFilter = returnValueFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<AnnotationUtils.Parameter<AuthorizationGuard>> getMethodAuthorizationGuards(Method method) {
            Map<Method, List<AnnotationUtils.Parameter<AuthorizationGuard>>> map = this.methodAuthorizationGuards;
            synchronized (map) {
                List<AnnotationUtils.Parameter<AuthorizationGuard>> annotatedParameters = this.methodAuthorizationGuards.get(method);
                if (annotatedParameters == null) {
                    annotatedParameters = AnnotationUtils.getAnnotatedParameters(method, AuthorizationGuard.class);
                    this.methodAuthorizationGuards.put(method, annotatedParameters);
                }
                return annotatedParameters;
            }
        }

        private static final Argument<?> toArgument(AnnotationUtils.Parameter<AuthorizationGuard> parameter, Object[] args) {
            return new Argument<Object>(parameter.getType(), args[parameter.getIndex()], parameter.getAnnotation());
        }

        private Argument<?>[] createArguments(Method method, Object[] args) {
            ArrayList arguments = new ArrayList();
            List<AnnotationUtils.Parameter<AuthorizationGuard>> authorizationGuards = this.getMethodAuthorizationGuards(method);
            for (AnnotationUtils.Parameter<AuthorizationGuard> parameter : authorizationGuards) {
                arguments.add(AuthorizationMethodInterceptor.toArgument(parameter, args));
            }
            return arguments.toArray(Argument.EMPTY_ARRAY);
        }

        public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
            Argument<?>[] arguments;
            Method method;
            IAuthSession session = this.obtainSession(methodInvocation);
            Status status = this.accessController.isAuthorized(session, method = MethodInvocationUtils.getMethod(methodInvocation, RolesAllowed.class), arguments = this.createArguments(method, methodInvocation.getArguments()));
            if (!StatusFlag.OK.equals((Object)status.getFlag())) {
                String groupCode = session.tryGetHomeGroupCode();
                String errorMessage = status.toString();
                authorizationLog.info((Object)String.format("[USER:'%s' SPACE:%s]: Authorization failure while invoking method '%s': %s", session.getUserName(), groupCode == null ? "<UNDEFINED>" : "'" + groupCode + "'", MethodUtils.describeMethod(method), errorMessage));
                throw new AuthorizationFailureException(errorMessage);
            }
            return this.returnValueFilter.applyFilter(session, method, methodInvocation.proceed());
        }

        private IAuthSession obtainSession(MethodInvocation methodInvocation) {
            Object[] args = methodInvocation.getArguments();
            int len = args.length;
            assert (len > 0) : "At least one argument is expected";
            Object firstObject = args[0];
            if (firstObject instanceof IAuthSession) {
                IAuthSession session = (IAuthSession)firstObject;
                return session;
            }
            if (firstObject instanceof String) {
                String sessionToken = (String)firstObject;
                Object wrappedObject = methodInvocation.getThis();
                if (wrappedObject instanceof ISessionProvider) {
                    ISessionProvider sessionProvider = (ISessionProvider)wrappedObject;
                    return sessionProvider.getAuthSession(sessionToken);
                }
                throw new AssertionError((Object)("Wrapped object doesn't implement " + ISessionProvider.class.getSimpleName() + ": " + wrappedObject));
            }
            throw new AssertionError((Object)("First argument is neither an " + IAuthSession.class.getSimpleName() + " object nor a String."));
        }
    }
}

