/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class NewDataSetsWithTypePredicate
extends AbstractPredicate<NewDataSetsWithTypes> {
    private final DataSetCodeCollectionPredicate dataSetCodeCollectionPredicate = new DataSetCodeCollectionPredicate();

    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewDataSetsWithTypes dataSets) {
        ArrayList<String> codes = new ArrayList<String>();
        for (NewDataSet ds : dataSets.getNewDataSets()) {
            codes.add(ds.getCode());
        }
        return this.dataSetCodeCollectionPredicate.doEvaluation(person, allowedRoles, (List<String>)codes);
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataSetCodeCollectionPredicate.init(provider);
    }
}

