/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.CharacterHelper;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class SearchAnalyzer
extends Analyzer {
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new TrimSpecialCharsFilter((TokenStream)new WordAndCodeTokenizer(reader));
    }

    private static final class TrimSpecialCharsFilter
    extends TokenFilter {
        private CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public TrimSpecialCharsFilter(TokenStream input) {
            super(input);
        }

        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                char[] buffer = this.termAttr.buffer();
                int bufferLength = this.termAttr.length();
                int startCounter = 0;
                Set<Character> trimmedCharacters = CharacterHelper.getTrimmedSpecialCharacters();
                int i = 0;
                while (i < bufferLength) {
                    if (!trimmedCharacters.contains(Character.valueOf(buffer[i]))) break;
                    ++startCounter;
                    ++i;
                }
                if (startCounter == bufferLength) {
                    return true;
                }
                int endCounter = 0;
                int i2 = bufferLength - 1;
                while (i2 > 0) {
                    if (!trimmedCharacters.contains(Character.valueOf(buffer[i2]))) break;
                    ++endCounter;
                    --i2;
                }
                if (startCounter > 0) {
                    i2 = startCounter;
                    while (i2 < bufferLength) {
                        buffer[i2 - startCounter] = buffer[i2];
                        ++i2;
                    }
                }
                if (startCounter + endCounter > 0) {
                    int trimmedLength = bufferLength - (startCounter + endCounter);
                    this.termAttr.setLength(trimmedLength);
                }
                return true;
            }
            return false;
        }
    }

    private static class WordAndCodeTokenizer
    extends CharTokenizer {
        public WordAndCodeTokenizer(Reader input) {
            super(input);
        }

        protected boolean isTokenChar(char c) {
            return CharacterHelper.isTokenCharacter(c);
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }
}

