/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.util;

import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDatabaseInstanceFinder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.DatabaseInstanceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.List;

public final class SpaceIdentifierHelper {
    private SpaceIdentifierHelper() {
    }

    private static final SpaceIdentifier normalize(SpaceIdentifier spaceIdentifier, String homeSpaceCodeOrNull, IDatabaseInstanceFinder instanceFinder) {
        DatabaseInstanceIdentifier instance = SpaceIdentifierHelper.normalize(spaceIdentifier, instanceFinder);
        String spaceCode = spaceIdentifier.getSpaceCode();
        if (spaceCode == null) {
            spaceCode = homeSpaceCodeOrNull;
        }
        return new SpaceIdentifier(instance, spaceCode.toUpperCase());
    }

    private static final SampleIdentifier normalize(SampleIdentifier sampleIdentifier, String homeSpaceCodeOrNull, IDatabaseInstanceFinder instanceFinder) {
        if (sampleIdentifier.isDatabaseInstanceLevel()) {
            DatabaseInstanceIdentifier instanceIdentifier = SpaceIdentifierHelper.normalize(sampleIdentifier.getDatabaseInstanceLevel(), instanceFinder);
            return new SampleIdentifier(instanceIdentifier, sampleIdentifier.getSampleCode());
        }
        if (sampleIdentifier.isSpaceLevel()) {
            SpaceIdentifier spaceIdentifier = SpaceIdentifierHelper.normalize(sampleIdentifier.getSpaceLevel(), homeSpaceCodeOrNull, instanceFinder);
            return new SampleIdentifier(spaceIdentifier, sampleIdentifier.getSampleCode());
        }
        throw InternalErr.error(sampleIdentifier);
    }

    private static DatabaseInstanceIdentifier normalize(DatabaseInstanceIdentifier identifier, IDatabaseInstanceFinder instanceFinder) {
        String code = DatabaseInstanceIdentifierHelper.getDatabaseInstance(identifier, instanceFinder).getCode();
        return new DatabaseInstanceIdentifier(code.toUpperCase());
    }

    public static final IDatabaseInstanceFinder createCachedInstanceFinder(final IAuthorizationDAOFactory daoFactory) {
        List<DatabaseInstancePE> instances = daoFactory.getDatabaseInstanceDAO().listDatabaseInstances();
        final TableMap<String, DatabaseInstancePE> databaseInstancesByCode = new TableMap<String, DatabaseInstancePE>(instances, KeyExtractorFactory.getDatabaseInstanceByCodeKeyExtractor());
        final TableMap<String, DatabaseInstancePE> databaseInstancesByUUID = new TableMap<String, DatabaseInstancePE>(instances, KeyExtractorFactory.getDatabaseInstanceByUUIDKeyExtractor());
        return new IDatabaseInstanceFinder(){

            @Override
            public DatabaseInstancePE getHomeDatabaseInstance() {
                return daoFactory.getHomeDatabaseInstance();
            }

            @Override
            public DatabaseInstancePE tryFindDatabaseInstanceByCode(String databaseInstanceCode) {
                return (DatabaseInstancePE)databaseInstancesByCode.tryGet(databaseInstanceCode);
            }

            @Override
            public DatabaseInstancePE tryFindDatabaseInstanceByUUID(String databaseInstanceUUID) {
                return (DatabaseInstancePE)databaseInstancesByUUID.tryGet(databaseInstanceUUID);
            }
        };
    }

    private static final IDatabaseInstanceFinder createInstanceFinder(final IAuthorizationDAOFactory daoFactory) {
        return new IDatabaseInstanceFinder(){

            @Override
            public DatabaseInstancePE getHomeDatabaseInstance() {
                return daoFactory.getHomeDatabaseInstance();
            }

            @Override
            public DatabaseInstancePE tryFindDatabaseInstanceByCode(String databaseInstanceCode) {
                return daoFactory.getDatabaseInstanceDAO().tryFindDatabaseInstanceByCode(databaseInstanceCode);
            }

            @Override
            public DatabaseInstancePE tryFindDatabaseInstanceByUUID(String databaseInstanceUUID) {
                return daoFactory.getDatabaseInstanceDAO().tryFindDatabaseInstanceByUUID(databaseInstanceUUID);
            }
        };
    }

    public static final SpacePE tryGetSpace(SpaceIdentifier spaceIdentifier, PersonPE person, IAuthorizationDAOFactory daoFactory) {
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
        DatabaseInstancePE databaseInstance = SpaceIdentifierHelper.getDatabaseInstance(spaceIdentifier, daoFactory);
        ISpaceDAO groupDAO = daoFactory.getSpaceDAO();
        return groupDAO.tryFindSpaceByCodeAndDatabaseInstance(spaceCode, databaseInstance);
    }

    public static final DatabaseInstancePE getDatabaseInstance(DatabaseInstanceIdentifier databaseInstanceIdentifier, IAuthorizationDAOFactory daoFactory) throws UserFailureException {
        IDatabaseInstanceFinder finder = SpaceIdentifierHelper.createInstanceFinder(daoFactory);
        return DatabaseInstanceIdentifierHelper.getDatabaseInstance(databaseInstanceIdentifier, finder);
    }

    public static final DatabaseInstancePE tryGetDatabaseInstance(DatabaseInstanceIdentifier databaseInstanceIdentifier, IAuthorizationDAOFactory daoFactory) throws UserFailureException {
        IDatabaseInstanceFinder finder = SpaceIdentifierHelper.createInstanceFinder(daoFactory);
        return DatabaseInstanceIdentifierHelper.tryGetDatabaseInstance(databaseInstanceIdentifier, finder);
    }

    public static class SpaceIdentifierNormalizer {
        private final IDatabaseInstanceFinder databaseInstanceFinder;
        private final String homeSpaceCodeOrNull;

        public static SpaceIdentifierNormalizer create(IAuthorizationDAOFactory daoFactory, String homeSpaceCodeOrNull) {
            IDatabaseInstanceFinder instanceFinder = SpaceIdentifierHelper.createCachedInstanceFinder(daoFactory);
            return new SpaceIdentifierNormalizer(instanceFinder, homeSpaceCodeOrNull);
        }

        private SpaceIdentifierNormalizer(IDatabaseInstanceFinder databaseInstanceFinder, String homeSpaceCodeOrNull) {
            this.databaseInstanceFinder = databaseInstanceFinder;
            this.homeSpaceCodeOrNull = homeSpaceCodeOrNull;
        }

        public final SpaceIdentifier normalize(SpaceIdentifier identifier) {
            return SpaceIdentifierHelper.normalize(identifier, this.homeSpaceCodeOrNull, this.databaseInstanceFinder);
        }

        public final SampleIdentifier normalize(SampleIdentifier identifier) {
            return SpaceIdentifierHelper.normalize(identifier, this.homeSpaceCodeOrNull, this.databaseInstanceFinder);
        }
    }
}

