/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class GenericSampleBatchUpdateForm
extends AbstractRegistrationForm {
    private static final String PREFIX = "sample-batch-update";
    public static final String ID = "openbis_sample-batch-update";
    private static final String SESSION_KEY = "sample-batch-update";
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int DEFAULT_NUMBER_OF_FILES = 1;
    private final BasicFileFieldManager fileFieldsManager;
    private final IViewContext<IGenericClientServiceAsync> viewContext;
    private final SampleType sampleType;
    private final SpaceSelectionWidget groupSelector;

    public GenericSampleBatchUpdateForm(IViewContext<IGenericClientServiceAsync> viewContext, SampleType sampleType) {
        super(viewContext.getCommonViewContext(), ID);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.sampleType = sampleType;
        this.fileFieldsManager = new BasicFileFieldManager("sample-batch-update", 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        this.groupSelector = this.createGroupField(viewContext.getCommonViewContext(), this.getId(), true);
        this.setScrollMode(Style.Scroll.AUTO);
        this.addUploadFeatures("sample-batch-update");
    }

    private final SpaceSelectionWidget createGroupField(IViewContext<ICommonClientServiceAsync> context, String idSuffix, boolean addShared) {
        SpaceSelectionWidget field = new SpaceSelectionWidget(context, idSuffix, addShared, false);
        field.setFieldLabel(this.viewContext.getMessage("default_group", new Object[0]));
        return field;
    }

    @Override
    protected void resetFieldsAfterSave() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            attachmentField.reset();
        }
        this.updateDirtyCheckAfterSave();
    }

    private final void addFormFields() {
        this.formPanel.add((Widget)this.groupSelector);
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
        }
        this.formPanel.add((Widget)this.createTemplateField());
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                GenericSampleBatchUpdateForm.this.infoBox.displayProgress(GenericSampleBatchUpdateForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                GenericSampleBatchUpdateForm.this.infoBox.displayProgress(GenericSampleBatchUpdateForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                GenericSampleBatchUpdateForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                GenericSampleBatchUpdateForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    protected void save() {
        Space selectedGroup = this.groupSelector.tryGetSelectedSpace();
        String defaultGroupIdentifier = selectedGroup != null ? selectedGroup.getIdentifier() : null;
        this.viewContext.getService().updateSamples(this.sampleType, "sample-batch-update", defaultGroupIdentifier, new RegisterSamplesCallback(this.viewContext));
    }

    void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (GenericSampleBatchUpdateForm.this.formPanel.isValid()) {
                    if (GenericSampleBatchUpdateForm.this.fileFieldsManager.filesDefined() > 0) {
                        GenericSampleBatchUpdateForm.this.setUploadEnabled(false);
                        GenericSampleBatchUpdateForm.this.formPanel.submit();
                    } else {
                        GenericSampleBatchUpdateForm.this.save();
                    }
                }
            }
        });
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    private LabelField createTemplateField() {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                WindowUtils.openWindow(UrlParamsHelper.createTemplateURL(EntityKind.SAMPLE, GenericSampleBatchUpdateForm.this.sampleType, false, true, BatchOperationKind.UPDATE));
            }
        });
        return result;
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    private final class RegisterSamplesCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<List<BatchRegistrationResult>> {
        RegisterSamplesCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(List<BatchRegistrationResult> result) {
            StringBuilder builder = new StringBuilder();
            for (BatchRegistrationResult batchRegistrationResult : result) {
                builder.append("<b>" + batchRegistrationResult.getFileName() + "</b>: ");
                builder.append(batchRegistrationResult.getMessage());
                builder.append("<br />");
            }
            return builder.toString();
        }
    }
}

