/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.api.v1;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.plugin.query.server.api.v1.QueryApiLogger;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.AggregationServiceDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.ReportDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import ch.systemsx.cisd.openbis.plugin.query.shared.translator.QueryTableModelTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="query-api-server-v1")
public class QueryApiServer
extends AbstractServer<IQueryApiServer>
implements IQueryApiServer {
    @Resource(name="query-plugin-server")
    private IQueryServer queryServer;
    @Resource(name="common-server")
    private ICommonServer commonServer;

    public QueryApiServer() {
    }

    public QueryApiServer(IQueryServer queryServer, ICommonServer commonServer, ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.queryServer = queryServer;
        this.commonServer = commonServer;
    }

    @Override
    public IQueryApiServer createLogger(IInvocationLoggerContext context) {
        return new QueryApiLogger(this.sessionManager, context);
    }

    @Override
    public String tryToAuthenticateAtQueryServer(String userID, String userPassword) {
        SessionContextDTO session = this.tryAuthenticate(userID, userPassword);
        if (session != null) {
            this.queryServer.initDatabases(session.getSessionToken());
        }
        return session == null ? null : session.getSessionToken();
    }

    @Override
    public List<QueryDescription> listQueries(String sessionToken) {
        ArrayList<QueryDescription> result = new ArrayList<QueryDescription>();
        List<QueryExpression> queries = this.queryServer.listQueries(sessionToken, QueryType.GENERIC, BasicEntityType.UNSPECIFIED);
        for (QueryExpression queryExpression : queries) {
            QueryDescription queryDescription = new QueryDescription();
            queryDescription.setId(queryExpression.getId());
            queryDescription.setName(queryExpression.getName());
            queryDescription.setDescription(queryExpression.getDescription());
            List<String> parameters = queryExpression.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (String parameter : parameters) {
                int indexOfDelim = parameter.indexOf("::");
                parameterNames.add(indexOfDelim < 0 ? parameter : parameter.substring(0, indexOfDelim));
            }
            queryDescription.setParameters(parameterNames);
            result.add(queryDescription);
        }
        return result;
    }

    @Override
    public QueryTableModel executeQuery(String sessionToken, long queryID, Map<String, String> parameterBindings) {
        QueryParameterBindings bindings = new QueryParameterBindings();
        for (Map.Entry<String, String> entry : parameterBindings.entrySet()) {
            bindings.addBinding(entry.getKey(), entry.getValue());
        }
        return this.translate(this.queryServer.queryDatabase(sessionToken, new TechId(queryID), bindings));
    }

    @Override
    public List<ReportDescription> listTableReportDescriptions(String sessionToken) {
        this.checkSession(sessionToken);
        ArrayList<ReportDescription> services = new ArrayList<ReportDescription>();
        List<DataStorePE> dataStores = this.getDAOFactory().getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : dataStores) {
            for (DataStoreServicePE service : dataStore.getServices()) {
                if (!service.isTableReport()) continue;
                ReportDescription info = new ReportDescription();
                info.setKey(service.getKey());
                info.setLabel(service.getLabel());
                info.setDataStoreCode(dataStore.getCode());
                Set<DataSetTypePE> datasetTypes = service.getDatasetTypes();
                ArrayList<String> dataSetTypeCodes = new ArrayList<String>();
                for (DataSetTypePE dataSetType : datasetTypes) {
                    dataSetTypeCodes.add(dataSetType.getCode());
                }
                info.setDataSetTypes(dataSetTypeCodes);
                services.add(info);
            }
        }
        return services;
    }

    @Override
    public QueryTableModel createReportFromDataSets(String sessionToken, String dataStoreCode, String serviceKey, List<String> dataSetCodes) {
        DatastoreServiceDescription description = DatastoreServiceDescription.reporting(serviceKey, "", new String[0], dataStoreCode, null);
        return this.translate(this.commonServer.createReportFromDatasets(sessionToken, description, dataSetCodes));
    }

    @Override
    public QueryTableModel createReportFromDataSets(String sessionToken, String serviceKey, List<String> dataSetCodes) {
        return this.translate(this.commonServer.createReportFromDatasets(sessionToken, serviceKey, dataSetCodes));
    }

    @Override
    public List<AggregationServiceDescription> listAggregationServices(String sessionToken) {
        this.checkSession(sessionToken);
        ArrayList<AggregationServiceDescription> services = new ArrayList<AggregationServiceDescription>();
        List<DataStorePE> dataStores = this.getDAOFactory().getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : dataStores) {
            for (DataStoreServicePE service : dataStore.getServices()) {
                boolean aggregationTableReport;
                boolean reportingService = service.getKind() == DataStoreServiceKind.QUERIES;
                ReportingPluginType reportingPluginType = service.getReportingPluginTypeOrNull();
                boolean bl = aggregationTableReport = reportingPluginType != null && reportingPluginType == ReportingPluginType.AGGREGATION_TABLE_MODEL;
                if (!reportingService || !aggregationTableReport) continue;
                AggregationServiceDescription info = new AggregationServiceDescription();
                info.setServiceKey(service.getKey());
                info.setLabel(service.getLabel());
                info.setDataStoreCode(dataStore.getCode());
                info.setDataStoreBaseUrl(dataStore.getDownloadUrl());
                services.add(info);
            }
        }
        return services;
    }

    @Override
    public QueryTableModel createReportFromAggregationService(String sessionToken, String dataStoreCode, String serviceKey, Map<String, Object> parameters) {
        this.checkSession(sessionToken);
        DatastoreServiceDescription description = DatastoreServiceDescription.reporting(serviceKey, "", new String[0], dataStoreCode, ReportingPluginType.AGGREGATION_TABLE_MODEL);
        return this.translate(this.commonServer.createReportFromAggregationService(sessionToken, description, parameters));
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 6;
    }

    private QueryTableModel translate(TableModel result) {
        return new QueryTableModelTranslator(result).translate();
    }
}

