/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;

public class ImageLineHelper {
    private static final double BIG_VALUE = 8.988465674311579E307;
    private static final double BIG_VALUE_NEG = -8.988465674311579E307;

    public int[] tf_palIdx2RGB(ImageLine line, PngChunkPLTE pal, int[] buf) {
        int[] src;
        int nbytes = line.imgInfo.cols * 3;
        if (buf == null || buf.length < nbytes) {
            buf = new int[nbytes];
        }
        if (line.imgInfo.packed) {
            line.tf_unpack(buf, false);
            src = buf;
        } else {
            src = line.scanline;
        }
        int c = line.imgInfo.cols - 1;
        while (c >= 0) {
            pal.getEntryRgb(src[c], buf, c * 3);
            --c;
        }
        return buf;
    }

    public static String infoFirstLastPixels(ImageLine line) {
        return line.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", line.scanline[0], line.scanline[line.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", line.scanline[0], line.scanline[1], line.scanline[2], line.scanline[line.scanline.length - line.imgInfo.channels], line.scanline[line.scanline.length - line.imgInfo.channels + 1], line.scanline[line.scanline.length - line.imgInfo.channels + 2]);
    }

    public static String infoFull(ImageLine line) {
        ImageLineStats stats = new ImageLineStats(line);
        return "row=" + line.getRown() + " " + stats.toString() + "\n  " + ImageLineHelper.infoFirstLastPixels(line);
    }

    public static int getPixelRGB8(ImageLine line, int column) {
        int offset = column * line.channels;
        return (line.scanline[offset] << 16) + (line.scanline[offset + 1] << 8) + line.scanline[offset + 2];
    }

    public static int getPixelARGB8(ImageLine line, int column) {
        int offset = column * line.channels;
        return (line.scanline[offset + 3] << 24) + (line.scanline[offset] << 16) + (line.scanline[offset + 1] << 8) + line.scanline[offset + 2];
    }

    public static void setPixelsRGB8(ImageLine line, int[] rgb) {
        int i = 0;
        while (i < line.imgInfo.cols) {
            line.scanline[i * line.channels] = (rgb[i] & 0xFF0000) >> 16;
            line.scanline[i * line.channels + 1] = (rgb[i] & 0xFF00) >> 8;
            line.scanline[i * line.channels + 2] = rgb[i] & 0xFF;
            ++i;
        }
    }

    public static void setPixelRGB8(ImageLine line, int col, int rgb) {
        line.scanline[col * line.channels] = (rgb & 0xFF0000) >> 16;
        line.scanline[col * line.channels + 1] = (rgb & 0xFF00) >> 8;
        line.scanline[col * line.channels + 2] = rgb & 0xFF;
    }

    public static void setValD(ImageLine line, int i, double d) {
        line.scanline[i] = ImageLineHelper.double2int(line, d);
    }

    public static double int2double(ImageLine line, int p) {
        return line.bitDepth == 16 ? (double)p / 65535.0 : (double)p / 255.0;
    }

    public static double int2doubleClamped(ImageLine line, int p) {
        double d;
        double d2 = d = line.bitDepth == 16 ? (double)p / 65535.0 : (double)p / 255.0;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    public static int double2int(ImageLine line, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return line.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLine line, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return line.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    static class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};
        public final int channels;

        public String toString() {
            return this.channels == 3 ? String.valueOf(String.format("prom=%.1f (%.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.minlum, this.minv[0], this.minv[1], this.minv[2])) + String.format(" maxdif=(%.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2]) : String.valueOf(String.format("prom=%.1f (%.1f %.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.prom[3], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.maxv[3], this.minlum, this.minv[0], this.minv[1], this.minv[2], this.minv[3])) + String.format(" maxdif=(%.1f %.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2], this.maxdif[3]);
        }

        public ImageLineStats(ImageLine line) {
            this.channels = line.channels;
            if (line.channels < 3) {
                throw new PngjException("ImageLineStats only works for RGB - RGBA");
            }
            int ch = 0;
            int i = 0;
            while (i < line.imgInfo.cols) {
                double lum = 0.0;
                ch = this.channels - 1;
                while (ch >= 0) {
                    double d;
                    double x = ImageLineHelper.int2double(line, line.scanline[i * this.channels]);
                    if (ch < 3) {
                        lum += x;
                    }
                    int n = ch;
                    this.prom[n] = this.prom[n] + x;
                    if (x > this.maxv[ch]) {
                        this.maxv[ch] = x;
                    }
                    if (x < this.minv[ch]) {
                        this.minv[ch] = x;
                    }
                    if (i >= this.channels && (d = Math.abs(x - ImageLineHelper.int2double(line, line.scanline[i - this.channels]))) > this.maxdif[ch]) {
                        this.maxdif[ch] = d;
                    }
                    --ch;
                }
                this.promlum += lum;
                if (lum > this.maxlum) {
                    this.maxlum = lum;
                }
                if (lum < this.minlum) {
                    this.minlum = lum;
                }
                ++i;
            }
            ch = 0;
            while (ch < this.channels) {
                int n = ch++;
                this.prom[n] = this.prom[n] / (double)line.imgInfo.cols;
            }
            this.promlum /= (double)line.imgInfo.cols * 3.0;
            this.maxlum /= 3.0;
            this.minlum /= 3.0;
        }
    }
}

