/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes = new byte[4];
    public byte[] data = null;
    private int crcval = 0;

    public ChunkRaw(int len, byte[] idbytes, boolean alloc) {
        this.len = len;
        System.arraycopy(idbytes, 0, this.idbytes, 0, 4);
        if (alloc) {
            this.allocData();
        }
    }

    public void writeChunk(OutputStream os) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + ChunkHelper.toString(this.idbytes) + "]");
        }
        this.computeCrc();
        PngHelper.writeInt4(os, this.len);
        PngHelper.writeBytes(os, this.idbytes);
        if (this.len > 0) {
            PngHelper.writeBytes(os, this.data, 0, this.len);
        }
        PngHelper.writeInt4(os, this.crcval);
    }

    private void computeCrc() {
        CRC32 crcengine = PngHelper.getCRC();
        crcengine.reset();
        crcengine.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            crcengine.update(this.data, 0, this.len);
        }
        this.crcval = (int)crcengine.getValue();
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }

    public int readChunkData(InputStream is) {
        PngHelper.readBytes(is, this.data, 0, this.len);
        int crcori = PngHelper.readInt4(is);
        this.computeCrc();
        if (crcori != this.crcval) {
            throw new PngjBadCrcException("crc invalid for chunk " + this.toString() + " calc=" + this.crcval + " read=" + crcori);
        }
        return this.len + 4;
    }

    public ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    private void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }
}

