/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.util.Vector;
import loci.formats.FormatTools;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheException;
import loci.formats.cache.CacheListener;
import loci.formats.cache.CacheReporter;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;

public class Cache
implements CacheReporter {
    protected ICacheStrategy strategy;
    protected ICacheSource source;
    protected int[] currentPos;
    protected Object[] cache;
    protected boolean[] inCache;
    protected Vector<CacheListener> listeners;
    protected boolean autoUpdate;

    public Cache(ICacheStrategy strategy, ICacheSource source, boolean autoUpdate) throws CacheException {
        if (strategy == null) {
            throw new CacheException("strategy is null");
        }
        if (source == null) {
            throw new CacheException("source is null");
        }
        this.strategy = strategy;
        this.source = source;
        this.autoUpdate = autoUpdate;
        this.listeners = new Vector();
        this.reset();
        if (autoUpdate) {
            this.recache();
        }
    }

    public Object getObject(int[] pos) throws CacheException {
        if (pos.length != this.strategy.getLengths().length) {
            throw new CacheException("Invalid number of axes; got " + pos.length + "; expected " + this.strategy.getLengths().length);
        }
        int ndx = FormatTools.positionToRaster(this.strategy.getLengths(), pos);
        return this.cache[ndx];
    }

    public boolean isInCache(int[] pos) throws CacheException {
        return this.isInCache(FormatTools.positionToRaster(this.strategy.getLengths(), pos));
    }

    public boolean isInCache(int pos) throws CacheException {
        return this.inCache[pos];
    }

    public void reset() throws CacheException {
        this.currentPos = new int[this.strategy.getLengths().length];
        this.cache = new Object[this.source.getObjectCount()];
        this.inCache = new boolean[this.source.getObjectCount()];
    }

    public ICacheStrategy getStrategy() {
        return this.strategy;
    }

    public ICacheSource getSource() {
        return this.source;
    }

    public int[] getCurrentPos() {
        return this.currentPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategy(ICacheStrategy strategy) throws CacheException {
        if (strategy == null) {
            throw new CacheException("strategy is null");
        }
        Vector<CacheListener> vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CacheListener l = this.listeners.elementAt(i);
                this.strategy.removeCacheListener(l);
                strategy.addCacheListener(l);
            }
        }
        this.strategy = strategy;
        this.notifyListeners(new CacheEvent(this, 2));
        this.reset();
        if (this.autoUpdate) {
            this.recache();
        }
    }

    public void setSource(ICacheSource source) throws CacheException {
        if (source == null) {
            throw new CacheException("source is null");
        }
        this.source = source;
        this.notifyListeners(new CacheEvent(this, 1));
        this.reset();
        if (this.autoUpdate) {
            this.recache();
        }
    }

    public void setCurrentPos(int[] pos) throws CacheException {
        if (pos == null) {
            throw new CacheException("pos is null");
        }
        if (pos.length != this.currentPos.length) {
            throw new CacheException("pos length mismatch (is " + pos.length + ", expected " + this.currentPos.length + ")");
        }
        int[] len = this.strategy.getLengths();
        for (int i = 0; i < pos.length; ++i) {
            if (pos[i] >= 0 && pos[i] < len[i]) continue;
            throw new CacheException("invalid pos[" + i + "] (is " + pos[i] + ", expected [0, " + (len[i] - 1) + "])");
        }
        System.arraycopy(pos, 0, this.currentPos, 0, pos.length);
        int ndx = FormatTools.positionToRaster(len, pos);
        this.notifyListeners(new CacheEvent(this, 3, ndx));
        if (this.autoUpdate) {
            this.recache();
        }
    }

    public void recache(int n) throws CacheException {
        int[][] indices = this.strategy.getLoadList(this.currentPos);
        int[] len = this.strategy.getLengths();
        for (int i = 0; i < this.inCache.length; ++i) {
            boolean found = false;
            for (int j = 0; j < indices.length; ++j) {
                if (i != FormatTools.positionToRaster(len, indices[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.inCache[i] = false;
            if (this.cache[i] == null) continue;
            this.cache[i] = null;
            this.notifyListeners(new CacheEvent(this, 8, i));
        }
        int ndx = FormatTools.positionToRaster(len, indices[n]);
        if (ndx >= 0) {
            this.inCache[ndx] = true;
        }
        if (this.cache[ndx] == null) {
            this.cache[ndx] = this.source.getObject(ndx);
            this.notifyListeners(new CacheEvent(this, 7, ndx));
        }
    }

    public void recache() throws CacheException {
        for (int i = 0; i < this.strategy.getLoadList(this.currentPos).length; ++i) {
            this.recache(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener l) {
        Vector<CacheListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(l);
            this.strategy.addCacheListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(CacheListener l) {
        Vector<CacheListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
            this.strategy.removeCacheListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheListener[] getCacheListeners() {
        Object[] l;
        Vector<CacheListener> vector = this.listeners;
        synchronized (vector) {
            l = new CacheListener[this.listeners.size()];
            this.listeners.copyInto(l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(CacheEvent e) {
        Vector<CacheListener> vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CacheListener l = this.listeners.elementAt(i);
                l.cacheUpdated(e);
            }
        }
    }
}

