/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.meta.MetadataStore;

public class CanonRawReader
extends FormatReader {
    private static final int FILE_LENGTH = 18653760;
    private static final int[] COLOR_MAP = new int[]{1, 0, 2, 1};
    private byte[] plane;

    public CanonRawReader() {
        super("Canon RAW", new String[]{"cr2", "crw", "jpg", "thm", "wav"});
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return stream.length() == 18653760L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream s = new RandomAccessInputStream(this.plane);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.plane = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        byte[] pixBuffer = new byte[18653760];
        this.in.read(pixBuffer);
        for (int i = 0; i < pixBuffer.length; i += 2) {
            byte v = pixBuffer[i];
            pixBuffer[i] = pixBuffer[i + 1];
            pixBuffer[i + 1] = v;
        }
        this.core[0].sizeX = 4080;
        this.core[0].sizeY = 3048;
        this.core[0].sizeC = 3;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].littleEndian = true;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 3;
        this.core[0].bitsPerPixel = 12;
        this.core[0].rgb = true;
        this.core[0].interleaved = true;
        BitBuffer bb = new BitBuffer(pixBuffer);
        this.plane = new byte[FormatTools.getPlaneSize(this)];
        short[] pix = new short[this.getSizeX() * this.getSizeY() * 3];
        for (int row = 0; row < this.getSizeY(); ++row) {
            block7: for (int col = 0; col < this.getSizeX(); ++col) {
                short val = (short)(bb.getBits(12) & 0xFFFF);
                int mapIndex = row % 2 * 2 + col % 2;
                int redOffset = row * this.getSizeX() + col;
                int greenOffset = (this.getSizeY() + row) * this.getSizeX() + col;
                int blueOffset = (2 * this.getSizeY() + row) * this.getSizeX() + col;
                switch (COLOR_MAP[mapIndex]) {
                    case 0: {
                        pix[redOffset] = val;
                        continue block7;
                    }
                    case 1: {
                        pix[greenOffset] = val;
                        continue block7;
                    }
                    case 2: {
                        pix[blueOffset] = val;
                    }
                }
            }
        }
        ImageTools.interpolate(pix, this.plane, COLOR_MAP, this.getSizeX(), this.getSizeY(), this.isLittleEndian());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

