/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000BoxType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.in.JPEG2000MetadataParser;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPXReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPXReader.class);
    private Integer resolutionLevels;
    private int[][] lut;
    private ArrayList<Long> pixelOffsets = new ArrayList();
    private int lastSeries = -1;
    private int lastPlane = -1;
    private byte[] lastSeriesPlane;

    public JPXReader() {
        super("JPX", "jpx");
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean validStart;
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        boolean bl = validStart = (stream.readShort() & 0xFFFF) == 65359;
        if (!validStart) {
            stream.skipBytes(2);
            validStart = stream.readInt() == JPEG2000BoxType.SIGNATURE.getCode();
        }
        stream.seek(stream.length() - 2L);
        boolean validEnd = (stream.readShort() & 0xFFFF) == 65497;
        return validStart && validEnd;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || FormatTools.getBytesPerPixel(this.getPixelType()) != 1) {
            return null;
        }
        byte[][] byteLut = new byte[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                byteLut[i][j] = (byte)(this.lut[i][j] & 0xFF);
            }
        }
        return byteLut;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || FormatTools.getBytesPerPixel(this.getPixelType()) != 2) {
            return null;
        }
        short[][] shortLut = new short[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                shortLut[i][j] = (short)(this.lut[i][j] & 0xFFFF);
            }
        }
        return shortLut;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.resolutionLevels = null;
            this.lut = null;
            this.pixelOffsets.clear();
            this.lastSeries = -1;
            this.lastPlane = -1;
            this.lastSeriesPlane = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.lastSeries == this.getSeries() && this.lastPlane == no && this.lastSeriesPlane != null) {
            RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
            return buf;
        }
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        if (this.resolutionLevels != null) {
            options.resolution = Math.abs(this.series - this.resolutionLevels);
        } else if (this.getSeriesCount() > 1) {
            options.resolution = this.series;
        }
        this.in.seek(this.pixelOffsets.get(no));
        this.lastSeriesPlane = new JPEG2000Codec().decompress(this.in, (CodecOptions)options);
        RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        this.lastSeries = this.getSeries();
        this.lastPlane = no;
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        JPEG2000MetadataParser metadataParser = new JPEG2000MetadataParser(this.in);
        if (metadataParser.isRawCodestream()) {
            LOGGER.info("Codestream is raw, using codestream dimensions.");
            this.core[0].sizeX = metadataParser.getCodestreamSizeX();
            this.core[0].sizeY = metadataParser.getCodestreamSizeY();
            this.core[0].sizeC = metadataParser.getCodestreamSizeC().shortValue();
            this.core[0].pixelType = metadataParser.getCodestreamPixelType();
        } else {
            LOGGER.info("Codestream is JP2 boxed, using header dimensions.");
            this.core[0].sizeX = metadataParser.getHeaderSizeX();
            this.core[0].sizeY = metadataParser.getHeaderSizeY();
            this.core[0].sizeC = metadataParser.getHeaderSizeC().shortValue();
            this.core[0].pixelType = metadataParser.getHeaderPixelType();
        }
        this.lut = metadataParser.getLookupTable();
        this.findPixelOffsets();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.pixelOffsets.size();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = true;
        this.core[0].littleEndian = false;
        boolean bl = this.core[0].indexed = !this.isRGB() && this.lut != null;
        if (this.resolutionLevels != null) {
            CoreMetadata[] newCore = new CoreMetadata[this.resolutionLevels + 1];
            newCore[0] = this.core[0];
            for (int i = 1; i < newCore.length; ++i) {
                newCore[i] = new CoreMetadata(this, 0);
                newCore[i].sizeX = newCore[i - 1].sizeX / 2;
                newCore[i].sizeY = newCore[i - 1].sizeY / 2;
                newCore[i].thumbnail = true;
            }
            this.core = newCore;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
    }

    private void findPixelOffsets() throws IOException {
        this.in.seek(0L);
        byte[] buf = new byte[8192];
        int overlap = 3;
        this.in.read(buf, 0, overlap);
        while (this.in.getFilePointer() < this.in.length()) {
            int n = this.in.read(buf, overlap, buf.length - overlap);
            for (int i = 0; i < n - overlap; ++i) {
                if (buf[i] != -1 || buf[i + 1] != 79 || buf[i + 2] != -1 || buf[i + 3] != 81) continue;
                this.pixelOffsets.add(this.in.getFilePointer() - (long)n + (long)i - (long)overlap);
            }
            System.arraycopy(buf, n - overlap, buf, 0, overlap);
        }
    }
}

