/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroscopeTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroscopeTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = MicroscopeTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Upright\\s*", "Upright");
        p.put("^\\s*Inverted\\s*", "Inverted");
        p.put("^\\s*Dissection\\s*", "Dissection");
        p.put("^\\s*Electrophysiology\\s*", "Electrophysiology");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return MicroscopeType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"MicroscopeType", (Object)value);
        return MicroscopeType.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return MicroscopeType.class;
    }
}

