/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.datasetenhancer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.DatasetEnhancer;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.datatype.DateRange;
import thredds.datatype.DateType;
import thredds.datatype.TimeDuration;

public class RegExpAndDurationTimeCoverageEnhancer
implements DatasetEnhancer {
    private static Logger log = LoggerFactory.getLogger(RegExpAndDurationTimeCoverageEnhancer.class);
    private String matchPattern;
    private String substitutionPattern;
    private String duration;
    private Pattern pattern;

    public RegExpAndDurationTimeCoverageEnhancer(String matchPattern, String substitutionPattern, String duration) {
        this.matchPattern = matchPattern;
        this.substitutionPattern = substitutionPattern;
        this.duration = duration;
        try {
            this.pattern = Pattern.compile(matchPattern);
        }
        catch (PatternSyntaxException e) {
            log.error("ctor(): bad match pattern <" + this.matchPattern + ">, failed to compile: " + e.getMessage());
            this.pattern = null;
        }
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getSubstitutionPattern() {
        return this.substitutionPattern;
    }

    public String getDuration() {
        return this.duration;
    }

    public Object getConfigObject() {
        return null;
    }

    public boolean addMetadata(InvDataset dataset, CrawlableDataset crDataset) {
        if (this.pattern == null) {
            log.error("addMetadata(): bad match pattern <" + this.matchPattern + ">.");
            return false;
        }
        Matcher matcher = this.pattern.matcher(crDataset.getName());
        if (!matcher.find()) {
            return false;
        }
        StringBuffer startTime = new StringBuffer();
        try {
            matcher.appendReplacement(startTime, this.substitutionPattern);
        }
        catch (IndexOutOfBoundsException e) {
            log.error("addMetadata(): capture group mismatch between match pattern <" + this.matchPattern + "> and substitution pattern <" + this.substitutionPattern + ">: " + e.getMessage());
            return false;
        }
        startTime.delete(0, matcher.start());
        try {
            ((InvDatasetImpl)dataset).setTimeCoverage(new DateRange(new DateType(startTime.toString(), null, null), null, new TimeDuration(this.duration), null));
        }
        catch (Exception e) {
            log.warn("addMetadata(): Start time <" + startTime.toString() + "> or duration <" + this.duration + "> not parsable" + " (crDataset.getName() <" + crDataset.getName() + ">, this.matchPattern() <" + this.matchPattern + ">, this.substitutionPattern() <" + this.substitutionPattern + ">): " + e.getMessage());
            return false;
        }
        return true;
    }
}

