/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected volatile boolean defaultAutoCommit = true;
    protected transient Boolean defaultReadOnly = null;
    protected volatile int defaultTransactionIsolation = -1;
    protected volatile String defaultCatalog = null;
    protected String driverClassName = null;
    protected ClassLoader driverClassLoader = null;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean poolPreparedStatements = false;
    protected int maxOpenPreparedStatements = -1;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;
    protected volatile String password = null;
    protected String url = null;
    protected String username = null;
    protected volatile String validationQuery = null;
    protected volatile int validationQueryTimeout = -1;
    protected volatile List connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private volatile boolean restartNeeded = false;
    protected volatile GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected volatile DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;
    protected boolean closed;

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
        this.restartNeeded = true;
    }

    public boolean getDefaultReadOnly() {
        Boolean bl = this.defaultReadOnly;
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this.restartNeeded = true;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
        this.restartNeeded = true;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String string) {
        this.driverClassName = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public synchronized void setDriverClassLoader(ClassLoader classLoader) {
        this.driverClassLoader = classLoader;
        this.restartNeeded = true;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int n) {
        this.maxActive = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxActive(n);
        }
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int n) {
        this.maxIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(n);
        }
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int n) {
        this.minIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(n);
        }
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int n) {
        this.initialSize = n;
        this.restartNeeded = true;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long l) {
        this.maxWait = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWait(l);
        }
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
        this.restartNeeded = true;
    }

    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
        this.restartNeeded = true;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(bl);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(bl);
        }
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(l);
        }
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(n);
        }
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(bl);
        }
    }

    public synchronized int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public synchronized int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
        this.restartNeeded = true;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String string) {
        this.url = string;
        this.restartNeeded = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
        this.restartNeeded = true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string != null && string.trim().length() > 0 ? string : null;
        this.restartNeeded = true;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeout = n;
        this.restartNeeded = true;
    }

    public Collection getConnectionInitSqls() {
        List list = this.connectionInitSqls;
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public void setConnectionInitSqls(Collection collection) {
        if (collection != null && collection.size() > 0) {
            ArrayList<String> arrayList = null;
            for (Object e : collection) {
                String string;
                if (e == null || (string = e.toString()).trim().length() <= 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            }
            this.connectionInitSqls = arrayList;
        } else {
            this.connectionInitSqls = null;
        }
        this.restartNeeded = true;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
        this.restartNeeded = true;
    }

    private boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public boolean getRemoveAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandoned();
        }
        return false;
    }

    public void setRemoveAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandoned(bl);
        this.restartNeeded = true;
    }

    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int n) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(n);
        this.restartNeeded = true;
    }

    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(bl);
        this.restartNeeded = true;
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionProperties.put(string, string2);
        this.restartNeeded = true;
    }

    public void removeConnectionProperty(String string) {
        this.connectionProperties.remove(string);
        this.restartNeeded = true;
    }

    public void setConnectionProperties(String string) {
        if (string == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] stringArray = string.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 0) continue;
            int n = string2.indexOf(61);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                properties.setProperty(string3, string4);
                continue;
            }
            properties.setProperty(string2, "");
        }
        this.connectionProperties = properties;
        this.restartNeeded = true;
    }

    public synchronized void close() throws SQLException {
        this.closed = true;
        GenericObjectPool genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot close connection pool", exception);
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        this.createConnectionPool();
        GenericKeyedObjectPoolFactory genericKeyedObjectPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            genericKeyedObjectPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        this.createPoolableConnectionFactory(connectionFactory, (KeyedObjectPoolFactory)genericKeyedObjectPoolFactory, this.abandonedConfig);
        this.createDataSourceInstance();
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception exception) {
            throw new SQLNestedException("Error preloading the connection pool", exception);
        }
        return this.dataSource;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String string;
        Class<?> clazz;
        block16: {
            clazz = null;
            if (this.driverClassName != null) {
                try {
                    try {
                        if (this.driverClassLoader == null) {
                            Class.forName(this.driverClassName);
                            break block16;
                        }
                        Class.forName(this.driverClassName, true, this.driverClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                    }
                }
                catch (Throwable throwable) {
                    String string2 = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                    this.logWriter.println(string2);
                    throwable.printStackTrace(this.logWriter);
                    throw new SQLNestedException(string2, throwable);
                }
            }
        }
        Driver driver = null;
        try {
            if (clazz == null) {
                driver = DriverManager.getDriver(this.url);
            } else {
                driver = (Driver)clazz.newInstance();
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
            }
        }
        catch (Throwable throwable) {
            String string3 = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(string3);
            throwable.printStackTrace(this.logWriter);
            throw new SQLNestedException(string3, throwable);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        if ((string = this.username) != null) {
            this.connectionProperties.put("user", string);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String string4 = this.password;
        if (string4 != null) {
            this.connectionProperties.put("password", string4);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }

    protected void createConnectionPool() {
        GenericObjectPool genericObjectPool = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandoned() ? new AbandonedObjectPool(null, this.abandonedConfig) : new GenericObjectPool();
        genericObjectPool.setMaxActive(this.maxActive);
        genericObjectPool.setMaxIdle(this.maxIdle);
        genericObjectPool.setMinIdle(this.minIdle);
        genericObjectPool.setMaxWait(this.maxWait);
        genericObjectPool.setTestOnBorrow(this.testOnBorrow);
        genericObjectPool.setTestOnReturn(this.testOnReturn);
        genericObjectPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        genericObjectPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        genericObjectPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        genericObjectPool.setTestWhileIdle(this.testWhileIdle);
        this.connectionPool = genericObjectPool;
    }

    protected void createDataSourceInstance() throws SQLException {
        PoolingDataSource poolingDataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        poolingDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        poolingDataSource.setLogWriter(this.logWriter);
        this.dataSource = poolingDataSource;
    }

    protected void createPoolableConnectionFactory(ConnectionFactory connectionFactory, KeyedObjectPoolFactory keyedObjectPoolFactory, AbandonedConfig abandonedConfig) throws SQLException {
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, (ObjectPool)this.connectionPool, keyedObjectPoolFactory, this.validationQuery, this.validationQueryTimeout, this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, abandonedConfig);
            BasicDataSource.validateConnectionFactory(poolableConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void validateConnectionFactory(PoolableConnectionFactory poolableConnectionFactory) throws Exception {
        Connection connection = null;
        try {
            connection = (Connection)poolableConnectionFactory.makeObject();
            poolableConnectionFactory.activateObject(connection);
            poolableConnectionFactory.validateConnection(connection);
            poolableConnectionFactory.passivateObject(connection);
        }
        finally {
            poolableConnectionFactory.destroyObject(connection);
        }
    }

    private void restart() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            this.log("Could not restart DataSource, cause: " + sQLException.getMessage());
        }
    }

    protected void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

