/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected volatile ConnectionFactory _connFactory = null;
    protected volatile String _validationQuery = null;
    protected volatile int _validationQueryTimeout = -1;
    protected Collection _connectionInitSqls = null;
    protected volatile ObjectPool _pool = null;
    protected volatile KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected Boolean _defaultReadOnly = null;
    protected boolean _defaultAutoCommit = true;
    protected int _defaultTransactionIsolation = -1;
    protected String _defaultCatalog;
    protected AbandonedConfig _config = null;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, Collection collection, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, Collection collection, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, Collection collection, boolean bl, boolean bl2, int n) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, boolean bl, boolean bl2, int n2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, Collection collection, boolean bl, boolean bl2, int n2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, Boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, Collection collection, Boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, Boolean bl, boolean bl2, int n2, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool objectPool, KeyedObjectPoolFactory keyedObjectPoolFactory, String string, int n, Collection collection, Boolean bl, boolean bl2, int n2, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
        this._defaultCatalog = string2;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connFactory = connectionFactory;
    }

    public void setValidationQuery(String string) {
        this._validationQuery = string;
    }

    public void setValidationQueryTimeout(int n) {
        this._validationQueryTimeout = n;
    }

    public synchronized void setConnectionInitSql(Collection collection) {
        this._connectionInitSqls = collection;
    }

    public synchronized void setPool(ObjectPool objectPool) {
        if (null != this._pool && objectPool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = objectPool;
    }

    public synchronized ObjectPool getPool() {
        return this._pool;
    }

    public void setStatementPoolFactory(KeyedObjectPoolFactory keyedObjectPoolFactory) {
        this._stmtPoolFactory = keyedObjectPoolFactory;
    }

    public void setDefaultReadOnly(boolean bl) {
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this._defaultAutoCommit = bl;
    }

    public void setDefaultTransactionIsolation(int n) {
        this._defaultTransactionIsolation = n;
    }

    public void setDefaultCatalog(String string) {
        this._defaultCatalog = string;
    }

    public Object makeObject() throws Exception {
        Connection connection = this._connFactory.createConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(connection);
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool keyedObjectPool = this._stmtPoolFactory.createPool();
            connection = new PoolingConnection(connection, keyedObjectPool);
            keyedObjectPool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)connection));
        }
        return new PoolableConnection(connection, this._pool, this._config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConnection(Connection connection) throws SQLException {
        Collection collection = this._connectionInitSqls;
        if (connection.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != collection) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                for (Object e : collection) {
                    if (e == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    String string = e.toString();
                    statement.execute(string);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void destroyObject(Object object) throws Exception {
        if (object instanceof PoolableConnection) {
            ((PoolableConnection)object).reallyClose();
        }
    }

    public boolean validateObject(Object object) {
        if (object instanceof Connection) {
            try {
                this.validateConnection((Connection)object);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection connection) throws SQLException {
        String string = this._validationQuery;
        if (connection.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (null != string) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                if (this._validationQueryTimeout > 0) {
                    statement.setQueryTimeout(this._validationQueryTimeout);
                }
                if (!(resultSet = statement.executeQuery(string)).next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void passivateObject(Object object) throws Exception {
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            if (!connection.getAutoCommit() && !connection.isReadOnly()) {
                connection.rollback();
            }
            connection.clearWarnings();
            if (!connection.getAutoCommit()) {
                connection.setAutoCommit(true);
            }
        }
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).passivate();
        }
    }

    public void activateObject(Object object) throws Exception {
        if (object instanceof DelegatingConnection) {
            ((DelegatingConnection)object).activate();
        }
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            if (connection.getAutoCommit() != this._defaultAutoCommit) {
                connection.setAutoCommit(this._defaultAutoCommit);
            }
            if (this._defaultTransactionIsolation != -1 && connection.getTransactionIsolation() != this._defaultTransactionIsolation) {
                connection.setTransactionIsolation(this._defaultTransactionIsolation);
            }
            if (this._defaultReadOnly != null && connection.isReadOnly() != this._defaultReadOnly.booleanValue()) {
                connection.setReadOnly(this._defaultReadOnly);
            }
            if (this._defaultCatalog != null && !this._defaultCatalog.equals(connection.getCatalog())) {
                connection.setCatalog(this._defaultCatalog);
            }
        }
    }
}

