/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.dbcp.managed.XAConnectionFactory;

public class DataSourceXAConnectionFactory
implements XAConnectionFactory {
    protected TransactionRegistry transactionRegistry;
    protected XADataSource xaDataSource;
    protected String username;
    protected String password;

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource) {
        this(transactionManager, xADataSource, null, null);
    }

    public DataSourceXAConnectionFactory(TransactionManager transactionManager, XADataSource xADataSource, String string, String string2) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (xADataSource == null) {
            throw new NullPointerException("xaDataSource is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.xaDataSource = xADataSource;
        this.username = string;
        this.password = string2;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public Connection createConnection() throws SQLException {
        XAConnection xAConnection = this.username == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.username, this.password);
        Connection connection = xAConnection.getConnection();
        XAResource xAResource = xAConnection.getXAResource();
        this.transactionRegistry.registerConnection(connection, xAResource);
        return connection;
    }
}

