/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.Iterator;

public class HDF5EnumerationValueMDArray
implements Iterable<MDAbstractArray.ArrayEntry> {
    private final HDF5EnumerationType type;
    private final int size;
    private HDF5EnumerationType.EnumStorageForm storageForm;
    private MDByteArray bArrayOrNull;
    private MDShortArray sArrayOrNull;
    private MDIntArray iArrayOrNull;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HDF5EnumerationValueMDArray(HDF5EnumerationType type, MDAbstractArray<?> ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.size = ordinalArray.size();
        if (ordinalArray instanceof MDByteArray) {
            MDByteArray bArray = (MDByteArray)ordinalArray;
            this.setOrdinalArray(bArray);
            return;
        } else if (ordinalArray instanceof MDShortArray) {
            MDShortArray sArray = (MDShortArray)ordinalArray;
            this.setOrdinalArray(sArray);
            return;
        } else if (ordinalArray instanceof MDIntArray) {
            MDIntArray iArray = (MDIntArray)ordinalArray;
            this.setOrdinalArray(iArray);
            return;
        } else {
            if (!(ordinalArray instanceof MDArray)) throw new IllegalArgumentException("array is of illegal type " + ordinalArray.getClass().getCanonicalName());
            MDArray concreteArray = (MDArray)ordinalArray;
            if (concreteArray.getAsFlatArray().getClass().getComponentType() == String.class) {
                MDArray sArray = concreteArray;
                this.map((MDArray<String>)sArray);
                return;
            } else {
                if (!concreteArray.getAsFlatArray().getClass().getComponentType().isEnum()) throw new IllegalArgumentException("array has illegal component type " + concreteArray.getAsFlatArray().getClass().getComponentType().getCanonicalName());
                MDArray eArray = concreteArray;
                this.map(HDF5EnumerationValueMDArray.toString(eArray));
            }
        }
    }

    public HDF5EnumerationValueMDArray(HDF5EnumerationType type, MDByteArray ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.size = ordinalArray.size();
        this.setOrdinalArray(ordinalArray);
    }

    public HDF5EnumerationValueMDArray(HDF5EnumerationType type, MDShortArray ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.size = ordinalArray.size();
        this.setOrdinalArray(ordinalArray);
    }

    public HDF5EnumerationValueMDArray(HDF5EnumerationType type, MDIntArray ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.size = ordinalArray.size();
        this.setOrdinalArray(ordinalArray);
    }

    private static MDArray<String> toString(MDArray<Enum<?>> valueArray) {
        Enum[] flatEnumArray = (Enum[])valueArray.getAsFlatArray();
        MDArray result = new MDArray(String.class, valueArray.dimensions());
        String[] flatStringArray = (String[])result.getAsFlatArray();
        int i = 0;
        while (i < flatEnumArray.length) {
            flatStringArray[i] = flatEnumArray[i].name();
            ++i;
        }
        return result;
    }

    private void map(MDArray<String> array) throws IllegalArgumentException {
        String[] flatArray = (String[])array.getAsFlatArray();
        if (this.type.getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = new MDByteArray(array.dimensions());
            byte[] flatBArray = this.bArrayOrNull.getAsFlatArray();
            int i = 0;
            while (i < flatArray.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(flatArray[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + flatArray[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                flatBArray[i] = indexOrNull.byteValue();
                ++i;
            }
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = new MDShortArray(array.dimensions());
            short[] flatSArray = this.sArrayOrNull.getAsFlatArray();
            int i = 0;
            while (i < flatArray.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(flatArray[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + flatArray[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                flatSArray[i] = indexOrNull.shortValue();
                ++i;
            }
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = new MDIntArray(array.dimensions());
            int[] flatIArray = this.iArrayOrNull.getAsFlatArray();
            int i = 0;
            while (i < flatIArray.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(flatArray[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + flatArray[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                flatIArray[i] = indexOrNull;
                ++i;
            }
        }
    }

    private void setOrdinalArray(MDByteArray array) {
        if (this.type.getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = array;
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = this.toShortArray(array);
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = this.toIntArray(array);
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private void setOrdinalArray(MDShortArray array) throws IllegalArgumentException {
        if (this.type.getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = this.toByteArray(array);
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = array;
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = this.toIntArray(array);
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private void setOrdinalArray(MDIntArray array) throws IllegalArgumentException {
        if (this.type.getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = this.toByteArray(array);
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = this.toShortArray(array);
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = array;
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private MDByteArray toByteArray(MDShortArray array) throws IllegalArgumentException {
        short[] flatSourceArray = array.getAsFlatArray();
        MDByteArray bArray = new MDByteArray(array.dimensions());
        byte[] flatTargetArray = bArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = (byte)flatSourceArray[i];
            if (flatTargetArray[i] != flatSourceArray[i]) {
                throw new IllegalArgumentException("Value " + flatSourceArray[i] + " cannot be stored in byte array");
            }
            ++i;
        }
        return bArray;
    }

    private MDByteArray toByteArray(MDIntArray array) throws IllegalArgumentException {
        int[] flatSourceArray = array.getAsFlatArray();
        MDByteArray bArray = new MDByteArray(array.dimensions());
        byte[] flatTargetArray = bArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = (byte)flatSourceArray[i];
            if (flatTargetArray[i] != flatSourceArray[i]) {
                throw new IllegalArgumentException("Value " + flatSourceArray[i] + " cannot be stored in byte array");
            }
            ++i;
        }
        return bArray;
    }

    private MDShortArray toShortArray(MDByteArray array) {
        byte[] flatSourceArray = array.getAsFlatArray();
        MDShortArray sArray = new MDShortArray(array.dimensions());
        short[] flatTargetArray = sArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = flatSourceArray[i];
            ++i;
        }
        return sArray;
    }

    private MDShortArray toShortArray(MDIntArray array) throws IllegalArgumentException {
        int[] flatSourceArray = array.getAsFlatArray();
        MDShortArray sArray = new MDShortArray(array.dimensions());
        short[] flatTargetArray = sArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = (short)flatSourceArray[i];
            if (flatSourceArray[i] != flatTargetArray[i]) {
                throw new IllegalArgumentException("Value " + flatSourceArray[i] + " cannot be stored in short array");
            }
            ++i;
        }
        return sArray;
    }

    private MDIntArray toIntArray(MDByteArray array) {
        byte[] flatSourceArray = array.getAsFlatArray();
        MDIntArray iArray = new MDIntArray(array.dimensions());
        int[] flatTargetArray = iArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = flatSourceArray[i];
            ++i;
        }
        return iArray;
    }

    private MDIntArray toIntArray(MDShortArray array) {
        short[] flatSourceArray = array.getAsFlatArray();
        MDIntArray iArray = new MDIntArray(array.dimensions());
        int[] flatTargetArray = iArray.getAsFlatArray();
        int i = 0;
        while (i < flatSourceArray.length) {
            flatTargetArray[i] = flatSourceArray[i];
            ++i;
        }
        return iArray;
    }

    private void checkOrdinalArray(MDByteArray array) throws IllegalArgumentException {
        byte[] flatArray = array.getAsFlatArray();
        int i = 0;
        while (i < flatArray.length) {
            if (flatArray[i] < 0 || flatArray[i] >= this.type.getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + flatArray[i] + " out of allowed range [0.." + (this.type.getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    private void checkOrdinalArray(MDShortArray array) throws IllegalArgumentException {
        short[] flatArray = array.getAsFlatArray();
        int i = 0;
        while (i < flatArray.length) {
            if (flatArray[i] < 0 || flatArray[i] >= this.type.getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + flatArray[i] + " out of allowed range [0.." + (this.type.getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    private void checkOrdinalArray(MDIntArray array) throws IllegalArgumentException {
        int[] flatArray = array.getAsFlatArray();
        int i = 0;
        while (i < flatArray.length) {
            if (flatArray[i] < 0 || flatArray[i] >= this.type.getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + flatArray[i] + " out of allowed range [0.." + (this.type.getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    HDF5EnumerationType.EnumStorageForm getStorageForm() {
        return this.storageForm;
    }

    public HDF5EnumerationType getType() {
        return this.type;
    }

    public int size() {
        return this.size;
    }

    public int[] dimensions() {
        return this.getOrdinalValues().dimensions();
    }

    public long[] longDimensions() {
        return this.getOrdinalValues().longDimensions();
    }

    public int getOrdinal(int arrayIndex) {
        if (this.bArrayOrNull != null) {
            return this.bArrayOrNull.get(arrayIndex);
        }
        if (this.sArrayOrNull != null) {
            return this.sArrayOrNull.get(arrayIndex);
        }
        return this.iArrayOrNull.get(arrayIndex);
    }

    public int getOrdinal(int arrayIndexX, int arrayIndexY) {
        if (this.bArrayOrNull != null) {
            return this.bArrayOrNull.get(arrayIndexX, arrayIndexY);
        }
        if (this.sArrayOrNull != null) {
            return this.sArrayOrNull.get(arrayIndexX, arrayIndexY);
        }
        return this.iArrayOrNull.get(arrayIndexX, arrayIndexY);
    }

    public int getOrdinal(int ... arrayIndices) {
        if (this.bArrayOrNull != null) {
            return this.bArrayOrNull.get(arrayIndices);
        }
        if (this.sArrayOrNull != null) {
            return this.sArrayOrNull.get(arrayIndices);
        }
        return this.iArrayOrNull.get(arrayIndices);
    }

    public String getValue(int arrayIndex) {
        return this.type.getValues().get(this.getOrdinal(arrayIndex));
    }

    public String getValue(int arrayIndexX, int arrayIndexY) {
        return this.type.getValues().get(this.getOrdinal(arrayIndexX, arrayIndexY));
    }

    public String getValue(int ... arrayIndices) {
        return this.type.getValues().get(this.getOrdinal(arrayIndices));
    }

    public <T extends Enum<T>> T getValue(Class<T> enumClass, int ... arrayIndices) {
        return Enum.valueOf(enumClass, this.getValue(arrayIndices));
    }

    public MDArray<String> toStringArray() {
        int len = this.size();
        MDArray values = new MDArray(String.class, this.dimensions());
        String[] flatValues = (String[])values.getAsFlatArray();
        int i = 0;
        while (i < len) {
            flatValues[i] = this.getValue(i);
            ++i;
        }
        return values;
    }

    public <T extends Enum<T>> MDArray<T> toEnumArray(Class<T> enumClass) {
        int len = this.size();
        MDArray values = new MDArray(enumClass, this.dimensions());
        Enum[] flatValues = (Enum[])values.getAsFlatArray();
        int i = 0;
        while (i < len) {
            flatValues[i] = Enum.valueOf(enumClass, this.getValue(i));
            ++i;
        }
        return values;
    }

    public MDAbstractArray<?> getOrdinalValues() {
        switch (this.getStorageForm()) {
            case BYTE: {
                return this.bArrayOrNull;
            }
            case SHORT: {
                return this.sArrayOrNull;
            }
            case INT: {
                return this.iArrayOrNull;
            }
        }
        throw new Error("Illegal storage form.");
    }

    byte[] toStorageForm() {
        switch (this.getStorageForm()) {
            case BYTE: {
                return this.bArrayOrNull.getAsFlatArray();
            }
            case SHORT: {
                return NativeData.shortToByte((short[])this.sArrayOrNull.getAsFlatArray(), (NativeData.ByteOrder)NativeData.ByteOrder.NATIVE);
            }
            case INT: {
                return NativeData.intToByte((int[])this.iArrayOrNull.getAsFlatArray(), (NativeData.ByteOrder)NativeData.ByteOrder.NATIVE);
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)this.getStorageForm()) + ".)");
    }

    static HDF5EnumerationValueMDArray fromStorageForm(HDF5EnumerationType enumType, byte[] data, int offset, int[] dimensions, int len) {
        switch (enumType.getStorageForm()) {
            case BYTE: {
                byte[] subArray = new byte[len];
                System.arraycopy(data, offset, subArray, 0, len);
                return new HDF5EnumerationValueMDArray(enumType, new MDByteArray(subArray, dimensions));
            }
            case SHORT: {
                return new HDF5EnumerationValueMDArray(enumType, new MDShortArray(HDFNativeData.byteToShort(data, offset, len), dimensions));
            }
            case INT: {
                return new HDF5EnumerationValueMDArray(enumType, new MDIntArray(HDFNativeData.byteToInt(data, offset, len), dimensions));
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)enumType.getStorageForm()) + ".)");
    }

    @Override
    public Iterator<MDAbstractArray.ArrayEntry> iterator() {
        return this.toStringArray().iterator();
    }

    public String toString() {
        return this.toStringArray().toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bArrayOrNull == null ? 0 : this.bArrayOrNull.hashCode());
        result = 31 * result + (this.iArrayOrNull == null ? 0 : this.iArrayOrNull.hashCode());
        result = 31 * result + (this.sArrayOrNull == null ? 0 : this.sArrayOrNull.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + (this.storageForm == null ? 0 : this.storageForm.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5EnumerationValueMDArray other = (HDF5EnumerationValueMDArray)obj;
        if (this.bArrayOrNull == null ? other.bArrayOrNull != null : !this.bArrayOrNull.equals((Object)other.bArrayOrNull)) {
            return false;
        }
        if (this.iArrayOrNull == null ? other.iArrayOrNull != null : !this.iArrayOrNull.equals((Object)other.iArrayOrNull)) {
            return false;
        }
        if (this.sArrayOrNull == null ? other.sArrayOrNull != null : !this.sArrayOrNull.equals((Object)other.sArrayOrNull)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.storageForm != other.storageForm) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

