/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.AdapterIOutputStreamToOutputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IOutputStream;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5FactoryProvider;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryExtractProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryListProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryVerifyProcessor;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingStrategy;
import ch.systemsx.cisd.hdf5.h5ar.DirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveDeleter;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveTraverser;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveUpdater;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5ArchiveInfoProvider;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5Archiver;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.ListParameters;
import ch.systemsx.cisd.hdf5.h5ar.NewArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.UnarchivingException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import ch.systemsx.cisd.hdf5.h5ar.VerifyParameters;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

final class HDF5Archiver
implements Closeable,
Flushable,
IHDF5Archiver,
IHDF5ArchiveInfoProvider {
    private static final String HOUSEKEEPING_SUFFIX = "\u0001\u0000";
    public static final int CHUNK_SIZE_AUTO = -1;
    private static final int MB = 0x100000;
    static final int BUFFER_SIZE = 0xA00000;
    private final IHDF5Reader hdf5Reader;
    private final IHDF5Writer hdf5WriterOrNull;
    private final boolean closeReaderOnCloseFile;
    private final IErrorStrategy errorStrategy;
    private final IDirectoryIndexProvider indexProvider;
    private final byte[] buffer = new byte[0xA00000];
    private final HDF5ArchiveUpdater updaterOrNull;
    private final HDF5ArchiveDeleter deleterOrNull;
    private final HDF5ArchiveTraverser processor;
    private final IdCache idCache;

    static IHDF5Reader createHDF5Reader(File archiveFile) {
        return HDF5FactoryProvider.get().openForReading(archiveFile);
    }

    static IHDF5Writer createHDF5Writer(File archiveFile, IHDF5WriterConfigurator.FileFormat fileFormat, boolean noSync) {
        IHDF5WriterConfigurator config = HDF5FactoryProvider.get().configure(archiveFile);
        config.fileFormat(fileFormat);
        config.useUTF8CharacterEncoding();
        config.houseKeepingNameSuffix(HOUSEKEEPING_SUFFIX);
        if (!noSync) {
            config.syncMode(IHDF5WriterConfigurator.SyncMode.SYNC);
        }
        return config.writer();
    }

    HDF5Archiver(File archiveFile, boolean readOnly) {
        this(archiveFile, readOnly, false, IHDF5WriterConfigurator.FileFormat.STRICTLY_1_6, null);
    }

    HDF5Archiver(File archiveFile, boolean readOnly, boolean noSync, IHDF5WriterConfigurator.FileFormat fileFormat, IErrorStrategy errorStrategyOrNull) {
        this.closeReaderOnCloseFile = true;
        this.hdf5WriterOrNull = readOnly ? null : HDF5Archiver.createHDF5Writer(archiveFile, fileFormat, noSync);
        this.hdf5Reader = this.hdf5WriterOrNull != null ? this.hdf5WriterOrNull : HDF5Archiver.createHDF5Reader(archiveFile);
        this.errorStrategy = errorStrategyOrNull == null ? IErrorStrategy.DEFAULT_ERROR_STRATEGY : errorStrategyOrNull;
        this.indexProvider = new DirectoryIndexProvider(this.hdf5Reader, this.errorStrategy);
        this.idCache = new IdCache();
        this.processor = new HDF5ArchiveTraverser(new HDF5ArchiveTraverser.IDirectoryChecker(){

            @Override
            public boolean isDirectoryFollowSymlinks(ArchiveEntry entry) {
                ArchiveEntry resolvedEntry = HDF5Archiver.this.tryResolveLink(entry);
                return resolvedEntry == null ? false : resolvedEntry.isDirectory();
            }
        }, this.hdf5Reader, this.indexProvider, this.idCache);
        if (this.hdf5WriterOrNull == null) {
            this.updaterOrNull = null;
            this.deleterOrNull = null;
        } else {
            this.updaterOrNull = new HDF5ArchiveUpdater(this.hdf5WriterOrNull, this.indexProvider, this.idCache, this.buffer);
            this.deleterOrNull = new HDF5ArchiveDeleter(this.hdf5WriterOrNull, this.indexProvider, this.idCache);
        }
    }

    HDF5Archiver(IHDF5Reader reader, boolean enforceReadOnly, IErrorStrategy errorStrategyOrNull) {
        this.closeReaderOnCloseFile = false;
        this.hdf5WriterOrNull = !enforceReadOnly && reader instanceof IHDF5Writer ? (IHDF5Writer)reader : null;
        this.errorStrategy = errorStrategyOrNull == null ? IErrorStrategy.DEFAULT_ERROR_STRATEGY : errorStrategyOrNull;
        this.hdf5Reader = reader;
        this.indexProvider = new DirectoryIndexProvider(this.hdf5Reader, this.errorStrategy);
        this.idCache = new IdCache();
        this.processor = new HDF5ArchiveTraverser(new HDF5ArchiveTraverser.IDirectoryChecker(){

            @Override
            public boolean isDirectoryFollowSymlinks(ArchiveEntry entry) {
                return HDF5Archiver.this.tryResolveLink(entry).isDirectory();
            }
        }, this.hdf5Reader, this.indexProvider, this.idCache);
        if (this.hdf5WriterOrNull == null) {
            this.updaterOrNull = null;
            this.deleterOrNull = null;
        } else {
            this.updaterOrNull = new HDF5ArchiveUpdater(this.hdf5WriterOrNull, this.indexProvider, this.idCache, this.buffer);
            this.deleterOrNull = new HDF5ArchiveDeleter(this.hdf5WriterOrNull, this.indexProvider, this.idCache);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.flush();
        }
        if (this.closeReaderOnCloseFile) {
            this.hdf5Reader.close();
        } else {
            this.indexProvider.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.hdf5Reader.file().isClosed();
    }

    @Override
    public void flush() {
        if (this.hdf5WriterOrNull != null) {
            this.hdf5WriterOrNull.file().flush();
        }
    }

    @Override
    public boolean exists(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        return this.indexProvider.get(parentPath, false).exists(name);
    }

    @Override
    public boolean isDirectory(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        return this.indexProvider.get(parentPath, false).isDirectory(name);
    }

    @Override
    public boolean isRegularFile(String path) {
        return HDF5Archiver.isRegularFile(this.tryGetLink(path, false));
    }

    @Override
    public boolean isSymLink(String path) {
        return HDF5Archiver.isSymLink(this.tryGetLink(path, false));
    }

    @Override
    public ArchiveEntry tryGetEntry(String path, boolean readLinkTarget) {
        String normalizedPath = Utils.normalizePath(path);
        if ("/".equals(normalizedPath)) {
            return new ArchiveEntry("", "/", LinkRecord.getLinkRecordForArchiveRoot(this.hdf5Reader.file().getFile()), this.idCache);
        }
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        return Utils.tryToArchiveEntry(parentPath, normalizedPath, this.indexProvider.get(parentPath, readLinkTarget).tryGetLink(name), this.idCache);
    }

    private LinkRecord tryGetLink(String path, boolean readLinkTargets) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        return this.indexProvider.get(parentPath, readLinkTargets).tryGetLink(name);
    }

    @Override
    public ArchiveEntry tryResolveLink(ArchiveEntry entry) {
        if (entry == null) {
            return null;
        }
        ArchiveEntry workEntry = entry;
        String firstPath = null;
        if (entry.isSymLink()) {
            HashSet<String> workPathSet = null;
            while (workEntry != null && workEntry.isSymLink()) {
                String linkTarget;
                if (firstPath == null) {
                    firstPath = workEntry.getPath();
                } else {
                    if (workPathSet == null) {
                        workPathSet = new HashSet<String>();
                        workPathSet.add(firstPath);
                    }
                    if (workPathSet.contains(workEntry.getPath())) {
                        return null;
                    }
                    workPathSet.add(workEntry.getPath());
                }
                if (workEntry.hasLinkTarget()) {
                    linkTarget = workEntry.getLinkTarget();
                } else {
                    workEntry = this.tryGetEntry(workEntry.getPath(), true);
                    linkTarget = workEntry.getLinkTarget();
                }
                if (!linkTarget.startsWith("/")) {
                    linkTarget = Utils.concatLink(workEntry.getParentPath(), linkTarget);
                }
                if ((linkTarget = Utils.normalizePath(linkTarget)) == null) {
                    return null;
                }
                workEntry = this.tryGetEntry(linkTarget, true);
            }
        }
        return workEntry;
    }

    @Override
    public ArchiveEntry tryGetResolvedEntry(String path, boolean keepPath) {
        ArchiveEntry entry = this.tryGetEntry(path, true);
        ArchiveEntry resolvedEntry = this.tryResolveLink(entry);
        if (resolvedEntry == null) {
            return null;
        }
        if (entry != resolvedEntry && keepPath) {
            resolvedEntry = new ArchiveEntry(entry, resolvedEntry);
        }
        return resolvedEntry;
    }

    private static boolean isRegularFile(LinkRecord linkOrNull) {
        return linkOrNull != null && linkOrNull.isRegularFile();
    }

    private static boolean isSymLink(LinkRecord linkOrNull) {
        return linkOrNull != null && linkOrNull.isSymLink();
    }

    @Override
    public List<ArchiveEntry> list() {
        return this.list("/", ListParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> list(String fileOrDir) {
        return this.list(fileOrDir, ListParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> list(String fileOrDir, ListParameters params) {
        final ArrayList<ArchiveEntry> result = new ArrayList<ArchiveEntry>(100);
        this.list(fileOrDir, new IArchiveEntryVisitor(){

            @Override
            public void visit(ArchiveEntry entry) {
                result.add(entry);
            }
        }, params);
        return result;
    }

    @Override
    public List<ArchiveEntry> test() {
        final ArrayList<ArchiveEntry> result = new ArrayList<ArchiveEntry>(100);
        this.list("/", new IArchiveEntryVisitor(){

            @Override
            public void visit(ArchiveEntry entry) {
                if (!entry.isOK()) {
                    result.add(entry);
                }
            }
        }, ListParameters.TEST);
        return result;
    }

    @Override
    public IHDF5Archiver list(String fileOrDir, IArchiveEntryVisitor visitor) {
        return this.list(fileOrDir, visitor, ListParameters.DEFAULT);
    }

    @Override
    public IHDF5Archiver list(String fileOrDir, final IArchiveEntryVisitor visitor, final ListParameters params) {
        final String normalizedPath = Utils.normalizePath(fileOrDir);
        IArchiveEntryVisitor decoratedVisitor = new IArchiveEntryVisitor(){

            @Override
            public void visit(ArchiveEntry entry) {
                if (!params.isIncludeTopLevelDirectoryEntry() && normalizedPath.equals(entry.getPath())) {
                    return;
                }
                ArchiveEntry workEntry = entry;
                if (workEntry.isSymLink() && params.isResolveSymbolicLinks()) {
                    if ((workEntry = HDF5Archiver.this.tryResolveLink(workEntry)) == null) {
                        return;
                    }
                    if (workEntry != entry) {
                        workEntry = new ArchiveEntry(entry, workEntry);
                    }
                }
                if (!params.isSuppressDirectoryEntries() || !workEntry.isDirectory()) {
                    visitor.visit(workEntry);
                }
            }
        };
        ArchiveEntryListProcessor listProcessor = new ArchiveEntryListProcessor(decoratedVisitor, this.buffer, params.isTestArchive());
        this.processor.process(normalizedPath, params.isRecursive(), params.isReadLinkTargets(), params.isFollowSymbolicLinks(), listProcessor);
        return this;
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(File rootDirectoryOnFS) {
        return this.verifyAgainstFilesystem("/", rootDirectoryOnFS, VerifyParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS) {
        return this.verifyAgainstFilesystem(fileOrDir, rootDirectoryOnFS, VerifyParameters.DEFAULT);
    }

    @Override
    public IHDF5Archiver verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, IArchiveEntryVisitor visitor) {
        return this.verifyAgainstFilesystem(fileOrDir, rootDirectoryOnFS, visitor, VerifyParameters.DEFAULT);
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, VerifyParameters params) {
        final ArrayList<ArchiveEntry> verifyErrors = new ArrayList<ArchiveEntry>();
        this.verifyAgainstFilesystem(fileOrDir, rootDirectoryOnFS, new IArchiveEntryVisitor(){

            @Override
            public void visit(ArchiveEntry entry) {
                if (!entry.isOK()) {
                    verifyErrors.add(entry);
                }
            }
        }, params);
        return verifyErrors;
    }

    @Override
    public IHDF5Archiver verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, IArchiveEntryVisitor visitor, VerifyParameters params) {
        ArchiveEntryVerifyProcessor verifyProcessor = new ArchiveEntryVerifyProcessor(visitor, rootDirectoryOnFS, this.buffer, params.isVerifyAttributes(), params.isNumeric());
        this.processor.process(fileOrDir, params.isRecursive(), true, false, verifyProcessor);
        return this;
    }

    @Override
    public IHDF5Archiver verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, String rootDirectoryInArchive, IArchiveEntryVisitor visitor, VerifyParameters params) {
        ArchiveEntryVerifyProcessor verifyProcessor = new ArchiveEntryVerifyProcessor(visitor, rootDirectoryOnFS, rootDirectoryInArchive, this.buffer, params.isVerifyAttributes(), params.isNumeric());
        this.processor.process(fileOrDir, params.isRecursive(), true, false, verifyProcessor);
        return this;
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, String rootDirectoryInArchive, VerifyParameters params) {
        final ArrayList<ArchiveEntry> verifyErrors = new ArrayList<ArchiveEntry>();
        this.verifyAgainstFilesystem(fileOrDir, rootDirectoryOnFS, rootDirectoryInArchive, new IArchiveEntryVisitor(){

            @Override
            public void visit(ArchiveEntry entry) {
                if (!entry.isOK()) {
                    verifyErrors.add(entry);
                }
            }
        }, params);
        return verifyErrors;
    }

    @Override
    public List<ArchiveEntry> verifyAgainstFilesystem(String fileOrDir, File rootDirectoryOnFS, String rootDirectoryInArchive) {
        return this.verifyAgainstFilesystem(fileOrDir, rootDirectoryOnFS, rootDirectoryInArchive, VerifyParameters.DEFAULT);
    }

    @Override
    public IHDF5Archiver extractFile(String path, OutputStream out) throws IOExceptionUnchecked {
        if (!this.hdf5Reader.object().isDataSet(path)) {
            this.errorStrategy.dealWithError((Throwable)new UnarchivingException(path, "not found in archive"));
            return this;
        }
        try {
            for (HDF5DataBlock<byte[]> block : this.hdf5Reader.opaque().getArrayNaturalBlocks(path)) {
                out.write(block.getData());
            }
        }
        catch (IOException ex) {
            this.errorStrategy.dealWithError((Throwable)new UnarchivingException(new File("stdout"), ex));
        }
        return this;
    }

    @Override
    public byte[] extractFileAsByteArray(String path) throws IOExceptionUnchecked {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.extractFile(path, out);
        return out.toByteArray();
    }

    @Override
    public IInputStream extractFileAsIInputStream(String path) {
        if (!this.hdf5Reader.object().isDataSet(path)) {
            this.errorStrategy.dealWithError((Throwable)new UnarchivingException(path, "not found in archive"));
            return null;
        }
        return HDF5IOAdapterFactory.asIInputStream(this.hdf5Reader, path);
    }

    @Override
    public InputStream extractFileAsInputStream(String path) {
        return new AdapterIInputStreamToInputStream(this.extractFileAsIInputStream(path));
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File rootDirectory) throws IllegalStateException {
        return this.extractToFilesystemBelowDirectory(rootDirectory, "", "/", ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File rootDirectory, String path) throws IllegalStateException {
        return this.extractToFilesystemBelowDirectory(rootDirectory, "", path, ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File rootDirectory, String path, IArchiveEntryVisitor visitorOrNull) throws IllegalStateException {
        return this.extractToFilesystemBelowDirectory(rootDirectory, "", path, ArchivingStrategy.DEFAULT, visitorOrNull);
    }

    @Override
    public IHDF5Archiver extractToFilesystem(File rootDirectory, String path, ArchivingStrategy strategy, IArchiveEntryVisitor visitorOrNull) throws IllegalStateException {
        return this.extractToFilesystemBelowDirectory(rootDirectory, "", path, strategy, visitorOrNull);
    }

    @Override
    public IHDF5Archiver extractToFilesystemBelowDirectory(File rootDirectory, String rootPathInArchive) {
        return this.extractToFilesystemBelowDirectory(rootDirectory, rootPathInArchive, "", ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver extractToFilesystemBelowDirectory(File rootDirectory, String rootPathInArchive, IArchiveEntryVisitor visitorOrNull) {
        return this.extractToFilesystemBelowDirectory(rootDirectory, rootPathInArchive, "", ArchivingStrategy.DEFAULT, visitorOrNull);
    }

    @Override
    public IHDF5Archiver extractToFilesystemBelowDirectory(File rootDirectory, String rootPathInArchive, ArchivingStrategy strategy, IArchiveEntryVisitor visitorOrNull) {
        return this.extractToFilesystemBelowDirectory(rootDirectory, rootPathInArchive, "", strategy, visitorOrNull);
    }

    @Override
    public IHDF5Archiver extractToFilesystemBelowDirectory(File rootDirectory, String rootPathInArchive, String path, ArchivingStrategy strategy, IArchiveEntryVisitor visitorOrNull) throws IllegalStateException {
        ArchiveEntryExtractProcessor extractor = new ArchiveEntryExtractProcessor(visitorOrNull, strategy, rootDirectory, rootPathInArchive, this.buffer);
        this.processor.process(Utils.concatLink(rootPathInArchive, path), true, true, false, extractor);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path) throws IllegalStateException {
        return this.archiveFromFilesystem(path, ArchivingStrategy.DEFAULT, false, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, ArchivingStrategy strategy) throws IllegalStateException {
        return this.archiveFromFilesystem(path, strategy, false, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, IArchiveEntryVisitor entryVisitorOrNull) throws IllegalStateException {
        return this.archiveFromFilesystem(path, ArchivingStrategy.DEFAULT, false, entryVisitorOrNull);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File path, ArchivingStrategy strategy, boolean keepNameFromPath, IArchiveEntryVisitor entryVisitorOrNull) throws IllegalStateException {
        this.checkReadWrite();
        this.updaterOrNull.archive(path, strategy, -1, keepNameFromPath, entryVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File parentDirToStrip, File path) throws IllegalStateException {
        return this.archiveFromFilesystem(parentDirToStrip, path, ArchivingStrategy.DEFAULT);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File parentDirToStrip, File path, ArchivingStrategy strategy) throws IllegalStateException {
        return this.archiveFromFilesystem(parentDirToStrip, path, strategy, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(File parentDirToStrip, File path, ArchivingStrategy strategy, IArchiveEntryVisitor entryVisitorOrNull) throws IllegalStateException {
        this.checkReadWrite();
        this.updaterOrNull.archive(parentDirToStrip, path, strategy, -1, entryVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(String rootInArchive, File path) {
        return this.archiveFromFilesystem(rootInArchive, path, ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(String rootInArchive, File path, ArchivingStrategy strategy) {
        return this.archiveFromFilesystem(rootInArchive, path, strategy, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystem(String rootInArchive, File path, ArchivingStrategy strategy, IArchiveEntryVisitor entryVisitorOrNull) {
        this.checkReadWrite();
        this.updaterOrNull.archive(rootInArchive, path, strategy, -1, entryVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFromFilesystemBelowDirectory(String rootInArchive, File directory) {
        return this.archiveFromFilesystemBelowDirectory(rootInArchive, directory, ArchivingStrategy.DEFAULT, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystemBelowDirectory(String rootInArchive, File directory, ArchivingStrategy strategy) {
        return this.archiveFromFilesystemBelowDirectory(rootInArchive, directory, strategy, null);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystemBelowDirectory(String rootInArchive, File directory, IArchiveEntryVisitor visitor) {
        return this.archiveFromFilesystemBelowDirectory(rootInArchive, directory, ArchivingStrategy.DEFAULT, visitor);
    }

    @Override
    public IHDF5Archiver archiveFromFilesystemBelowDirectory(String rootInArchive, File directory, ArchivingStrategy strategy, IArchiveEntryVisitor entryVisitorOrNull) {
        this.checkReadWrite();
        this.updaterOrNull.archiveBelow(rootInArchive, directory, strategy, -1, entryVisitorOrNull);
        return this;
    }

    @Override
    public IHDF5Archiver archiveFile(String path, byte[] data) throws IllegalStateException {
        return this.archiveFile(NewArchiveEntry.file(path), (InputStream)new ByteArrayInputStream(data));
    }

    @Override
    public IHDF5Archiver archiveFile(String path, InputStream input) {
        return this.archiveFile(NewArchiveEntry.file(path), input);
    }

    @Override
    public IHDF5Archiver archiveFile(NewArchiveEntry.NewFileArchiveEntry entry, byte[] data) {
        return this.archiveFile(entry, (InputStream)new ByteArrayInputStream(data));
    }

    @Override
    public OutputStream archiveFileAsOutputStream(NewArchiveEntry.NewFileArchiveEntry entry) {
        return new AdapterIOutputStreamToOutputStream(this.archiveFileAsIOutputStream(entry));
    }

    @Override
    public IOutputStream archiveFileAsIOutputStream(NewArchiveEntry.NewFileArchiveEntry entry) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        IOutputStream stream = this.updaterOrNull.archiveFile(entry.getParentPath(), link, entry.isCompress(), entry.getChunkSize());
        return stream;
    }

    @Override
    public IHDF5Archiver archiveFile(NewArchiveEntry.NewFileArchiveEntry entry, InputStream input) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, input, entry.isCompress(), entry.getChunkSize());
        entry.setCrc32(link.getCrc32());
        return this;
    }

    @Override
    public IHDF5Archiver archiveSymlink(String path, String linkTarget) {
        return this.archiveSymlink(NewArchiveEntry.symlink(path, linkTarget));
    }

    @Override
    public IHDF5Archiver archiveSymlink(NewArchiveEntry.NewSymLinkArchiveEntry entry) {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, null, false, -1);
        return this;
    }

    @Override
    public IHDF5Archiver archiveDirectory(String path) {
        return this.archiveDirectory(NewArchiveEntry.directory(path));
    }

    @Override
    public IHDF5Archiver archiveDirectory(NewArchiveEntry.NewDirectoryArchiveEntry entry) throws IllegalStateException, IllegalArgumentException {
        this.checkReadWrite();
        LinkRecord link = new LinkRecord(entry);
        this.updaterOrNull.archive(entry.getParentPath(), link, null, false, -1);
        return this;
    }

    @Override
    public IHDF5Archiver delete(String hdf5ObjectPath) {
        return this.delete(Collections.singletonList(hdf5ObjectPath), null);
    }

    @Override
    public IHDF5Archiver delete(List<String> hdf5ObjectPaths) {
        return this.delete(hdf5ObjectPaths, null);
    }

    @Override
    public IHDF5Archiver delete(List<String> hdf5ObjectPaths, IArchiveEntryVisitor entryVisitorOrNull) {
        this.checkReadWrite();
        this.deleterOrNull.delete(hdf5ObjectPaths, entryVisitorOrNull);
        return this;
    }

    private void checkReadWrite() {
        if (this.updaterOrNull == null) {
            throw new IllegalStateException("Cannot update archive in read-only mode.");
        }
    }
}

