/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.hdf5.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.ArchiverException;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingStrategy;
import ch.systemsx.cisd.hdf5.h5ar.HDF5Archiver;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.ListParameters;
import ch.systemsx.cisd.hdf5.h5ar.VerifyParameters;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import org.apache.commons.io.FilenameUtils;

public class HDF5ArchiverMain {
    private static final String FILE_EXTENSION_H5 = ".h5";
    private static final String FILE_EXTENSION_H5AR = ".h5ar";
    private static final IErrorStrategy ERROR_STRATEGY_CONTINUE = new IErrorStrategy(){

        public void dealWithError(Throwable th) throws ArchiverException {
            System.err.println(th.getMessage());
        }

        public void warning(String message) {
            System.err.println(message);
        }
    };
    @Argument
    private List<String> arguments;
    private Command command;
    private File archiveFile;
    private final boolean initializationOK;
    @Option(name="i", longName="include", metaVar="REGEX", skipForExample=true, usage="Regex of files to include")
    private List<String> fileWhiteList = new ArrayList<String>();
    @Option(name="e", longName="exclude", metaVar="REGEX", usage="Regex of files to exclude")
    private List<String> fileBlackList = new ArrayList<String>();
    @Option(name="I", longName="include-dirs", metaVar="REGEX", skipForExample=true, usage="Regex of directories to include")
    private List<String> dirWhiteList = new ArrayList<String>();
    @Option(name="E", longName="exclude-dirs", metaVar="REGEX", skipForExample=true, usage="Regex of directories to exclude")
    private List<String> dirBlackList = new ArrayList<String>();
    @Option(name="c", longName="compress", metaVar="REGEX", skipForExample=true, usage="Regex of files to compress")
    private List<String> compressionWhiteList = new ArrayList<String>();
    @Option(name="nc", longName="no-compression", metaVar="REGEX", skipForExample=true, usage="Regex of files not to compress")
    private List<String> compressionBlackList = new ArrayList<String>();
    @Option(name="C", longName="compress-all", usage="Compress all files")
    private Boolean compressAll = null;
    @Option(name="r", longName="root-dir", metaVar="DIR", usage="Root directory for archiving / extracting / verifying")
    private File rootOrNull;
    @Option(name="D", longName="suppress-directories", usage="Supress output for directories itself for LIST and VERIFY")
    private boolean suppressDirectoryEntries = false;
    @Option(name="R", longName="recursive", usage="Recursive LIST and VERIFY")
    private boolean recursive = false;
    @Option(name="v", longName="verbose", usage="Verbose output (all operations)")
    private boolean verbose = false;
    @Option(name="q", longName="quiet", usage="Quiet operation (only error output)")
    private boolean quiet = false;
    @Option(name="n", longName="numeric", usage="Use numeric values for mode, uid and gid for LIST and VERIFY")
    private boolean numeric = false;
    @Option(name="t", longName="test-checksums", usage="Test CRC32 checksums of files in archive for LIST")
    private boolean testAgainstChecksums = false;
    @Option(name="a", longName="verify-attributes", usage="Consider file attributes for VERIFY")
    private boolean verifyAttributes = false;
    @Option(longName="file-format", skipForExample=true, usage="Specifies the file format version when creating an archive (N=1 -> HDF51.6 (default), N=2 -> HDF51.8)")
    private int fileFormat = 1;
    @Option(longName="stop-on-error", skipForExample=true, usage="Stop on first error and give detailed error report")
    private boolean stopOnError = false;
    @Option(longName="no-sync", skipForExample=true, usage="Do not sync to disk before program exits (write mode only)")
    private boolean noSync = false;
    private HDF5Archiver archiver;
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private boolean helpPrinted = false;

    private HDF5ArchiverMain(String[] args) {
        try {
            this.parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            System.err.printf("Error when parsing command line: '%s'\n", ex.getMessage());
            this.printHelp(true);
            this.initializationOK = false;
            return;
        }
        if (this.arguments == null || this.arguments.size() < 2) {
            this.printHelp(true);
            this.initializationOK = false;
            return;
        }
        this.command = Command.parse(this.arguments.get(0));
        if (this.command == null || this.command == Command.HELP) {
            this.printHelp(true);
            this.initializationOK = false;
            return;
        }
        if (this.arguments.get(1).endsWith(FILE_EXTENSION_H5) || this.arguments.get(1).endsWith(FILE_EXTENSION_H5AR)) {
            this.archiveFile = new File(this.arguments.get(1));
        } else {
            this.archiveFile = new File(String.valueOf(this.arguments.get(1)) + FILE_EXTENSION_H5AR);
            if (this.command.isReadOnly() && !this.archiveFile.exists()) {
                this.archiveFile = new File(String.valueOf(this.arguments.get(1)) + FILE_EXTENSION_H5);
                if (this.command.isReadOnly() && !this.archiveFile.exists()) {
                    this.archiveFile = new File(this.arguments.get(1));
                }
            }
        }
        if (this.command.isReadOnly() && !this.archiveFile.exists()) {
            System.err.println("Archive '" + this.archiveFile.getAbsolutePath() + "' does not exist.");
            this.initializationOK = false;
            return;
        }
        if (this.quiet && this.verbose) {
            System.err.println("Cannot be quiet and verbose at the same time.");
            this.initializationOK = false;
            return;
        }
        this.initializationOK = true;
    }

    @Option(longName="version", skipForExample=true, usage="Prints out the version information")
    void printVersion(boolean exit) {
        System.err.println("HDF5 archiver version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion());
        if (exit) {
            System.exit(0);
        }
    }

    @Option(longName="help", skipForExample=true, usage="Shows this help text")
    void printHelp(boolean dummy) {
        if (this.helpPrinted) {
            return;
        }
        this.parser.printHelp("h5ar", "[option [...]]", "[ARCHIVE <archive_file> <item-to-archive> [...] | CAT <archive_file> <item-to-cat> [...] | EXTRACT <archive_file> [<item-to-unarchive> [...]] | DELETE <archive_file> <item-to-delete> [...] | LIST <archive_file> | VERIFY <archive_file>]", ExampleMode.NONE);
        System.err.println("ARCHIVE: add files on the file system to an archive");
        System.err.println("CAT: extract files from an archive to stdout");
        System.err.println("EXTRACT: extract files from an archive to the file system");
        System.err.println("DELETE: delete files from an archive");
        System.err.println("LIST: list files in an archive");
        System.err.println("VERIFY: verify the existence and integrity of files on the file system vs. the content of an archive");
        System.err.println("Command aliases: ARCHIVE: A, AR; CAT: C, CT; EXTRACT: E, EX; DELETE: D, REMOVE, RM; LIST: L, LS; VERIFY: V, VF");
        System.err.println("Example: h5ar" + this.parser.printExample(ExampleMode.ALL) + " ARCHIVE archive.h5ar .");
        this.helpPrinted = true;
    }

    private boolean createArchiver() {
        IHDF5WriterConfigurator.FileFormat fileFormatEnum = this.fileFormat == 1 ? IHDF5WriterConfigurator.FileFormat.STRICTLY_1_6 : IHDF5WriterConfigurator.FileFormat.STRICTLY_1_8;
        try {
            this.archiver = new HDF5Archiver(this.archiveFile, this.command.isReadOnly(), this.noSync, fileFormatEnum, this.stopOnError ? IErrorStrategy.DEFAULT_ERROR_STRATEGY : ERROR_STRATEGY_CONTINUE);
        }
        catch (HDF5JavaException ex) {
            System.err.println("Error opening archive file: " + ex.getMessage());
            return false;
        }
        catch (HDF5LibraryException ex) {
            System.err.println("Error opening archive file: corrupt file [" + ex.getClass().getSimpleName() + ": " + ex.getMessage() + "]");
            return false;
        }
        return true;
    }

    private ArchivingStrategy createArchivingStrategy() {
        ArchivingStrategy strategy = new ArchivingStrategy(this.compressionBlackList.isEmpty() ? ArchivingStrategy.DEFAULT : ArchivingStrategy.DEFAULT_NO_COMPRESSION);
        if (this.compressAll != null) {
            strategy.compressAll(this.compressAll);
        }
        for (String pattern : this.fileWhiteList) {
            strategy.addToFileWhiteList(pattern);
        }
        for (String pattern : this.fileBlackList) {
            strategy.addToFileBlackList(pattern);
        }
        for (String pattern : this.dirWhiteList) {
            strategy.addToDirWhiteList(pattern);
        }
        for (String pattern : this.dirBlackList) {
            strategy.addToDirBlackList(pattern);
        }
        for (String pattern : this.fileWhiteList) {
            strategy.addToFileWhiteList(pattern);
        }
        for (String pattern : this.compressionWhiteList) {
            strategy.addToCompressionWhiteList(pattern);
        }
        for (String pattern : this.compressionBlackList) {
            strategy.addToCompressionBlackList(pattern);
        }
        return strategy;
    }

    private File getFSRoot() {
        return this.rootOrNull == null ? new File(".") : this.rootOrNull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean run() {
        if (!this.initializationOK) {
            return false;
        }
        try {
            switch (this.command) {
                case ARCHIVE: {
                    if (this.arguments.size() == 2) {
                        System.err.println("Nothing to archive.");
                        return true;
                    }
                    if (!this.createArchiver()) {
                        return true;
                    }
                    ArchivingStrategy strategy = this.createArchivingStrategy();
                    if (this.verbose) {
                        System.out.printf("Archiving to file '%s', file system root: '%s'\n", this.archiveFile, this.getFSRoot());
                    }
                    if (this.rootOrNull != null) {
                        int i = 2;
                        while (i < this.arguments.size()) {
                            if (this.verbose) {
                                System.out.printf("  Adding entry: '%s'\n", this.arguments.get(i));
                            }
                            this.archiver.archiveFromFilesystem(this.rootOrNull, new File(this.rootOrNull, this.arguments.get(i)), strategy, this.verbose ? IArchiveEntryVisitor.NONVERBOSE_VISITOR : null);
                            ++i;
                        }
                        return true;
                    } else {
                        int i = 2;
                        while (i < this.arguments.size()) {
                            if (this.verbose) {
                                System.out.printf("  Adding entry: '%s'\n", this.arguments.get(i));
                            }
                            this.archiver.archiveFromFilesystem(new File(this.arguments.get(i)), strategy, true, this.verbose ? IArchiveEntryVisitor.NONVERBOSE_VISITOR : null);
                            ++i;
                        }
                    }
                    return true;
                }
                case CAT: {
                    if (!this.createArchiver()) {
                        return true;
                    }
                    if (this.arguments.size() == 2) {
                        System.err.println("Nothing to cat.");
                        return true;
                    }
                    int i = 2;
                    while (i < this.arguments.size()) {
                        this.archiver.extractFile(this.arguments.get(i), new FileOutputStream(FileDescriptor.out));
                        ++i;
                    }
                    return true;
                }
                case EXTRACT: {
                    if (!this.createArchiver()) {
                        return true;
                    }
                    ArchivingStrategy strategy = this.createArchivingStrategy();
                    if (this.verbose) {
                        System.out.printf("Extracting from file '%s', file system root: '%s'\n", this.archiveFile, this.getFSRoot());
                    }
                    if (this.arguments.size() == 2) {
                        if (this.verbose) {
                            System.out.println("  Extracting entry: '/'");
                        }
                        this.archiver.extractToFilesystem(this.getFSRoot(), "/", strategy, (IArchiveEntryVisitor)(this.verbose ? IArchiveEntryVisitor.DEFAULT_VISITOR : (this.quiet ? null : IArchiveEntryVisitor.NONVERBOSE_VISITOR)));
                        return true;
                    }
                    int i = 2;
                    while (i < this.arguments.size()) {
                        if (this.verbose) {
                            System.out.printf("  Extracting entry: '%s'\n", this.arguments.get(i));
                        }
                        String unixPath = FilenameUtils.separatorsToUnix((String)this.arguments.get(i));
                        this.archiver.extractToFilesystem(this.getFSRoot(), unixPath, strategy, (IArchiveEntryVisitor)(this.verbose ? IArchiveEntryVisitor.DEFAULT_VISITOR : (this.quiet ? null : IArchiveEntryVisitor.NONVERBOSE_VISITOR)));
                        ++i;
                    }
                    return true;
                }
                case DELETE: {
                    if (this.arguments.size() == 2) {
                        System.err.println("Nothing to delete.");
                        return true;
                    }
                    if (!this.createArchiver()) {
                        return true;
                    }
                    if (this.verbose) {
                        System.out.printf("Deleting from file '%s'\n", this.archiveFile);
                        for (String entry : this.arguments.subList(2, this.arguments.size())) {
                            System.out.printf("  Deleting entry: '%s'\n", entry);
                        }
                    }
                    this.archiver.delete(this.arguments.subList(2, this.arguments.size()), this.verbose ? IArchiveEntryVisitor.NONVERBOSE_VISITOR : null);
                    return true;
                }
                case VERIFY: {
                    if (!this.createArchiver()) {
                        return true;
                    }
                    if (this.verbose) {
                        System.out.printf("Verifying file '%s', file system root: '%s'\n", this.archiveFile, this.getFSRoot());
                    }
                    String fileOrDir = this.arguments.size() > 2 ? this.arguments.get(2) : "/";
                    ListingVisitor visitor = new ListingVisitor(true, this.quiet, this.verbose, this.numeric);
                    this.archiver.verifyAgainstFilesystem(fileOrDir, this.getFSRoot(), visitor, VerifyParameters.build().recursive(this.recursive).numeric(this.numeric).verifyAttributes(this.verifyAttributes).get());
                    boolean bl = visitor.isOK();
                    return bl;
                }
                case LIST: {
                    if (!this.createArchiver()) {
                        return true;
                    }
                    if (this.verbose) {
                        System.out.printf("Listing file '%s'\n", this.archiveFile);
                    }
                    String fileOrDir = this.arguments.size() > 2 ? this.arguments.get(2) : "/";
                    ListingVisitor visitor = new ListingVisitor(this.testAgainstChecksums, this.quiet, this.verbose, this.numeric, this.suppressDirectoryEntries);
                    this.archiver.list(fileOrDir, visitor, ListParameters.build().recursive(this.recursive).readLinkTargets(this.verbose).testArchive(this.testAgainstChecksums).get());
                    boolean bl = visitor.isOK();
                    return bl;
                }
            }
            return true;
        }
        finally {
            if (this.archiver != null) {
                this.archiver.close();
            }
        }
    }

    public static void main(String[] args) {
        HDF5ArchiverMain main = new HDF5ArchiverMain(args);
        if (!main.run()) {
            System.exit(1);
        }
    }

    private static enum Command {
        ARCHIVE(new String[]{"A", "AR", "ARCHIVE"}, false),
        CAT(new String[]{"C", "CT", "CAT"}, true),
        EXTRACT(new String[]{"E", "EX", "EXTRACT"}, true),
        DELETE(new String[]{"D", "RM", "DELETE", "REMOVE"}, false),
        LIST(new String[]{"L", "LS", "LIST"}, true),
        VERIFY(new String[]{"V", "VF", "VERIFY"}, true),
        HELP(new String[]{"H", "HELP"}, true);

        String[] forms;
        boolean readOnly;

        private Command(String[] forms, boolean readOnly) {
            this.forms = forms;
            this.readOnly = readOnly;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        static Command parse(String commandStr) {
            String commandStrU = commandStr.toUpperCase();
            Command[] commandArray = Command.values();
            int n = commandArray.length;
            int n2 = 0;
            while (n2 < n) {
                Command cmd = commandArray[n2];
                String[] stringArray = cmd.forms;
                int n3 = cmd.forms.length;
                int n4 = 0;
                while (n4 < n3) {
                    String frm = stringArray[n4];
                    if (frm.equals(commandStrU)) {
                        return cmd;
                    }
                    ++n4;
                }
                ++n2;
            }
            return HELP;
        }
    }

    private static class ListingVisitor
    implements IArchiveEntryVisitor {
        private final boolean verifying;
        private final boolean quiet;
        private final boolean verbose;
        private final boolean numeric;
        private final boolean suppressDirectoryEntries;
        private int checkSumFailures;

        ListingVisitor(boolean verifying, boolean quiet, boolean verbose, boolean numeric) {
            this(verifying, quiet, verbose, numeric, false);
        }

        ListingVisitor(boolean verifying, boolean quiet, boolean verbose, boolean numeric, boolean suppressDirectoryEntries) {
            this.verifying = verifying;
            this.quiet = quiet;
            this.verbose = verbose;
            this.numeric = numeric;
            this.suppressDirectoryEntries = suppressDirectoryEntries;
        }

        @Override
        public void visit(ArchiveEntry entry) {
            if (this.suppressDirectoryEntries && entry.isDirectory()) {
                return;
            }
            if (this.verifying) {
                boolean ok = entry.isOK();
                if (!this.quiet) {
                    System.out.println(entry.describeLink(this.verbose, this.numeric, true));
                }
                if (!ok) {
                    System.err.println(entry.getStatus(true));
                    ++this.checkSumFailures;
                }
            } else if (!this.quiet) {
                System.out.println(entry.describeLink(this.verbose, this.numeric, false));
            }
        }

        boolean isOK() {
            if (this.verifying && this.checkSumFailures > 0) {
                System.err.println(String.valueOf(this.checkSumFailures) + " file(s) failed the test.");
                return false;
            }
            return true;
        }
    }
}

