/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WebAppProperties {
    private Properties properties;

    public WebAppProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        this.properties = properties;
    }

    public String getLabel() {
        return this.getPropertyStringValue(WebAppProperty.LABEL);
    }

    public Integer getSorting() {
        return this.getPropertyIntegerValue(WebAppProperty.SORTING);
    }

    public String[] getContexts() {
        return this.getPropertyStringValues(WebAppProperty.CONTEXTS);
    }

    public Map<EntityKind, String[]> getEntityTypes() {
        HashMap<EntityKind, String[]> entityTypes = new HashMap<EntityKind, String[]>();
        entityTypes.put(EntityKind.EXPERIMENT, this.getPropertyStringValues(WebAppProperty.EXPERIMENT_TYPES));
        entityTypes.put(EntityKind.SAMPLE, this.getPropertyStringValues(WebAppProperty.SAMPLE_TYPES));
        entityTypes.put(EntityKind.DATA_SET, this.getPropertyStringValues(WebAppProperty.DATA_SET_TYPES));
        entityTypes.put(EntityKind.MATERIAL, this.getPropertyStringValues(WebAppProperty.MATERIAL_TYPES));
        return entityTypes;
    }

    private String getPropertyStringValue(WebAppProperty property) {
        String value = this.properties.getProperty(property.getName());
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value.trim();
    }

    private Integer getPropertyIntegerValue(WebAppProperty property) {
        String value = this.getPropertyStringValue(property);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationFailureException("Illegal value of " + property.getName() + " web application property. Value: " + value + " is not a number.");
        }
    }

    private String[] getPropertyStringValues(WebAppProperty property) {
        String value = this.getPropertyStringValue(property);
        if (value == null) {
            return new String[0];
        }
        return PropertyParametersUtil.parseItemisedProperty(value, property.getName());
    }
}

