/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.DataSetCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDataSetCache<T>
implements DataSetCache<T> {
    private static final int DEFAULT_SIZE = 10;
    private ReferenceQueue<T> queue = new ReferenceQueue();
    private WeakReference<?>[] cache = new WeakReference[10];

    private void ensureCapacity(int n) {
        int n2 = this.cache.length;
        if (n2 < n) {
            WeakReference[] weakReferenceArray = new WeakReference[Math.max(n2 * 3 / 2 + 1, n)];
            System.arraycopy(this.cache, 0, weakReferenceArray, 0, n2);
            this.cache = weakReferenceArray;
        }
    }

    private void removeOldEntries() {
        IndexedWeakReference indexedWeakReference = null;
        while ((indexedWeakReference = (IndexedWeakReference)this.queue.poll()) != null) {
            this.cache[indexedWeakReference.getIndex()] = null;
        }
    }

    @Override
    public void init(DataSet<T> dataSet) {
    }

    @Override
    public boolean isCached(int n) {
        return n < this.cache.length && this.cache[n] != null && this.cache[n].get() != null;
    }

    @Override
    public T getObject(int n) {
        this.removeOldEntries();
        if (this.isCached(n)) {
            Object t = this.cache[n].get();
            return t;
        }
        return null;
    }

    @Override
    public void setObject(int n, T t) {
        this.removeOldEntries();
        this.ensureCapacity(n + 1);
        this.cache[n] = new IndexedWeakReference(n, t, this.queue);
    }

    @Override
    public void destroy() {
        this.cache = null;
        this.queue = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexedWeakReference<T>
    extends WeakReference<T> {
        private final int index;

        IndexedWeakReference(int n, T t, ReferenceQueue<T> referenceQueue) {
            super(t, referenceQueue);
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

