/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.IdentityHashMap;
import java.util.Map;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.impl.AbstractMethodImplementation;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.ResultSetResource;
import net.lemnik.eodsql.spi.util.NoDataObjectBinding;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectMethodImplementation
extends AbstractMethodImplementation<Select> {
    private final Integer fetchSize;

    SelectMethodImplementation(Method method) throws ParseException {
        this(method.getAnnotation(Select.class), method.getParameterTypes(), method.getGenericReturnType());
    }

    SelectMethodImplementation(Select select, Class[] classArray, Type type) throws ParseException {
        String string = select.value();
        if (string.length() == 0) {
            string = select.sql();
        }
        this.query = Query.getQuery(string, classArray);
        this.setParameterMappers(select.parameterBindings());
        Map<String, Object> map = SelectMethodImplementation.extractReturnTypeMapperParameters(select);
        this.wrapper = ResultSetWrapper.get(type, map);
        this.fetchSize = type instanceof Class && !((Class)type).isArray() ? Integer.valueOf(1) : (select.fetchSize() != 0 ? Integer.valueOf(select.fetchSize()) : null);
    }

    private static Map<String, Object> extractReturnTypeMapperParameters(Select select) {
        IdentityHashMap<String, Object> identityHashMap = new IdentityHashMap<String, Object>();
        if (select.disconnected()) {
            identityHashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#disconnected", Boolean.TRUE);
        } else {
            identityHashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#disconnected", Boolean.FALSE);
        }
        if (select.readOnly()) {
            identityHashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#updatable", Boolean.FALSE);
        } else {
            identityHashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#updatable", Boolean.TRUE);
        }
        if (select.rubberstamp()) {
            identityHashMap.put("net.elmnik.eodsql.spi.util.DataIteratorWrapper#rubberstamp", Boolean.TRUE);
        } else {
            identityHashMap.put("net.elmnik.eodsql.spi.util.DataIteratorWrapper#rubberstamp", Boolean.FALSE);
        }
        if (select.resultSetBinding() != NoDataObjectBinding.class) {
            try {
                identityHashMap.put("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding", select.resultSetBinding().newInstance());
            }
            catch (Exception exception) {
                throw new InvalidQueryException("DataObjectBinding classes must have a default (null) constructor: " + select.resultSetBinding().getCanonicalName(), exception);
            }
        }
        identityHashMap.put("net.lemnik.eodsql.spi.util.DataSetWrapper#cacheClass", select.cache());
        return identityHashMap;
    }

    @Override
    public void invoke(Context<Select> context) throws Throwable {
        PreparedStatement preparedStatement = this.createPreparedStatement(context);
        if (this.fetchSize != null) {
            preparedStatement.setFetchSize(this.fetchSize);
        }
        this.fillPreparedStatementParameters(context, preparedStatement);
        ResultSet resultSet = preparedStatement.executeQuery();
        context.setResource(new ResultSetResource(resultSet));
        context.setReturnValue(this.wrapper.wrap(context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Factory
    implements MethodImplementationFactory<Select> {
        Factory() {
        }

        @Override
        public void validate(Method method) throws InvalidQueryException {
            Select select = method.getAnnotation(Select.class);
            String string = select.value();
            if (string.length() == 0) {
                string = select.sql();
            }
            if (string.length() == 0) {
                throw new InvalidQueryException("No EoD SQL Query in Select annotation", method);
            }
            Query.validate(string, method);
            if (select.disconnected() && !select.readOnly()) {
                throw new InvalidQueryException("A disconnected Select may not be writable.", method);
            }
            if (select.rubberstamp() && method.getReturnType() != DataIterator.class) {
                throw new InvalidQueryException("A rubberstamping Select must return a DataIterator", method);
            }
            ResultSetWrapper.validate(method.getGenericReturnType());
        }

        @Override
        public MethodImplementation<Select> createImplementation(Method method) {
            try {
                return new SelectMethodImplementation(method);
            }
            catch (ParseException parseException) {
                throw new EoDException(parseException);
            }
        }
    }
}

