/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import net.lemnik.eodsql.GeneratedKeys;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.Update;
import net.lemnik.eodsql.impl.AbstractMethodImplementation;
import net.lemnik.eodsql.impl.BatchUpdateMethodImplementation;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.ResultSetResource;
import net.lemnik.eodsql.spi.StatementResource;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateMethodImplementation
extends AbstractMethodImplementation<Update> {
    private GeneratedKeys keys;

    UpdateMethodImplementation(Method method) throws ParseException {
        this.init(method.getAnnotation(Update.class), this.getParameterTypes(method), method.getGenericReturnType());
    }

    UpdateMethodImplementation(Update update, Class[] classArray, Type type) throws ParseException {
        this.init(update, classArray, type);
    }

    private void init(Update update, Class[] classArray, Type type) throws ParseException {
        String string = update.value();
        if (string.length() == 0) {
            string = update.sql();
        }
        this.keys = update.keys();
        this.query = Query.getQuery(string, classArray);
        this.setParameterMappers(update.parameterBindings());
        Map<String, Object> map = this.extractReturnTypeMapperParameters(update);
        if (this.keys != GeneratedKeys.NO_KEYS_RETURNED) {
            this.wrapper = ResultSetWrapper.get(type, map);
        }
    }

    protected Class<?>[] getParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    private Map<String, Object> extractReturnTypeMapperParameters(Update update) {
        DataObjectBinding.BindingType bindingType = DataObjectBinding.BindingType.KEYS_BINDING;
        if (update.keys() == GeneratedKeys.RETURNED_KEYS_FIRST_COLUMN) {
            bindingType = DataObjectBinding.BindingType.FIRST_COLUMN_BINDING;
        }
        return Collections.singletonMap("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType", bindingType);
    }

    @Override
    public void invoke(Context<Update> context) throws Throwable {
        Connection connection = context.getResource(Connection.class).get();
        PreparedStatement preparedStatement = null;
        switch (this.keys) {
            case RETURNED_KEYS_COLUMNS_SPECIFIED: {
                preparedStatement = connection.prepareStatement(this.query.toString(), this.wrapper.getKeyColumnNames());
                break;
            }
            case RETURNED_KEYS_DRIVER_DEFINED: 
            case RETURNED_KEYS_FIRST_COLUMN: {
                preparedStatement = connection.prepareStatement(this.query.toString(), 1);
                break;
            }
            default: {
                preparedStatement = connection.prepareStatement(this.query.toString());
            }
        }
        context.setResource(new StatementResource(preparedStatement));
        this.update(preparedStatement, context);
        if (this.keys != GeneratedKeys.NO_KEYS_RETURNED) {
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            context.setResource(new ResultSetResource(resultSet));
            context.setReturnValue(this.wrapper.wrap(context));
        } else {
            context.setReturnValue(preparedStatement.getUpdateCount());
        }
    }

    protected void update(PreparedStatement preparedStatement, Context<Update> context) throws SQLException {
        this.fillPreparedStatementParameters(context, preparedStatement);
        preparedStatement.executeUpdate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Factory
    implements MethodImplementationFactory<Update> {
        Factory() {
        }

        @Override
        public void validate(Method method) throws InvalidQueryException {
            Update update = method.getAnnotation(Update.class);
            String string = update.value();
            if (string.length() == 0) {
                string = update.sql();
            }
            if (string.length() == 0) {
                throw new InvalidQueryException("No EoD SQL Query in Select annotation", method);
            }
            if (update.keys() == GeneratedKeys.NO_KEYS_RETURNED && (method.getReturnType() != Void.TYPE || method.getReturnType() == Integer.TYPE || method.getReturnType() == Integer.class)) {
                throw new InvalidQueryException("An Update method returning GeneratedKeys.NO_KEYS_RETURNED must have a return type of void or int.", method);
            }
            if (update.batchUpdate()) {
                BatchUpdateMethodImplementation.createParameterViewFactories(method.getParameterTypes());
            }
            Query.validate(string, method);
        }

        @Override
        public MethodImplementation<Update> createImplementation(Method method) {
            try {
                Update update = method.getAnnotation(Update.class);
                if (update.batchUpdate()) {
                    return new BatchUpdateMethodImplementation(method);
                }
                return new UpdateMethodImplementation(method);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }
}

