/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.DataObjectBindingCache;
import net.lemnik.eodsql.spi.util.MethodParameterTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query {
    private static final MethodParameterTool[] EMPTY_PARAMETERS = new MethodParameterTool[0];
    private final String sql;
    private MethodParameterTool[] parameters = EMPTY_PARAMETERS;
    private static final QueryCache CACHE = new QueryCache();

    public Query(String eodsql, Class<?> ... parameterTypes) throws ParseException {
        this.sql = this.parseQueryString(eodsql, parameterTypes);
    }

    public Object getParameter(Context context, int index) {
        return this.parameters[index].getParameter(context.getParameters());
    }

    public Iterator<Object> getParameterIterator(Context context) {
        return new ParameterIterator(context);
    }

    public Class<?> getParameterType(int index) {
        return this.parameters[index].getParameterType();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public String toString() {
        return this.sql;
    }

    public static void validate(String query, Method method) {
        int index = 0;
        while (index < query.length()) {
            char ch = query.charAt(index);
            if (ch == '?') {
                if (Character.isDigit(ch = Query.getCharacter(query, index++, method))) {
                    index = Query.validateSimpleQueryParameter(query, index, method);
                    continue;
                }
                index = Query.validateComplexQueryParameter(query, index, method);
                continue;
            }
            ++index;
        }
    }

    private static int validateSimpleQueryParameter(String query, int startIndex, Method method) {
        char ch;
        int index;
        StringBuilder builder = new StringBuilder();
        for (index = startIndex; index < query.length() && Character.isDigit(ch = query.charAt(index)); ++index) {
            builder.append(ch);
        }
        int paramIndex = Integer.parseInt(builder.toString()) - 1;
        Query.validateQueryParameter(paramIndex, method);
        return index;
    }

    private static int validateComplexQueryParameter(String query, int index, Method method) {
        String[] parts;
        int end = query.indexOf(125, index + 1);
        if (end == -1) {
            throw new InvalidQueryException("Unclosed complex parameter at " + index, method);
        }
        String param = query.substring(index + 1, end).trim();
        for (String p : parts = param.split("\\.")) {
            for (int i = 0; i < p.length(); ++i) {
                if (!Character.isWhitespace(p.charAt(i))) continue;
                throw new InvalidQueryException("Not a valid atom " + p, method);
            }
        }
        return end + 1;
    }

    private static void validateQueryParameter(int paramIndex, Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (paramIndex < 0 || paramIndex >= types.length) {
            throw new InvalidQueryException("Invalid parameter index for method " + paramIndex + 1, method);
        }
        if (!QueryTool.getTypeMap().containsKey(types[paramIndex])) {
            throw new InvalidQueryException(types[paramIndex].getName() + " is not a known primitive type and cannot be " + "specified as a query parameter.", method);
        }
    }

    private static char getCharacter(String string, int index, Method method) {
        if (index < string.length()) {
            return string.charAt(index);
        }
        throw new InvalidQueryException("Expected a character, but hit the end of the string: '" + string + "'.", method);
    }

    private String parseQueryString(String sql, Class[] parameterTypes) throws ParseException {
        StringBuilder query = new StringBuilder();
        QueryReader reader = new QueryReader(sql);
        ArrayList<MethodParameterTool> list = new ArrayList<MethodParameterTool>(0);
        try {
            int ch = 0;
            block5: while ((ch = reader.read()) != -1) {
                switch (ch) {
                    case 63: {
                        query.append('?');
                        list.add(this.createParameterHandler(reader, parameterTypes));
                        continue block5;
                    }
                }
                query.append((char)ch);
            }
        }
        catch (NullPointerException ex) {
            throw new ParseException("cannot parse query string!", reader.getIndex());
        }
        if (!list.isEmpty()) {
            this.parameters = list.toArray(new MethodParameterTool[list.size()]);
        }
        return query.toString();
    }

    private MethodParameterTool createParameterHandler(QueryReader reader, Class[] parameterTypes) throws ParseException {
        MethodParameterTool handler;
        block10: {
            String[] parts;
            block9: {
                int ch = reader.read();
                if (ch == -1) {
                    throw new ParseException("trailing ? character in query string", reader.getIndex());
                }
                if (Character.isDigit(ch)) {
                    return this.createSimpleParameterHandler(reader, parameterTypes, ch);
                }
                if (ch != 123 && !reader.skipUntil('{')) {
                    throw new ParseException("cannot find complex query opening (for ?{param} syntax)", reader.getIndex());
                }
                String param = reader.readUntil('}').trim();
                parts = param.split("\\.");
                handler = null;
                if (!Character.isDigit(parts[0].charAt(0))) break block9;
                int paramIndex = Integer.parseInt(parts[0]) - 1;
                Class type = parameterTypes[paramIndex];
                if (parts.length == 1) {
                    handler = new MethodParameterTool.Parameter(paramIndex, type);
                } else if (parts.length == 2) {
                    handler = this.getParameterHandler(paramIndex, parts[1], type);
                } else {
                    handler = this.getParameterHandler(paramIndex, parts[1], type);
                    for (int i = 2; i < parts.length; ++i) {
                        MethodParameterTool next = this.getParameterHandler(0, parts[i], handler.getParameterType());
                        handler = new MethodParameterTool.Chained(handler, next);
                    }
                }
                break block10;
            }
            Class type = parameterTypes[0];
            handler = this.getParameterHandler(0, parts[0], type);
            if (parts.length <= 1) break block10;
            for (int i = 1; i < parts.length; ++i) {
                MethodParameterTool next = this.getParameterHandler(0, parts[i], handler.getParameterType());
                handler = new MethodParameterTool.Chained(handler, next);
            }
        }
        return handler;
    }

    private MethodParameterTool getParameterHandler(int parameterIndex, String name, Class sourceType) {
        try {
            Field field = sourceType.getField(name);
            if ((Modifier.isPublic(field.getModifiers()) || DataObjectBindingCache.HAVE_ACCESSIBLE_PERMISSION) && !Modifier.isStatic(field.getModifiers())) {
                return new MethodParameterTool.Field(parameterIndex, field);
            }
        }
        catch (SecurityException ex) {
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
        Method readMethod = this.findReadMethod(name, sourceType);
        if (readMethod != null) {
            return new MethodParameterTool.Method(parameterIndex, readMethod);
        }
        throw new IllegalArgumentException("Cannot find field / property " + sourceType.getName() + "." + name);
    }

    private Method findReadMethod(String name, Class type) {
        try {
            PropertyDescriptor[] desc;
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor tmp : desc = info.getPropertyDescriptors()) {
                if (!tmp.getName().equals(name)) continue;
                return tmp.getReadMethod();
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return null;
    }

    private MethodParameterTool createSimpleParameterHandler(QueryReader reader, Class[] parameterTypes, int ch1) throws ParseException {
        int index;
        int startIndex = reader.getIndex();
        StringBuilder sb = new StringBuilder(2);
        sb.append((char)ch1);
        int ch = -1;
        boolean done = false;
        do {
            if (Character.isDigit(ch = reader.read())) {
                sb.append((char)ch);
                continue;
            }
            done = true;
        } while (!done);
        if (ch != -1) {
            reader.skip(-1);
        }
        if ((index = Integer.parseInt(sb.toString()) - 1) < 0 || index >= parameterTypes.length) {
            throw new ParseException("parameter index out of bounds: " + (index + 1), startIndex);
        }
        return new MethodParameterTool.Parameter(index, parameterTypes[index]);
    }

    public static Query getQuery(String eodsql, Class<?> ... parameterTypes) throws ParseException {
        return CACHE.getQuery(eodsql, parameterTypes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterIterator
    implements Iterator<Object> {
        private final Object[] inputParameters;
        private int index = 0;

        private ParameterIterator(Context context) {
            this.inputParameters = context.getParameters();
        }

        @Override
        public boolean hasNext() {
            return this.index < Query.this.parameters.length;
        }

        @Override
        public Object next() {
            return Query.this.parameters[this.index++].getParameter(this.inputParameters);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class QueryReader {
        private final String source;
        private int index;
        private int length;
        private int mark = 0;

        public QueryReader(String source) {
            this.source = source;
            this.length = source.length();
            this.index = 0;
        }

        public boolean skipUntil(char c) {
            int ch;
            do {
                this.mark();
                ch = this.read();
                if (ch != -1) continue;
                this.reset();
                return false;
            } while (ch != c);
            return true;
        }

        public String readUntil(char c) {
            StringBuilder builder = new StringBuilder();
            int ch;
            while ((ch = this.read()) != -1) {
                if (ch == c) {
                    return builder.toString();
                }
                builder.append((char)ch);
            }
            return null;
        }

        public int read() {
            if (this.index < this.length) {
                return this.source.charAt(this.index++);
            }
            return -1;
        }

        public long skip(int n) {
            this.index += n;
            if (this.index < 0) {
                this.index = 0;
            } else if (this.index > this.length) {
                this.index = this.length;
            }
            return n;
        }

        public void mark() {
            this.mark = this.index;
        }

        public void reset() {
            this.index = this.mark;
        }

        public int getIndex() {
            return this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryCache {
        private final ConcurrentMap<QueryKey, CachedQuery> cache;
        private final ReferenceQueue<Query> referenceQueue = new ReferenceQueue();

        public QueryCache() {
            this.cache = new ConcurrentHashMap<QueryKey, CachedQuery>();
        }

        private void purgeStaleQueries() {
            CachedQuery query = null;
            while ((query = (CachedQuery)this.referenceQueue.poll()) != null) {
                this.cache.remove(query.getQueryKey(), query);
            }
        }

        public Query getQuery(String sql, Class<?>[] paramTypes) throws ParseException {
            Query query;
            this.purgeStaleQueries();
            QueryKey key = new QueryKey(sql, paramTypes);
            CachedQuery cachedQuery = (CachedQuery)this.cache.get(key);
            Query query2 = query = cachedQuery != null ? (Query)cachedQuery.get() : null;
            if (query == null) {
                CachedQuery newCachedQuery;
                if (cachedQuery != null) {
                    this.cache.remove(key, cachedQuery);
                }
                if (this.cache.putIfAbsent(key, newCachedQuery = new CachedQuery(key, query = new Query(sql, paramTypes), this.referenceQueue)) != null) {
                    return this.getQuery(sql, paramTypes);
                }
            }
            return query;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedQuery
    extends SoftReference<Query> {
        private final QueryKey key;

        public CachedQuery(QueryKey key, Query query, ReferenceQueue<Query> queue) {
            super(query, queue);
            this.key = key;
        }

        public QueryKey getQueryKey() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryKey {
        private final String sql;
        private final Class<?>[] parameterTypes;

        public QueryKey(String sql, Class<?>[] parameterTypes) {
            this.sql = sql;
            this.parameterTypes = parameterTypes;
        }

        public int hashCode() {
            return this.sql.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueryKey) {
                QueryKey other = (QueryKey)obj;
                return this.sql.equals(other.sql) && Arrays.equals(this.parameterTypes, other.parameterTypes);
            }
            return false;
        }
    }
}

