/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.ImageReadersTestHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ImageReaderFactoryTest
extends ImageReaderTestCase {
    private static final FileFilter IGNORE_SVN = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().equalsIgnoreCase(".svn");
        }
    };

    @DataProvider(name="libraries")
    public Object[][] librariesToTest() {
        return new Object[][]{{"ImageIO".toLowerCase()}, {"JAI".toLowerCase()}, {"IJ".toLowerCase()}, {"BioFormats".toLowerCase()}};
    }

    @Test(dataProvider="libraries")
    public void testLibrary(String library) throws Exception {
        File file;
        ImageReadersTestHelper.setUpLibrariesFromManifest(library);
        File[] fileArray = this.listValidImages(library);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            this.assertImageReadable(library, file);
            ++n2;
        }
        fileArray = this.listInvalidImages(library);
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            this.assertNoReaderFor(library, file);
            ++n2;
        }
    }

    @Test
    public void testFindWithoutLibraryName() throws Exception {
        String tiffFileName = "./demo.tiff";
        ImageReadersTestHelper.setUpLibraries("ImageIO");
        ImageReaderFactoryTest.assertNull((String)"ImageIO library should not return TIFF readers", (Object)ImageReaderFactory.tryGetReaderForFile(tiffFileName));
        ImageReadersTestHelper.setUpLibraries("JAI");
        ImageReaderFactoryTest.assertNotNull((String)"JAI library should return TIFF readers", (Object)ImageReaderFactory.tryGetReaderForFile(tiffFileName));
    }

    public void testGetReaderFromInvalidLibrary() {
        IImageReader reader = ImageReaderFactory.tryGetReaderForFile("invalid_library", null);
        ImageReaderFactoryTest.assertNull((Object)reader);
    }

    @Test(expectedExceptions={IOExceptionUnchecked.class})
    public void testReadNonExistingFile() throws Exception {
        File invalidFile = new File("invalid_file_path.tif");
        ImageReadersTestHelper.setUpLibraries("BioFormats");
        IImageReader reader = ImageReaderFactory.tryGetReaderForFile("BioFormats", "invalid_file_path.tif");
        ImageReaderFactoryTest.assertNotNull((Object)reader);
        reader.readImage(invalidFile, ImageID.NULL, null);
    }

    private File[] listValidImages(String library) {
        return this.getValidImagesDir(library).listFiles(IGNORE_SVN);
    }

    private File[] listInvalidImages(String library) {
        return this.getInvalidImagesDir(library).listFiles(IGNORE_SVN);
    }

    private void assertImageReadable(String libraryName, File file) {
        IImageReader reader = ImageReaderFactory.tryGetReaderForFile(libraryName, file.getAbsolutePath());
        String error = String.format("Cannot find appropriate reader for file '%s' in library '%s'", file.getAbsolutePath(), libraryName);
        ImageReaderFactoryTest.assertNotNull((String)error, (Object)reader);
        ImageReaderFactoryTest.assertNotNull((String)"Reader should not have NULL name", (Object)reader.getName());
        ImageReaderFactoryTest.assertEquals((String)libraryName.toLowerCase(), (String)reader.getLibraryName().toLowerCase());
        BufferedImage image = reader.readImage(file, ImageID.NULL, null);
        ImageReaderFactoryTest.assertNotNull((String)"Read image should not be null", (Object)image);
        ImageReaderFactoryTest.assertTrue((String)"Image should have non-negative height", (image.getHeight() > 0 ? 1 : 0) != 0);
        ImageReaderFactoryTest.assertTrue((String)"Image should have non-negative width", (image.getWidth() > 0 ? 1 : 0) != 0);
    }

    private void assertNoReaderFor(String library, File file) {
        IImageReader reader = ImageReaderFactory.tryGetReaderForFile(library, file.getAbsolutePath());
        String error = String.format("Library file '%s'  cannot read file '%s', but returns a non-null image reader.", library, file.getAbsolutePath());
        ImageReaderFactoryTest.assertNull((String)error, (Object)reader);
    }
}

