/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.connectors;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DataSetCodeAndWellPositions;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import ch.systemsx.sybit.imageviewer.connectors.DataConnector;
import ch.systemsx.sybit.imageviewer.data.ImageHandler;
import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.data.MinMaxInChannel;
import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.transformers.IJImageTransformerFactory;
import ij.ImagePlus;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class OpenBISConnector
implements DataConnector {
    private IImageTransformerFactory factory;
    private String channel;
    private Map<String, DataSetCodeAndWellPositions> dataSets;
    private IScreeningOpenbisServiceFacade facade;
    private List<IDatasetIdentifier> dsIdentifiers;
    private ImageViewer imageViewer;
    private Thread[] loadingThreads;

    public OpenBISConnector(String[] args, ImageViewer imageViewer) throws Throwable {
        this.imageViewer = imageViewer;
        String serviceURL = args[0];
        String sessionToken = args[1];
        this.channel = args[3];
        this.dataSets = new HashMap<String, DataSetCodeAndWellPositions>();
        for (int i = 4; i < args.length; ++i) {
            DataSetCodeAndWellPositions dw = new DataSetCodeAndWellPositions(args[i]);
            this.dataSets.put(dw.getDataSetCode(), dw);
        }
        this.facade = ScreeningOpenbisServiceFacadeFactory.tryCreate(sessionToken, serviceURL);
        this.dsIdentifiers = this.facade.getDatasetIdentifiers(new ArrayList<String>(this.dataSets.keySet()));
        this.factory = this.facade.getImageTransformerFactoryOrNull(this.dsIdentifiers, this.channel);
    }

    public ImageViewerParameters getParameters() throws Throwable {
        ImageViewerParameters parameters = null;
        if (this.factory == null) {
            parameters = new ImageViewerParameters();
            parameters.setLutOperation("");
            parameters.setMin(0.0);
            parameters.setMax(255.0);
            parameters.setMinMaxInChannels(new HashMap<Integer, MinMaxInChannel>());
            parameters.setSlice(1);
        } else {
            parameters = ((IJImageTransformerFactory)this.factory).getParameters();
        }
        return parameters;
    }

    public void save(ImageViewerParameters imageViewerParameters) throws Throwable {
        if (imageViewerParameters.getLutOperation().equals("") && imageViewerParameters.getMin() == 0.0 && imageViewerParameters.getMax() == 255.0 && imageViewerParameters.getMinMaxInChannels().size() == 0) {
            this.factory = null;
        } else if (this.factory == null) {
            this.factory = new IJImageTransformerFactory(imageViewerParameters);
        } else if (this.factory != null) {
            ((IJImageTransformerFactory)this.factory).setParameters(imageViewerParameters);
        }
        this.facade.saveImageTransformerFactory(this.dsIdentifiers, this.channel, this.factory);
    }

    public void loadImages(String filter) throws Throwable {
        final ImageSize thumbnailSize = new ImageSize(SettingsUtil.defaultThumbnailWidth, SettingsUtil.defaultThumbnailHeight);
        if (this.dsIdentifiers != null) {
            this.loadingThreads = new Thread[this.dsIdentifiers.size()];
        }
        int i = 0;
        for (final IDatasetIdentifier identifier : this.dsIdentifiers) {
            final List<WellPosition> wellPositions = this.dataSets.get(identifier.getDatasetCode()).getWellPositions();
            this.loadingThreads[i] = new Thread(new Runnable(){

                public void run() {
                    try {
                        OpenBISConnector.this.facade.loadImages(identifier, wellPositions, OpenBISConnector.this.channel, thumbnailSize, OpenBISConnector.this.createPlateImageHandler());
                    }
                    catch (Throwable t) {
                        OpenBISConnector.this.imageViewer.showErrorDialog("Error during loading data from OpenBIS", t, false);
                    }
                }
            });
            this.loadingThreads[i].start();
            ++i;
        }
    }

    private IPlateImageHandler createPlateImageHandler() {
        return new IPlateImageHandler(){

            public void handlePlateImage(final PlateImageReference plateImageReference, final byte[] imageFileBytes) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ByteArrayInputStream inputStream = null;
                        BufferedImage bufferedImage = null;
                        try {
                            inputStream = new ByteArrayInputStream(imageFileBytes);
                            bufferedImage = ImageIO.read(inputStream);
                            ImagePlus imagePlus = new ImagePlus("image", bufferedImage);
                            ImageHandler imageHandler = new ImageHandler(imagePlus, plateImageReference);
                            OpenBISConnector.this.imageViewer.getImagesList().initList(imageHandler);
                        }
                        catch (Throwable t) {
                            OpenBISConnector.this.imageViewer.showErrorDialog("Error during loading data from OpenBIS", t, false);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageHandler loadFullSizeImage(PlateImageReference plateImageReference) throws Throwable {
        ImageHandler imageHandler = null;
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            this.facade.loadImages(Collections.singletonList(plateImageReference), new ScreeningOpenbisServiceFacade.IImageOutputStreamProvider(){

                public OutputStream getOutputStream(PlateImageReference imageReference) throws IOException {
                    return outputStream;
                }
            }, true);
            if (outputStream != null) {
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                BufferedImage bufferedImage = null;
                bufferedImage = ImageIO.read(inputStream);
                ImagePlus imagePlus = new ImagePlus("image", bufferedImage);
                imageHandler = new ImageHandler(imagePlus, plateImageReference);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return imageHandler;
    }

    public void stopLoading() {
        if (this.loadingThreads != null) {
            for (Thread loadingThread : this.loadingThreads) {
                if (loadingThread == null || !loadingThread.isAlive() || loadingThread.isInterrupted()) continue;
                loadingThread.interrupt();
            }
        }
    }
}

