/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.DataTools;
import loci.common.HandleException;
import loci.common.IRandomAccess;

public abstract class StreamHandle
implements IRandomAccess {
    protected String file;
    protected DataInputStream stream;
    protected DataOutputStream outStream;
    protected long length;
    protected long fp = 0L;
    protected long mark;
    protected ByteOrder order = ByteOrder.BIG_ENDIAN;

    public void close() throws IOException {
        this.mark = 0L;
        this.fp = 0L;
        this.length = 0L;
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
        this.stream = null;
        this.outStream = null;
        this.file = null;
    }

    public long getFilePointer() throws IOException {
        return this.fp;
    }

    public long length() throws IOException {
        return this.length;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.stream.read(b, off, len);
        if (n >= 0) {
            this.fp += (long)n;
        } else {
            n = 0;
        }
        this.markManager();
        while (n < len && this.fp < this.length()) {
            int s = this.stream.read(b, off + n, len - n);
            this.fp += (long)s;
            n += s;
        }
        return n == -1 ? 0 : n;
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, 0, buffer.capacity());
    }

    public int read(ByteBuffer buffer, int off, int len) throws IOException {
        if (buffer.hasArray()) {
            return this.read(buffer.array(), off, len);
        }
        byte[] b = new byte[len];
        int n = this.read(b);
        buffer.put(b, off, len);
        return n;
    }

    public void seek(long pos) throws IOException {
        int n;
        long diff = pos - this.fp;
        this.fp = pos;
        if (diff < 0L) {
            this.resetStream();
            diff = this.fp;
        }
        int skipped = this.stream.skipBytes((int)diff);
        while ((long)skipped < diff && (n = this.stream.skipBytes((int)(diff - (long)skipped))) != 0) {
            skipped += n;
        }
    }

    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    public void write(ByteBuffer buf, int off, int len) throws IOException {
        buf.position(off);
        if (buf.hasArray()) {
            this.write(buf.array(), off, len);
        } else {
            byte[] b = new byte[len];
            buf.get(b);
            this.write(b);
        }
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public void setOrder(ByteOrder order) {
        this.order = order;
    }

    public boolean readBoolean() throws IOException {
        ++this.fp;
        return this.stream.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.fp;
        return this.stream.readByte();
    }

    public char readChar() throws IOException {
        ++this.fp;
        return this.stream.readChar();
    }

    public double readDouble() throws IOException {
        this.fp += 8L;
        double v = this.stream.readDouble();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? DataTools.swap(v) : v;
    }

    public float readFloat() throws IOException {
        this.fp += 4L;
        float v = this.stream.readFloat();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? DataTools.swap(v) : v;
    }

    public void readFully(byte[] b) throws IOException {
        this.stream.readFully(b);
        this.fp += (long)b.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
        this.fp += (long)len;
    }

    public int readInt() throws IOException {
        this.fp += 4L;
        int v = this.stream.readInt();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? DataTools.swap(v) : v;
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        this.fp += 8L;
        long v = this.stream.readLong();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? DataTools.swap(v) : v;
    }

    public short readShort() throws IOException {
        this.fp += 2L;
        short v = this.stream.readShort();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? DataTools.swap(v) : v;
    }

    public int readUnsignedByte() throws IOException {
        ++this.fp;
        return this.stream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public String readUTF() throws IOException {
        String s = this.stream.readUTF();
        this.fp += (long)s.length();
        return s;
    }

    public int skipBytes(int n) throws IOException {
        int skipped = 0;
        try {
            for (int i = 0; i < n; ++i) {
                if (this.readUnsignedByte() != -1) {
                    ++skipped;
                }
                this.markManager();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return skipped;
    }

    public void write(byte[] b) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            b = DataTools.swap(b);
        }
        this.outStream.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = DataTools.swap(v);
        }
        this.outStream.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeUTF(str);
    }

    protected abstract void resetStream() throws IOException;

    private void markManager() {
        if (this.fp >= this.mark + 0x100000L - 1L) {
            this.mark = this.fp;
            this.stream.mark(0x100000);
        }
    }
}

