/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.WriterWrapper;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;

public class BufferedImageWriter
extends WriterWrapper {
    private int numWritten = 0;

    public static BufferedImageWriter makeBufferedImageWriter(IFormatWriter w) {
        if (w instanceof BufferedImageWriter) {
            return (BufferedImageWriter)w;
        }
        return new BufferedImageWriter(w);
    }

    public BufferedImageWriter() {
    }

    public BufferedImageWriter(IFormatWriter r) {
        super(r);
    }

    public void saveImage(int no, BufferedImage image) throws FormatException, IOException {
        this.saveImage(no, image, 0, 0, image.getWidth(), image.getHeight());
    }

    public void saveImage(int no, BufferedImage image, int x, int y, int w, int h) throws FormatException, IOException {
        Class<?> dataType = this.getNativeDataType();
        if (BufferedImage.class.isAssignableFrom(dataType)) {
            this.savePlane(no, image, x, y, w, h);
        } else {
            byte[] buf = BufferedImageWriter.toBytes(image, this);
            this.saveBytes(no, buf, x, y, w, h);
        }
    }

    public void close() throws IOException {
        super.close();
        this.numWritten = 0;
    }

    public void saveImage(BufferedImage image, boolean last) throws FormatException, IOException {
        this.saveImage(image, 0, last, last);
    }

    public void saveImage(BufferedImage image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        this.setSeries(series);
        this.saveImage(this.numWritten++, image);
    }

    public static byte[] toBytes(BufferedImage image, IFormatWriter writer) {
        Boolean bigEndian;
        boolean littleEndian = false;
        int bpp = FormatTools.getBytesPerPixel(AWTImageTools.getPixelType(image));
        MetadataRetrieve r = writer.getMetadataRetrieve();
        if (r != null && (bigEndian = r.getPixelsBinDataBigEndian(writer.getSeries(), 0)) != null) {
            littleEndian = bigEndian == false;
        }
        byte[][] pixelBytes = AWTImageTools.getPixelBytes(image, littleEndian);
        byte[] buf = new byte[pixelBytes.length * pixelBytes[0].length];
        if (writer.isInterleaved()) {
            for (int i = 0; i < pixelBytes[0].length; i += bpp) {
                for (int j = 0; j < pixelBytes.length; ++j) {
                    System.arraycopy(pixelBytes[j], i, buf, i * pixelBytes.length + j * bpp, bpp);
                }
            }
        } else {
            for (int i = 0; i < pixelBytes.length; ++i) {
                System.arraycopy(pixelBytes[i], 0, buf, i * pixelBytes[0].length, pixelBytes[i].length);
            }
        }
        pixelBytes = null;
        return buf;
    }
}

