/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import java.awt.Choice;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.WindowTools;

public class SwapDialog
extends ImporterDialog
implements ItemListener {
    private Choice zChoice;
    private Choice cChoice;
    private Choice tChoice;

    public SwapDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isSwapDimensions();
    }

    protected GenericDialog constructDialog() {
        ImageProcessorReader reader = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        GenericDialog gd = new GenericDialog("Dimension swapping options");
        String[] labels = new String[]{"Z", "C", "T"};
        int[] sizes = new int[]{reader.getSizeZ(), reader.getSizeC(), reader.getSizeT()};
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            gd.addMessage("Series " + (s + 1) + ":\n");
            for (int i = 0; i < labels.length; ++i) {
                gd.addChoice(sizes[i] + "_planes", labels, labels[i]);
            }
        }
        List<Choice> choices = WindowTools.getChoices(gd);
        this.zChoice = choices.get(0);
        this.cChoice = choices.get(1);
        this.tChoice = choices.get(2);
        this.zChoice.addItemListener(this);
        this.cChoice.addItemListener(this);
        this.tChoice.addItemListener(this);
        WindowTools.addScrollBars((Container)gd);
        return gd;
    }

    protected boolean harvestResults(GenericDialog gd) {
        ImageProcessorReader reader = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            String z = gd.getNextChoice();
            String c = gd.getNextChoice();
            String t = gd.getNextChoice();
            if (z.equals(t) || z.equals(c) || c.equals(t)) {
                throw new IllegalStateException("Invalid swapping options - each axis can be used only once.");
            }
            String originalOrder = reader.getDimensionOrder();
            StringBuffer sb = new StringBuffer();
            sb.append("XY");
            for (int i = 2; i < originalOrder.length(); ++i) {
                if (originalOrder.charAt(i) == 'Z') {
                    sb.append(z);
                    continue;
                }
                if (originalOrder.charAt(i) == 'C') {
                    sb.append(c);
                    continue;
                }
                if (originalOrder.charAt(i) != 'T') continue;
                sb.append(t);
            }
            this.options.setInputOrder(s, sb.toString());
        }
        return true;
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        int zIndex = this.zChoice.getSelectedIndex();
        int cIndex = this.cChoice.getSelectedIndex();
        int tIndex = this.tChoice.getSelectedIndex();
        if (src == this.zChoice) {
            if (zIndex == cIndex) {
                this.cChoice.select(this.firstAvailable(zIndex, tIndex));
            } else if (zIndex == tIndex) {
                this.tChoice.select(this.firstAvailable(zIndex, cIndex));
            }
        } else if (src == this.cChoice) {
            if (cIndex == zIndex) {
                this.zChoice.select(this.firstAvailable(cIndex, tIndex));
            } else if (cIndex == tIndex) {
                this.tChoice.select(this.firstAvailable(zIndex, cIndex));
            }
        } else if (src == this.tChoice) {
            if (tIndex == zIndex) {
                this.zChoice.select(this.firstAvailable(cIndex, tIndex));
            } else if (tIndex == cIndex) {
                this.cChoice.select(this.firstAvailable(zIndex, tIndex));
            }
        }
    }

    private int firstAvailable(int ... index) {
        boolean minValue = false;
        int maxValue = 2;
        for (int v = 0; v <= 2; ++v) {
            boolean taken = false;
            for (int i : index) {
                if (v != i) continue;
                taken = true;
                break;
            }
            if (taken) continue;
            return v;
        }
        return -1;
    }
}

