/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import thredds.catalog.DataType;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.EarthLocationImpl;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.VariableSimpleAdapter;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class Nids2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;

    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)).equals("Level3/NIDS");
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuffer errlog) throws IOException {
        return new Nids2Dataset(ncd);
    }

    public DataType getScientificDataType() {
        return DataType.RADIAL;
    }

    public Nids2Dataset() {
    }

    public Nids2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "Nids 2 radar dataset";
        try {
            if (ds.findGlobalAttribute("isRadial").getNumericValue().intValue() == 0) {
                this.parseInfo.append("*** Dataset is not a radial data\n");
                throw new IOException("Dataset is not a radial data\n");
            }
        }
        catch (Throwable e) {
            System.err.println("CDM radial dataset failed to open this dataset " + e);
        }
        this.setEarthLocation();
        this.setTimeUnits();
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    public String getRadarID() {
        Attribute att = this.ds.findGlobalAttribute("ProductStation");
        if (att == null) {
            att = this.ds.findGlobalAttribute("Product_station");
        }
        return att.getStringValue();
    }

    public boolean isStationary() {
        return true;
    }

    public String getRadarName() {
        return this.ds.findGlobalAttribute("ProductStationName").getStringValue();
    }

    public String getDataFormat() {
        return "Level III";
    }

    public boolean isVolume() {
        return false;
    }

    protected void setEarthLocation() {
        double lat = 0.0;
        double lon = 0.0;
        double elev = 0.0;
        Attribute attLat = this.ds.findGlobalAttribute("RadarLatitude");
        Attribute attLon = this.ds.findGlobalAttribute("RadarLongitude");
        Attribute attElev = this.ds.findGlobalAttribute("RadarAltitude");
        try {
            if (attLat == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            lat = attLat.getNumericValue().doubleValue();
            if (attLon == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            lon = attLon.getNumericValue().doubleValue();
            if (attElev == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            elev = attElev.getNumericValue().intValue();
        }
        catch (Throwable e) {
            System.err.println("CDM radial dataset failed to open this dataset " + e);
        }
        this.origin = new EarthLocationImpl(lat, lon, elev);
    }

    protected void setTimeUnits() {
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = (DateUnit)SimpleUnit.factory(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = DateUnit.getStandardOrISO(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = DateUnit.getStandardOrISO(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    public VariableSimpleIF getDataVariable(String name) {
        CoordinateSystem cs;
        VariableEnhanced c = (VariableEnhanced)((Object)this.ds.findVariable(name));
        RadialCoordSys rcs = null;
        List<CoordinateSystem> csys = c.getCoordinateSystems();
        for (int j = 0; j < csys.size() && (rcs = RadialCoordSys.makeRadialCoordSys(this.parseInfo, cs = csys.get(j), c)) == null; ++j) {
        }
        if (rcs != null) {
            return this.makeRadialVariable(c, rcs);
        }
        return null;
    }

    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    protected RadialDatasetSweep.RadialVariable makeRadialVariable(VariableEnhanced varDS, RadialCoordSys gcs) {
        return new Nids2Variable(varDS, gcs);
    }

    public String getInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Nids2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        int nsweep = rv.getNumSweeps();
        System.out.println("*** radar Sweep number is: \n" + nsweep);
        RadialDatasetSweep.Sweep sw = rv.getSweep(0);
        float[] ddd = sw.readData();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        for (int i = 0; i < nrays; ++i) {
            float t = sw.getTime(i);
            assert (t > 0.0f);
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/NIDS/Level3_BBB_N3R_20050119_1548.nids";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(DataType.RADIAL, fileIn, null, new StringBuffer());
        rds.getRadarID();
        RadialDatasetSweep.RadialVariable rf = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("BaseReflectivity");
        rf.getSweep(0);
        String fileIn1 = "/home/yuanho/NIDS/Level3_BYX_N0V_20051013_0908.nids";
        RadialDatasetSweep rds1 = (RadialDatasetSweep)TypedDatasetFactory.open(DataType.RADIAL, fileIn1, null, new StringBuffer());
        RadialDatasetSweep.RadialVariable rf1 = (RadialDatasetSweep.RadialVariable)rds1.getDataVariable("RadialVelocity");
        rf1.getSweep(0);
        Nids2Dataset.testRadialVariable(rf);
    }

    private class Nids2Variable
    extends VariableSimpleAdapter
    implements RadialDatasetSweep.RadialVariable {
        int nrays;
        int ngates;
        RadialDatasetSweep.Sweep sweep;
        protected RadialCoordSys radialCoordsys;
        protected VariableEnhanced ve;

        private Nids2Variable(VariableEnhanced v, RadialCoordSys rcys) {
            super(v);
            this.ve = v;
            this.radialCoordsys = rcys;
            int[] shape = v.getShape();
            int count = v.getRank() - 1;
            this.ngates = shape[count];
            this.nrays = shape[--count];
            --count;
        }

        public float[] readAllData() throws IOException {
            Array allData;
            try {
                allData = this.ve.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        public int getNumSweeps() {
            return 1;
        }

        public RadialDatasetSweep.Sweep getSweep(int sn) {
            if (sn != 0) {
                return null;
            }
            if (this.sweep == null) {
                this.sweep = new Nids2Sweep();
            }
            return this.sweep;
        }

        public int getNumRadials() {
            return this.nrays;
        }

        public void clearVariableMemory() {
        }

        private class Nids2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;

            Nids2Sweep() {
                this.setMeanElevation();
                this.setMeanAzimuth();
            }

            private void setMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    try {
                        Array data = Nids2Variable.this.radialCoordsys.getElevationAxisDataCached();
                        this.meanElevation = MAMath.sumDouble(data) / (double)data.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanElevation = 0.0;
                    }
                }
            }

            public float getMeanElevation() {
                return (float)this.meanElevation;
            }

            private void setMeanAzimuth() {
                if (this.getType() != null) {
                    try {
                        Array data = Nids2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                        this.meanAzimuth = MAMath.sumDouble(data) / (double)data.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                } else {
                    this.meanAzimuth = 0.0;
                }
            }

            public float getMeanAzimuth() {
                return (float)this.meanAzimuth;
            }

            public int getNumRadials() {
                return Nids2Variable.this.nrays;
            }

            public int getNumGates() {
                return Nids2Variable.this.ngates;
            }

            public float[] readData() throws IOException {
                Array allData = null;
                int[] shape = Nids2Variable.this.ve.getShape();
                int[] origind = new int[Nids2Variable.this.ve.getRank()];
                try {
                    allData = Nids2Variable.this.ve.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }

            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = Nids2Variable.this.ve.getShape();
                int[] origind = new int[Nids2Variable.this.ve.getRank()];
                shape[0] = 1;
                origind[0] = ray;
                try {
                    rayData = Nids2Variable.this.ve.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public boolean isConic() {
                return true;
            }

            public float getElevation(int ray) throws IOException {
                Array data = Nids2Variable.this.radialCoordsys.getElevationAxisDataCached();
                Index index = data.getIndex();
                return data.getFloat(index.set(ray));
            }

            public float[] getElevation() throws IOException {
                Array data = Nids2Variable.this.radialCoordsys.getElevationAxisDataCached();
                return (float[])data.get1DJavaArray(Float.TYPE);
            }

            public float getAzimuth(int ray) throws IOException {
                Array data = Nids2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                Index index = data.getIndex();
                return data.getFloat(index.set(ray));
            }

            public float[] getAzimuth() throws IOException {
                Array data = Nids2Variable.this.radialCoordsys.getAzimuthAxisDataCached();
                return (float[])data.get1DJavaArray(Float.TYPE);
            }

            public float getRadialDistance(int gate) throws IOException {
                Array data = Nids2Variable.this.radialCoordsys.getRadialAxisDataCached();
                Index index = data.getIndex();
                return data.getFloat(index.set(gate));
            }

            public float getTime(int ray) throws IOException {
                Array timeData = Nids2Variable.this.radialCoordsys.getTimeAxisDataCached();
                Index timeIndex = timeData.getIndex();
                return timeData.getFloat(timeIndex.set(ray));
            }

            public float getBeamWidth() {
                return 0.95f;
            }

            public float getNyquistFrequency() {
                return 0.0f;
            }

            public float getRangeToFirstGate() {
                return 0.0f;
            }

            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public Date getStartingTime() {
                return Nids2Dataset.this.startDate;
            }

            public Date getEndingTime() {
                return Nids2Dataset.this.endDate;
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            public int getGateNumber() {
                return Nids2Variable.this.ngates;
            }

            public int getRadialNumber() {
                return Nids2Variable.this.nrays;
            }

            public EarthLocation getOrigin(int ray) {
                return Nids2Dataset.this.origin;
            }

            public int getSweepIndex() {
                return 0;
            }

            public void clearSweepMemory() {
            }
        }
    }
}

