/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.NetworkUtils;

public class AggregationFmrc
extends Aggregation {
    private static String definitionDir;
    private FmrcDefinition fmrcDefinition;
    private boolean debug = false;
    private boolean timeUnitsChange = false;

    public static void setDefinitionDirectory(String defDir) {
        definitionDir = defDir;
    }

    public AggregationFmrc(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, AggregationIF.Type.FORECAST_MODEL_COLLECTION, recheckS);
    }

    protected AggregationFmrc(NetcdfDataset ncd, String dimName, AggregationIF.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    public void setTimeUnitsChange(boolean timeUnitsChange) {
        this.timeUnitsChange = timeUnitsChange;
    }

    public void setInventoryDefinition(String invDef) {
        String path = NetworkUtils.resolveFile(definitionDir, invDef);
        this.fmrcDefinition = new FmrcDefinition();
        try {
            boolean ok = this.fmrcDefinition.readDefinitionXML(path);
            if (!ok) {
                logger.warn("FmrcDefinition file not found= " + path);
                this.fmrcDefinition = null;
            } else {
                this.spiObject = this.fmrcDefinition;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fmrcDefinition = null;
        }
    }

    protected void buildDataset(boolean isNew, CancelTask cancelTask) throws IOException {
        NetcdfDataset typicalDS;
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(cancelTask);
        NetcdfDataset netcdfDataset = typicalDS = typical instanceof NetcdfDataset ? (NetcdfDataset)typical : new NetcdfDataset(typical);
        if (typicalDS.getEnhanceMode() == NetcdfDataset.EnhanceMode.None) {
            typicalDS.enhance();
        }
        GridDataset typicalGds = new GridDataset(typicalDS);
        this.buildDataset(typicalDataset, typicalGds, cancelTask);
    }

    protected void buildDataset(Aggregation.Dataset typicalDataset, ucar.nc2.dt.GridDataset typicalGds, CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        DatasetConstructor.transferDataset(typicalGds.getNetcdfFile(), this.ncDataset, null);
        Group root = this.ncDataset.getRootGroup();
        root.addAttribute(new Attribute("Conventions", "CF-1.0, _Coordinates"));
        root.addAttribute(new Attribute("cdm_data_type", thredds.catalog.DataType.GRID.toString()));
        String dimName = this.getDimensionName();
        int nruns = this.getTotalCoords();
        Dimension aggDim = new Dimension(dimName, nruns);
        this.ncDataset.removeDimension(null, dimName);
        this.ncDataset.addDimension(null, aggDim);
        DataType coordType = DataType.STRING;
        VariableDS runtimeCoordVar = new VariableDS(this.ncDataset, null, null, dimName, coordType, dimName, null, null);
        runtimeCoordVar.addAttribute(new Attribute("long_name", "Run time for ForecastModelRunCollection"));
        runtimeCoordVar.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        runtimeCoordVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
        this.ncDataset.removeVariable(null, runtimeCoordVar.getShortName());
        this.ncDataset.addVariable(null, runtimeCoordVar);
        if (this.debug) {
            System.out.println("FmrcAggregation: added runtimeCoordVar " + runtimeCoordVar.getName());
        }
        ArrayObject.D1 runData = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{nruns});
        for (int j = 0; j < this.nestedDatasets.size(); ++j) {
            Aggregation.Dataset dataset = (Aggregation.Dataset)this.nestedDatasets.get(j);
            runData.set(j, dataset.getCoordValueString());
        }
        runtimeCoordVar.setCachedData(runData, true);
        if (this.fmrcDefinition != null) {
            List<FmrcDefinition.RunSeq> runSeq = this.fmrcDefinition.getRunSequences();
            for (FmrcDefinition.RunSeq seq : runSeq) {
                String timeDimName = seq.getName();
                boolean isRagged = false;
                int max_times = 0;
                for (Aggregation.Dataset dataset : this.nestedDatasets) {
                    ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(dataset.getCoordValueDate());
                    double[] offsets = timeCoord.getOffsetHours();
                    if ((max_times = Math.max(max_times, offsets.length)) == offsets.length) continue;
                    isRagged = true;
                }
                Dimension timeDim = new Dimension(timeDimName, max_times);
                this.ncDataset.removeDimension(null, timeDimName);
                this.ncDataset.addDimension(null, timeDim);
                Aggregation.Dataset firstDataset = (Aggregation.Dataset)this.nestedDatasets.get(0);
                Date baseDate = firstDataset.getCoordValueDate();
                String desc = "Coordinate variable for " + timeDimName + " dimension";
                String units = "hours since " + this.formatter.toDateTimeStringISO(baseDate);
                String dims = this.getDimensionName() + " " + timeDimName;
                VariableDS newV = new VariableDS(this.ncDataset, null, null, timeDimName, DataType.DOUBLE, dims, desc, units);
                Variable oldV = this.ncDataset.getRootGroup().findVariable(timeDimName);
                if (null != oldV) {
                    this.ncDataset.removeVariable(null, timeDimName);
                }
                this.ncDataset.addVariable(null, newV);
                newV.addAttribute(new Attribute("units", units));
                newV.addAttribute(new Attribute("long_name", desc));
                newV.addAttribute(new Attribute("standard_name", "time"));
                newV.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                if (isRagged) {
                    newV.addAttribute(new Attribute("missing_value", Double.NaN));
                }
                Array coordValues = this.calcTimeCoordinateFromDef(nruns, max_times, seq);
                newV.setCachedData(coordValues, true);
            }
            this.ncDataset.finish();
        } else {
            this.makeTimeCoordinate(typicalGds, cancelTask);
        }
        for (GridDatatype grid : typicalGds.getGrids()) {
            Variable v = (Variable)((Object)grid.getVariable());
            String dims = dimName + " " + v.getDimensionsString();
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, v.getShortName(), v.getDataType(), dims, null, null);
            vagg.setProxyReader(this);
            DatasetConstructor.transferVariableAttributes(v, vagg);
            vagg.addAttribute(new Attribute("_CoordinateAxes", dimName + " " + grid.getCoordinateSystem().getName()));
            vagg.addAttribute(new Attribute("coordinates", dimName + " " + grid.getCoordinateSystem().getName()));
            this.ncDataset.removeVariable(null, v.getShortName());
            this.ncDataset.addVariable(null, vagg);
            if (!this.debug) continue;
            System.out.println("FmrcAggregation: added grid " + v.getName());
        }
        this.ncDataset.finish();
        this.makeProxies(typicalDataset, this.ncDataset);
        this.ncDataset.enhance();
        typicalGds.close();
    }

    protected void makeTimeCoordinate(ucar.nc2.dt.GridDataset gds, CancelTask cancelTask) throws IOException {
        HashSet<CoordinateAxis1DTime> timeAxes = new HashSet<CoordinateAxis1DTime>();
        for (GridDatatype gridDatatype : gds.getGrids()) {
            GridCoordSystem gcc = gridDatatype.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcc.getTimeAxis1D();
            if (null == timeAxis) continue;
            timeAxes.add(timeAxis);
        }
        for (CoordinateAxis1D coordinateAxis1D : timeAxes) {
            String dims = this.dimName + " " + coordinateAxis1D.getDimensionsString();
            VariableDS vagg = new VariableDS(this.ncDataset, null, null, coordinateAxis1D.getShortName(), coordinateAxis1D.getDataType(), dims, null, null);
            DatasetConstructor.transferVariableAttributes(coordinateAxis1D, vagg);
            Attribute att = vagg.findAttribute("_CoordinateAliasForDimension");
            if (att != null) {
                vagg.remove(att);
            }
            this.ncDataset.removeVariable(null, coordinateAxis1D.getShortName());
            this.ncDataset.addVariable(null, vagg);
            if (!this.timeUnitsChange) {
                vagg.setProxyReader(this);
            } else {
                this.readTimeCoordinates(vagg, cancelTask);
            }
            if (this.debug) {
                System.out.println("FmrcAggregation: promoted timeCoord " + coordinateAxis1D.getName());
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    public Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        if (mainv.getShortName().equals(this.dimName)) {
            return this.readAggCoord(mainv, cancelTask);
        }
        List<Range> ranges = mainv.getRanges();
        List<Range> innerSection = ranges.subList(1, ranges.size());
        long fullSize = Range.computeSize(innerSection);
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        for (Aggregation.Dataset vnested : this.nestedDatasets) {
            Array varData = vnested.read(mainv, cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + fullSize);
            if (fullSize == varData.getSize()) continue;
            System.out.println("FMRC RAGGED TIME " + fullSize + " != " + varData.getSize());
        }
        return allData;
    }

    public Array read(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        long size = section.computeSize();
        if (size == mainv.getSize()) {
            return this.read(mainv, cancelTask);
        }
        if (mainv.getShortName().equals(this.dimName)) {
            return this.readAggCoord(mainv, section, cancelTask);
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array sectionData = Array.factory(dtype, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        long fullSize = Range.computeSize(innerSection);
        if (this.debug) {
            System.out.println("   agg wants range=" + mainv.getName() + "(" + joinRange + ")");
        }
        for (Aggregation.Dataset nested : this.nestedDatasets) {
            if (!nested.isNeeded(joinRange)) continue;
            Array varData = nested.read(mainv, cancelTask, innerSection);
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + fullSize);
            if (fullSize != varData.getSize()) {
                System.out.println("FMRC RAGGED HERE " + fullSize + " != " + varData.getSize());
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return sectionData;
    }

    protected void syncDataset(CancelTask cancelTask) throws IOException {
        logger.debug("syncDataset ");
        this.buildCoords(cancelTask);
        int nruns = this.getTotalCoords();
        String dimName = this.getDimensionName();
        Dimension aggDim = this.ncDataset.findDimension(dimName);
        aggDim.setLength(nruns);
        VariableDS runtimeCoord = (VariableDS)this.ncDataset.findVariable(dimName);
        runtimeCoord.setDimensions(runtimeCoord.getDimensionsString());
        ArrayObject.D1 runData = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{nruns});
        for (int j = 0; j < this.nestedDatasets.size(); ++j) {
            Aggregation.Dataset dataset = (Aggregation.Dataset)this.nestedDatasets.get(j);
            runData.set(j, dataset.getCoordValueString());
        }
        runtimeCoord.setCachedData(runData, true);
        if (this.fmrcDefinition != null) {
            List<FmrcDefinition.RunSeq> runSeq = this.fmrcDefinition.getRunSequences();
            for (FmrcDefinition.RunSeq seq : runSeq) {
                String timeDimName = seq.getName();
                int max_times = 0;
                for (Aggregation.Dataset dataset : this.nestedDatasets) {
                    ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(dataset.getCoordValueDate());
                    double[] offsets = timeCoord.getOffsetHours();
                    max_times = Math.max(max_times, offsets.length);
                }
                Dimension timeDim = this.ncDataset.findDimension(timeDimName);
                timeDim.setLength(max_times);
                Aggregation.Dataset firstDataset = (Aggregation.Dataset)this.nestedDatasets.get(0);
                Date baseDate = firstDataset.getCoordValueDate();
                String units = "hours since " + this.formatter.toDateTimeStringISO(baseDate);
                VariableDS timeCoord = (VariableDS)this.ncDataset.findVariable(timeDimName);
                timeCoord.setDimensions(timeCoord.getDimensionsString());
                timeCoord.addAttribute(new Attribute("units", units));
                timeCoord.setUnitsString(units);
                Array coordValues = this.calcTimeCoordinateFromDef(nruns, max_times, seq);
                timeCoord.setCachedData(coordValues, true);
            }
        }
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        Aggregation.DatasetProxyReader typicalDatasetProxy = new Aggregation.DatasetProxyReader(this, typicalDataset);
        ArrayList<CoordinateAxis> timeAxes = new ArrayList<CoordinateAxis>();
        List<Variable> vars = this.ncDataset.getVariables();
        for (Variable v : vars) {
            if (v instanceof CoordinateAxis) {
                CoordinateAxis axis = (CoordinateAxis)v;
                if (axis.getAxisType() == AxisType.Time) {
                    timeAxes.add(axis);
                }
                if (this.fmrcDefinition != null) continue;
            }
            if (v.getRank() > 0 && v.getDimension(0).getName().equals(dimName) && v != runtimeCoord) {
                v.setDimensions(v.getDimensionsString());
                v.setCachedData(null, false);
                continue;
            }
            VariableDS ve = (VariableDS)v;
            ProxyReader proxy = ve.getProxyReader();
            if (!(proxy instanceof Aggregation.DatasetProxyReader)) continue;
            ve.setProxyReader(typicalDatasetProxy);
        }
        if (this.fmrcDefinition == null) {
            for (CoordinateAxis timeAxis : timeAxes) {
                if (!this.timeUnitsChange) continue;
                this.readTimeCoordinates(timeAxis, cancelTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        Date[] dates;
        ArrayList<Date[]> dateList = new ArrayList<Date[]>();
        int maxTimes = 0;
        String units = null;
        for (int i = 0; i < this.nestedDatasets.size(); ++i) {
            NetcdfDataset ncfile = null;
            try {
                Aggregation.Dataset dataset = (Aggregation.Dataset)this.nestedDatasets.get(i);
                ncfile = (NetcdfDataset)dataset.acquireFile(cancelTask);
                VariableDS v = (VariableDS)ncfile.findVariable(timeAxis.getName());
                if (v == null) {
                    logger.warn("readTimeCoordinates: variable = " + timeAxis.getName() + " not found in file " + dataset.getLocation());
                    return;
                }
                CoordinateAxis1DTime timeCoordVar = CoordinateAxis1DTime.factory(this.ncDataset, v, null);
                dates = timeCoordVar.getTimeDates();
                maxTimes = Math.max(maxTimes, dates.length);
                dateList.add(dates);
                if (i == 0) {
                    units = v.getUnitsString();
                }
            }
            finally {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        int[] shape = timeAxis.getShape();
        int ntimes = shape[1];
        if (ntimes != maxTimes) {
            shape[1] = maxTimes;
            Dimension d = timeAxis.getDimension(1);
            d.setLength(maxTimes);
            timeAxis.setDimensions(timeAxis.getDimensionsString());
        }
        Array timeCoordVals = Array.factory(timeAxis.getDataType(), shape);
        Index ima = timeCoordVals.getIndex();
        timeAxis.setCachedData(timeCoordVals, false);
        if (timeAxis.getDataType() == DataType.STRING) {
            for (int i = 0; i < dateList.size(); ++i) {
                dates = (Date[])dateList.get(i);
                for (int j = 0; j < dates.length; ++j) {
                    Date date = dates[j];
                    timeCoordVals.setObject(ima.set(i, j), (Object)this.formatter.toDateTimeStringISO(date));
                }
            }
        } else {
            DateUnit du;
            try {
                du = new DateUnit(units);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            timeAxis.addAttribute(new Attribute("units", units));
            for (int i = 0; i < dateList.size(); ++i) {
                Date[] dates2 = (Date[])dateList.get(i);
                for (int j = 0; j < dates2.length; ++j) {
                    Date date = dates2[j];
                    double val = du.makeValue(date);
                    timeCoordVals.setDouble(ima.set(i, j), val);
                }
            }
        }
    }

    private Array calcTimeCoordinateFromDef(int nruns, int max_times, FmrcDefinition.RunSeq seq) {
        ArrayDouble.D2 coordValues = (ArrayDouble.D2)Array.factory(DataType.DOUBLE, new int[]{nruns, max_times});
        Date baseDate = null;
        for (int j = 0; j < this.nestedDatasets.size(); ++j) {
            int k;
            Aggregation.Dataset dataset = (Aggregation.Dataset)this.nestedDatasets.get(j);
            Date runTime = dataset.getCoordValueDate();
            if (baseDate == null) {
                baseDate = runTime;
            }
            double run_offset = ForecastModelRunInventory.getOffsetInHours(baseDate, runTime);
            ForecastModelRunInventory.TimeCoord timeCoord = seq.findTimeCoordByRuntime(runTime);
            double[] offsets = timeCoord.getOffsetHours();
            for (k = 0; k < offsets.length; ++k) {
                coordValues.set(j, k, offsets[k] + run_offset);
            }
            for (k = offsets.length; k < max_times; ++k) {
                coordValues.set(j, k, Double.NaN);
            }
        }
        return coordValues;
    }

    public static void main(String[] arg) throws IOException {
        String defaultFilename = "C:/data/rap/fmrc.xml";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        GridDataset gds = GridDataset.open(filename);
        GridDatatype gg = gds.findGridDatatype("T");
        GridCoordSystem gsys = gg.getCoordinateSystem();
        CoordinateAxis1DTime rtaxis = gsys.getRunTimeAxis();
        CoordinateAxis taxis2D = gsys.getTimeAxis();
        Array data = taxis2D.read();
        NCdump.printArray(data, "2D time array", System.out, null);
        System.out.println("Run Time, Valid Times");
        Date[] runtimes = rtaxis.getTimeDates();
        for (int i = 0; i < runtimes.length; ++i) {
            System.out.println("\n" + runtimes[i]);
            CoordinateAxis1DTime taxis = gsys.getTimeAxisForRun(i);
            Date[] times = taxis.getTimeDates();
            for (int j = 0; j < times.length; ++j) {
                System.out.println("   " + times[j]);
            }
        }
    }
}

