/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2;

import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonAsJavaDataSetRegistrationDropboxV2Wrapper;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonDataSetRegistrationServiceV2;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractProgrammableTopLevelDataSetHandler;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetRegistrationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class JythonTopLevelDataSetHandlerV2<T extends DataSetInformation>
extends AbstractProgrammableTopLevelDataSetHandler<T> {
    protected static final String FACTORY_VARIABLE_NAME = "factory";
    protected static final String SERVICE_VARIABLE_NAME = "service";
    protected static final String STATE_VARIABLE_NAME = "state";
    protected static final String INCOMING_DATA_SET_VARIABLE_NAME = "incoming";
    protected static final String TRANSACTION_VARIABLE_NAME = "transaction";
    public static final String SCRIPT_PATH_KEY = "script-path";
    protected final File scriptFile;

    public JythonTopLevelDataSetHandlerV2(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
        String path = PropertyUtils.getMandatoryProperty(globalState.getThreadParameters().getThreadProperties(), SCRIPT_PATH_KEY);
        this.scriptFile = new File(path);
        if (!this.scriptFile.isFile()) {
            throw ConfigurationFailureException.fromTemplate("Script file '%s' does not exist!", path);
        }
        DssRegistrationHealthMonitor.getInstance(globalState.getOpenBisService(), globalState.getRecoveryStateDir());
    }

    @Override
    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return this.createJythonDataSetRegistrationServiceV2(incomingDataSetFile, callerDataSetInformationOrNull, cleanAfterwardsAction, delegate, PythonInterpreter.createIsolatedPythonInterpreter(), this.getGlobalState());
    }

    protected DataSetRegistrationService<T> createJythonDataSetRegistrationServiceV2(DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate, PythonInterpreter pythonInterpreter, TopLevelDataSetRegistratorGlobalState globalState) {
        return new JythonDataSetRegistrationServiceV2(this, incomingDataSetFile, userProvidedDataSetInformationOrNull, cleanAfterwardsAction, delegate, pythonInterpreter, globalState);
    }

    private void configureEvaluator(File dataSetFile, JythonDataSetRegistrationService<T> service, PythonInterpreter interpreter) {
        interpreter.set(INCOMING_DATA_SET_VARIABLE_NAME, dataSetFile);
        interpreter.set(STATE_VARIABLE_NAME, this.getGlobalState());
        if (service != null) {
            interpreter.set(FACTORY_VARIABLE_NAME, service.getDataSetRegistrationDetailsFactory());
        }
    }

    protected void executeJythonScript(DataSetFile dataSetFile, String scriptString, JythonDataSetRegistrationService<T> service) {
        DssRegistrationLogger logger = service.getDssRegistrationLog();
        PythonInterpreter interpreter = service.getInterpreter();
        JythonAsJavaDataSetRegistrationDropboxV2Wrapper v2Programm = new JythonAsJavaDataSetRegistrationDropboxV2Wrapper(interpreter);
        logger.info(operationLog, "Compile python script");
        interpreter.exec(scriptString, this.scriptFile.getPath());
        this.verifyEvaluatorHookFunctions(interpreter);
        if (!v2Programm.isRetryFunctionDefined()) {
            logger.info(operationLog, "Start processing");
            v2Programm.process(this.wrapTransaction(service.transaction()));
        } else {
            this.executeProcessFunctionWithRetries(v2Programm, (JythonDataSetRegistrationServiceV2)service, dataSetFile);
        }
    }

    @Override
    public boolean shouldNotAddToFaultyPathsOrNull(File file) {
        return this.hasRecoveryMarkerFile(file);
    }

    @Override
    protected boolean hasRecoveryMarkerFile(File incoming) {
        return this.getGlobalState().getStorageRecoveryManager().getProcessingMarkerFile(incoming).exists();
    }

    @Override
    protected IJavaDataSetRegistrationDropboxV2 getV2DropboxProgram(DataSetRegistrationService<T> service) {
        return new JythonAsJavaDataSetRegistrationDropboxV2Wrapper(this.getInterpreterFromService(service));
    }

    @Override
    protected AbstractProgrammableTopLevelDataSetHandler.RecoveryHookAdaptor getRecoveryHookAdaptor(File incoming) {
        return new AbstractProgrammableTopLevelDataSetHandler.RecoveryHookAdaptor(this, incoming){
            IJavaDataSetRegistrationDropboxV2 v2ProgramInternal;

            @Override
            protected IJavaDataSetRegistrationDropboxV2 getV2DropboxProgramInternal() {
                if (this.v2ProgramInternal == null) {
                    PythonInterpreter internalInterpreter = PythonInterpreter.createIsolatedPythonInterpreter();
                    JythonTopLevelDataSetHandlerV2.this.configureEvaluator(this.incoming, null, internalInterpreter);
                    String scriptString = FileUtilities.loadToString(JythonTopLevelDataSetHandlerV2.this.scriptFile);
                    internalInterpreter.exec(scriptString);
                    JythonTopLevelDataSetHandlerV2.this.verifyEvaluatorHookFunctions(internalInterpreter);
                    this.v2ProgramInternal = new JythonAsJavaDataSetRegistrationDropboxV2Wrapper(internalInterpreter);
                }
                return this.v2ProgramInternal;
            }
        };
    }

    @Override
    public void handleDataSet(DataSetFile dataSetFile, DataSetRegistrationService<T> genericService) throws Throwable {
        String scriptString = FileUtilities.loadToString(this.scriptFile);
        JythonDataSetRegistrationService service = (JythonDataSetRegistrationService)genericService;
        this.waitUntilApplicationIsReady(genericService, dataSetFile);
        this.executeJythonScript(dataSetFile, scriptString, service);
    }

    protected void verifyEvaluatorHookFunctions(PythonInterpreter interpreter) {
        JythonHookFunction[] jythonHookFunctionArray = JythonHookFunction.values();
        int n = jythonHookFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JythonHookFunction function = jythonHookFunctionArray[n2];
            PyFunction py = this.tryJythonFunction(interpreter, function);
            if (py != null) {
                if (py.func_code instanceof PyBaseCode) {
                    int co_argcount = ((PyBaseCode)py.func_code).co_argcount;
                    if (co_argcount != function.argCount) {
                        throw new IllegalArgumentException(String.format("The function %s in %s has wrong number of arguments(%s instead of %s).", function.name, this.scriptFile.getName(), co_argcount, function.argCount));
                    }
                } else {
                    System.err.println("Possibly incorrect python code. Can't verify script correctness.");
                }
            }
            ++n2;
        }
    }

    protected PyFunction tryJythonFunction(PythonInterpreter interpreter, JythonHookFunction functionDefinition) {
        try {
            PyFunction function = (PyFunction)interpreter.get(functionDefinition.name, PyFunction.class);
            return function;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PyObject invokeFunction(PyFunction function, Object ... args) {
        PyObject[] pyArgs = new PyObject[args.length];
        int i = 0;
        while (i < args.length) {
            pyArgs[i] = Py.java2py((Object)args[i]);
            ++i;
        }
        return function.__call__(pyArgs);
    }

    protected PythonInterpreter getInterpreterFromService(DataSetRegistrationService<T> service) {
        PythonInterpreter interpreter = ((JythonDataSetRegistrationService)service).interpreter;
        return interpreter;
    }

    public static class JythonDataSetRegistrationService<T extends DataSetInformation>
    extends DataSetRegistrationService<T> {
        private final PythonInterpreter interpreter;

        public JythonDataSetRegistrationService(AbstractProgrammableTopLevelDataSetHandler<T> registrator, DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> globalCleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate, PythonInterpreter interpreter, TopLevelDataSetRegistratorGlobalState globalState) {
            super(registrator, incomingDataSetFile, registrator.createObjectFactory(userProvidedDataSetInformationOrNull), globalCleanAfterwardsAction, delegate);
            interpreter.set(JythonTopLevelDataSetHandlerV2.STATE_VARIABLE_NAME, globalState);
            this.interpreter = interpreter;
        }

        public PythonInterpreter getInterpreter() {
            return this.interpreter;
        }

        @Override
        public void cleanAfterRegistrationIfNecessary() {
            super.cleanAfterRegistrationIfNecessary();
            if (this.interpreter != null) {
                this.interpreter.releaseResources();
            }
        }
    }

    public static enum JythonHookFunction {
        PROCESS_FUNCTION("process", 1),
        ROLLBACK_SERVICE_FUNCTION_NAME("rollback_service", 2),
        ROLLBACK_TRANSACTION_FUNCTION_NAME("rollback_transaction", 4),
        COMMIT_TRANSACTION_FUNCTION_NAME("commit_transaction", 2),
        POST_STORAGE_FUNCTION_NAME("post_storage", 1),
        PRE_REGISTRATION_FUNCTION_NAME("pre_metadata_registration", 1),
        POST_REGISTRATION_FUNCTION_NAME("post_metadata_registration", 1),
        ROLLBACK_PRE_REGISTRATION_FUNCTION_NAME("rollback_pre_registration", 2),
        SHOULD_RETRY_PROCESS_FUNCTION_NAME("should_retry_processing", 2),
        DID_ENCOUNTER_SECONDARY_TRANSACTION_ERRORS_FUNCTION_NAME("did_encounter_secondary_transaction_errors", 3);

        public final String name;
        int argCount;

        private JythonHookFunction(String name, int argCount) {
            this.name = name;
            this.argCount = argCount;
        }
    }

    public static abstract class ProgrammableDropboxObjectFactory<T extends DataSetInformation>
    extends AbstractDataSetRegistrationDetailsFactory<T> {
        public ProgrammableDropboxObjectFactory(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState, DataSetInformation userProvidedDataSetInformationOrNull) {
            super(registratorState, userProvidedDataSetInformationOrNull);
        }

        public DataSetRegistrationDetails<T> createRegistrationDetails() {
            return this.createDataSetRegistrationDetails();
        }

        public Class<?> getClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

