/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSet;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.types.DataSetTypeCode;
import java.io.File;
import java.util.List;

public abstract class AbstractDataSetRegistrationDetailsFactory<T extends DataSetInformation>
implements IDataSetRegistrationDetailsFactory<T> {
    protected final AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState;
    protected final DataSetInformation userProvidedDataSetInformationOrNull;

    public AbstractDataSetRegistrationDetailsFactory(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState, DataSetInformation userProvidedDataSetInformationOrNull) {
        this.registratorState = registratorState;
        this.userProvidedDataSetInformationOrNull = userProvidedDataSetInformationOrNull;
    }

    @Override
    public String getUserIdOrNull() {
        return this.userProvidedDataSetInformationOrNull == null ? null : this.userProvidedDataSetInformationOrNull.getUploadingUserIdOrNull();
    }

    @Override
    public DataSetRegistrationDetails<T> createDataSetRegistrationDetails() {
        DataSetRegistrationDetails<T> registrationDetails = new DataSetRegistrationDetails<T>();
        T dataSetInfo = this.createDataSetInformation();
        if (this.userProvidedDataSetInformationOrNull != null) {
            this.applyUserProvidedValues(dataSetInfo);
            ((DataSetInformation)dataSetInfo).setUploadingUserId(this.userProvidedDataSetInformationOrNull.getUploadingUserIdOrNull());
        }
        if (((DataSetInformation)dataSetInfo).getDataSetType() == null) {
            this.setDataSetTypeToDefaultValue(dataSetInfo);
        }
        this.setDatabaseInstance((DataSetInformation)dataSetInfo);
        registrationDetails.setDataSetInformation(dataSetInfo);
        return registrationDetails;
    }

    @Override
    public DataSet<T> createDataSet(DataSetRegistrationDetails<T> registrationDetails, File stagingFile) {
        IEncapsulatedOpenBISService service = this.registratorState.getGlobalState().getOpenBisService();
        return new DataSet<T>(registrationDetails, stagingFile, service);
    }

    protected void applyUserProvidedValues(T dataSetInfo) {
        List<NewProperty> props;
        DataSetType type;
        ExperimentIdentifier experimentId;
        SampleIdentifier sampleId = this.userProvidedDataSetInformationOrNull.getSampleIdentifier();
        if (sampleId != null) {
            ((DataSetInformation)dataSetInfo).setSampleCode(sampleId.getSampleCode());
            ((DataSetInformation)dataSetInfo).setSpaceCode(sampleId.getSpaceLevel().getSpaceCode());
            ((DataSetInformation)dataSetInfo).setInstanceCode(sampleId.getSpaceLevel().getDatabaseInstanceCode());
        }
        if (this.userProvidedDataSetInformationOrNull.tryToGetSample() != null) {
            ((DataSetInformation)dataSetInfo).setSample(this.userProvidedDataSetInformationOrNull.tryToGetSample());
        }
        if ((experimentId = this.userProvidedDataSetInformationOrNull.getExperimentIdentifier()) != null) {
            ((DataSetInformation)dataSetInfo).setExperimentIdentifier(experimentId);
        }
        if (this.userProvidedDataSetInformationOrNull.tryToGetExperiment() != null) {
            ((DataSetInformation)dataSetInfo).setExperiment(this.userProvidedDataSetInformationOrNull.tryToGetExperiment());
        }
        if ((type = this.userProvidedDataSetInformationOrNull.getDataSetType()) != null) {
            ((DataSetInformation)dataSetInfo).setDataSetType(type);
        }
        if (!(props = this.userProvidedDataSetInformationOrNull.getDataSetProperties()).isEmpty()) {
            ((DataSetInformation)dataSetInfo).setDataSetProperties(props);
        }
        if (this.userProvidedDataSetInformationOrNull.getParentDataSetCodes() != null) {
            ((DataSetInformation)dataSetInfo).setParentDataSetCodes(this.userProvidedDataSetInformationOrNull.getParentDataSetCodes());
        }
    }

    protected void setDataSetTypeToDefaultValue(T dataSetInfo) {
        ((DataSetInformation)dataSetInfo).setDataSetType(new DataSetType(DataSetTypeCode.UNKNOWN.getCode()));
    }

    protected final void setDatabaseInstance(DataSetInformation dataSetInfo) {
        dataSetInfo.setInstanceCode(this.registratorState.getHomeDatabaseInstance().getCode());
        dataSetInfo.setInstanceUUID(this.registratorState.getHomeDatabaseInstance().getUuid());
    }

    protected abstract T createDataSetInformation();
}

