/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.security.TokenGenerator;
import java.util.ArrayList;
import java.util.List;

public class SessionTokenManager {
    private static final int MAX_NUMBER_OF_TOKENS = 2;
    private final List<String> sessionTokens = new ArrayList<String>();
    private final TokenGenerator tokenGenerator = new TokenGenerator();

    public synchronized String drawSessionToken() {
        String sessionToken = this.tokenGenerator.getNewToken(System.currentTimeMillis());
        this.sessionTokens.add(sessionToken);
        while (this.sessionTokens.size() > 2) {
            this.sessionTokens.remove(0);
        }
        return sessionToken;
    }

    public void assertValidSessionToken(String sessionToken) {
        if (!this.sessionTokens.contains(sessionToken)) {
            throw new InvalidAuthenticationException("Invalid session token.");
        }
    }
}

