/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DisplayedAndSelectedEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedIdHolderCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;

public final class SampleListDeletionConfirmationDialog<T extends IIdHolder>
extends AbstractDataListDeletionConfirmationDialog<T> {
    private final DisplayedAndSelectedEntities<T> selectedAndDisplayedItemsOrNull;
    private final T singleDataOrNull;

    public SampleListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<T> data, AsyncCallback<Void> callback, DisplayedAndSelectedEntities<T> selectedAndDisplayedItems) {
        super(viewContext, data, callback);
        this.withRadio();
        this.singleDataOrNull = null;
        this.selectedAndDisplayedItemsOrNull = selectedAndDisplayedItems;
        this.setId("deletion-confirmation-dialog");
    }

    public SampleListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<T> data, AsyncCallback<Void> deletionCallback, T sample) {
        super(viewContext, data, deletionCallback);
        this.singleDataOrNull = sample;
        this.selectedAndDisplayedItemsOrNull = null;
        this.setId("deletion-confirmation-dialog");
    }

    @Override
    protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
        DeletionType deletionType = this.getDeletionType();
        if (this.selectedAndDisplayedItemsOrNull != null) {
            DisplayedOrSelectedIdHolderCriteria<T> uploadCriteria = this.selectedAndDisplayedItemsOrNull.createCriteria(this.isOnlySelected());
            this.viewContext.getCommonService().deleteSamples(uploadCriteria, (String)this.reason.getValue(), deletionType, deletionCallback);
        } else {
            this.viewContext.getCommonService().deleteSample(TechId.create(this.singleDataOrNull), (String)this.reason.getValue(), deletionType, deletionCallback);
        }
    }

    @Override
    protected String getEntityName() {
        return EntityKind.SAMPLE.getDescription();
    }

    @Override
    protected final RadioGroup createRadio() {
        Radio one;
        int dataSize = ((List)this.data).size();
        this.onlySelectedRadioOrNull = one = WidgetUtils.createRadio(this.viewContext.getMessage("only_selected_radio", dataSize));
        Radio all = WidgetUtils.createRadio(this.viewContext.getMessage("all_radio", this.selectedAndDisplayedItemsOrNull.getDisplayedItemsCount()));
        String label = this.viewContext.getMessage("samples_radio_group_label", new Object[0]);
        return WidgetUtils.createAllOrSelectedRadioGroup(one, all, label, dataSize, this.createRefreshMessageAction());
    }
}

